/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j.util;

import java.util.Hashtable;
import org.marc4j.util.CharacterConverter;
import org.marc4j.util.CodeTableTracker;
import org.marc4j.util.ReverseCodeTable;

public class UnicodeToAnsel
implements CharacterConverter {
    protected ReverseCodeTable rct = new ReverseCodeTable(this.getClass().getResourceAsStream("resources/codetables.xml"));
    static final char ESC = '\u001b';
    static final char G0 = '(';
    static final char G0multibyte = '$';
    static final char G1 = ')';
    static final int ASCII = 66;

    public String convert(String string) {
        return new String(this.convert(string.toCharArray()));
    }

    public char[] convert(char[] cArray) {
        StringBuffer stringBuffer = new StringBuffer();
        CodeTableTracker codeTableTracker = new CodeTableTracker();
        boolean bl = false;
        int n = 0;
        while (n < cArray.length) {
            Character c = new Character(cArray[n]);
            StringBuffer stringBuffer2 = new StringBuffer();
            Hashtable hashtable = ReverseCodeTable.codeTableHash(c);
            if (hashtable.keySet().contains(codeTableTracker.getPrevious((byte)0))) {
                codeTableTracker.makePreviousCurrent();
                stringBuffer2.append((char[])hashtable.get(codeTableTracker.getPrevious((byte)0)));
            } else if (hashtable.keySet().contains(codeTableTracker.getPrevious((byte)1))) {
                codeTableTracker.makePreviousCurrent();
                stringBuffer2.append((char[])hashtable.get(codeTableTracker.getPrevious((byte)1)));
            } else {
                Integer n2 = (Integer)hashtable.keySet().iterator().next();
                char[] cArray2 = (char[])hashtable.get(n2);
                if (cArray2.length == 3) {
                    stringBuffer2.append('\u001b');
                    stringBuffer2.append('$');
                    codeTableTracker.setPrevious((byte)0, n2);
                } else if (cArray2[0] < '\u0080') {
                    stringBuffer2.append('\u001b');
                    if (n2 == 98 || n2 == 112) {
                        bl = true;
                    } else {
                        stringBuffer2.append('(');
                    }
                    codeTableTracker.setPrevious((byte)0, n2);
                } else {
                    stringBuffer2.append('\u001b');
                    stringBuffer2.append(')');
                    codeTableTracker.setPrevious((byte)1, n2);
                }
                stringBuffer2.append((char)n2.intValue());
                stringBuffer2.append(cArray2);
            }
            if (ReverseCodeTable.isCombining(c)) {
                stringBuffer.insert(stringBuffer.length() - 1, (Object)stringBuffer2);
            } else {
                stringBuffer.append(stringBuffer2);
            }
            ++n;
        }
        if (codeTableTracker.getPrevious((byte)0) != 66) {
            stringBuffer.append('\u001b');
            stringBuffer.append('(');
            stringBuffer.append('B');
        }
        return stringBuffer.toString().toCharArray();
    }

    public static void main(String[] stringArray) {
        char[] cArray = new char[]{'c', 'o', 'r', 'e', '[', '\u0303', '\u05d0', ']', 'y', '\u0660'};
        UnicodeToAnsel unicodeToAnsel = new UnicodeToAnsel();
        System.out.println(unicodeToAnsel.convert(cArray));
    }
}

