/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j.marcxml;

import java.util.HashMap;
import org.marc4j.MarcHandler;
import org.marc4j.marc.Leader;
import org.marc4j.marc.MarcException;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class MarcXmlHandler
extends DefaultHandler {
    private static final int COLLECTION_ID = 1;
    private static final int LEADER_ID = 2;
    private static final int RECORD_ID = 3;
    private static final int CONTROLFIELD_ID = 4;
    private static final int DATAFIELD_ID = 5;
    private static final int SUBFIELD_ID = 6;
    private static final String TAG_ATTR = "tag";
    private static final String CODE_ATTR = "code";
    private static final String IND_1_ATTR = "ind1";
    private static final String IND_2_ATTR = "ind2";
    private static final HashMap elementMap = new HashMap();
    private String code;
    private String tag;
    private Leader leader;
    private StringBuffer data = new StringBuffer();
    private MarcHandler mh;
    private Locator locator;

    public void setMarcHandler(MarcHandler marcHandler) {
        this.mh = marcHandler;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXParseException {
        String string4 = string2.length() == 0 ? string3 : string2;
        Integer n = (Integer)elementMap.get(string4);
        if (n == null) {
            return;
        }
        switch (n) {
            case 1: {
                if (this.mh == null) break;
                this.mh.startCollection();
                break;
            }
            case 2: {
                this.data.delete(0, this.data.length());
                break;
            }
            case 4: {
                if (attributes.getLength() < 1) {
                    throw new SAXParseException("Invalid controlfield", this.locator);
                }
                this.tag = attributes.getValue(TAG_ATTR);
                this.data.delete(0, this.data.length());
                break;
            }
            case 5: {
                if (attributes.getLength() < 3) {
                    throw new SAXParseException("Invalid datafield", this.locator);
                }
                this.tag = attributes.getValue(TAG_ATTR);
                String string5 = attributes.getValue(IND_1_ATTR);
                String string6 = attributes.getValue(IND_2_ATTR);
                if (this.mh != null) {
                    this.mh.startDataField(this.tag, string5.charAt(0), string6.charAt(0));
                }
                this.data.delete(0, this.data.length());
                break;
            }
            case 6: {
                this.code = attributes.getValue(CODE_ATTR);
                this.data.delete(0, this.data.length());
            }
        }
    }

    public void characters(char[] cArray, int n, int n2) {
        if (this.data != null) {
            this.data.append(cArray, n, n2);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXParseException {
        String string4 = string2.length() == 0 ? string3 : string2;
        Integer n = (Integer)elementMap.get(string4);
        if (n == null) {
            return;
        }
        switch (n) {
            case 1: {
                if (this.mh == null) break;
                this.mh.endCollection();
                break;
            }
            case 3: {
                if (this.mh == null) break;
                this.mh.endRecord();
                break;
            }
            case 2: {
                try {
                    if (this.mh == null) break;
                    this.mh.startRecord(new Leader(this.data.toString()));
                    break;
                }
                catch (MarcException marcException) {
                    throw new SAXParseException("Unable to unmarshal leader", this.locator);
                }
            }
            case 4: {
                if (this.mh == null) break;
                this.mh.controlField(this.tag, this.data.toString().toCharArray());
                break;
            }
            case 5: {
                if (this.mh != null) {
                    this.mh.endDataField(this.tag);
                }
                this.tag = null;
                break;
            }
            case 6: {
                char[] cArray = this.data.toString().toCharArray();
                if (this.mh != null) {
                    this.mh.subfield(this.code.charAt(0), cArray);
                }
                this.code = null;
            }
        }
    }

    static {
        elementMap.put("collection", new Integer(1));
        elementMap.put("leader", new Integer(2));
        elementMap.put("record", new Integer(3));
        elementMap.put("controlfield", new Integer(4));
        elementMap.put("datafield", new Integer(5));
        elementMap.put("subfield", new Integer(6));
    }
}

