/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j.marc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.marc4j.marc.ControlField;
import org.marc4j.marc.DataField;
import org.marc4j.marc.Directory;
import org.marc4j.marc.IllegalAddException;
import org.marc4j.marc.Leader;
import org.marc4j.marc.MarcException;
import org.marc4j.marc.Tag;
import org.marc4j.marc.VariableField;

public class Record
implements Serializable {
    private static final char RT = '\u001d';
    private static final char FT = '\u001e';
    private Leader leader;
    private List controlFieldList = new ArrayList();
    private List dataFieldList = new ArrayList();

    public Record() {
    }

    public Record(Leader leader) {
        this.add(leader);
    }

    public Leader getLeader() {
        return this.leader;
    }

    public void add(Leader leader) {
        this.leader = leader;
    }

    public void add(ControlField controlField) {
        String string = controlField.getTag();
        if (Tag.isControlNumberField(string)) {
            if (this.hasControlNumberField()) {
                throw new IllegalAddException(controlField.getClass().getName(), "control field number already exists");
            }
            this.controlFieldList.add(0, controlField);
        } else {
            this.controlFieldList.add(controlField);
        }
    }

    public void add(DataField dataField) {
        this.dataFieldList.add(dataField);
    }

    public ControlField getControlNumberField() {
        ControlField controlField = (ControlField)this.controlFieldList.get(0);
        if (controlField.getTag().equals("001")) {
            return controlField;
        }
        return null;
    }

    public String getControlNumber() {
        ControlField controlField = (ControlField)this.controlFieldList.get(0);
        if (controlField.getTag().equals("001")) {
            return new String(controlField.getData());
        }
        return null;
    }

    public ControlField getControlField(String string) {
        if (!Tag.isControlField(string)) {
            return null;
        }
        Iterator iterator = this.controlFieldList.iterator();
        while (iterator.hasNext()) {
            ControlField controlField = (ControlField)iterator.next();
            if (!controlField.getTag().equals(string)) continue;
            return controlField;
        }
        return null;
    }

    public boolean hasVariableField(String string) {
        List list = this.getVariableFieldList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            VariableField variableField = (VariableField)iterator.next();
            if (!variableField.getTag().equals(string)) continue;
            return true;
        }
        return false;
    }

    public DataField getDataField(String string) {
        if (!Tag.isDataField(string)) {
            return null;
        }
        Iterator iterator = this.dataFieldList.iterator();
        while (iterator.hasNext()) {
            DataField dataField = (DataField)iterator.next();
            if (!dataField.getTag().equals(string)) continue;
            return dataField;
        }
        return null;
    }

    public boolean hasControlNumberField() {
        if (this.controlFieldList.isEmpty()) {
            return false;
        }
        ControlField controlField = (ControlField)this.controlFieldList.get(0);
        return controlField.getTag().equals("001");
    }

    public List getControlFieldList() {
        return this.controlFieldList;
    }

    public void setControlFieldList(List list) {
        if (list == null) {
            this.controlFieldList = new ArrayList();
            return;
        }
        this.controlFieldList = new ArrayList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof ControlField) {
                this.add((ControlField)e);
                continue;
            }
            throw new IllegalAddException(e.getClass().getName(), "a collection of control fields can only contain ControlField objects.");
        }
    }

    public List getDataFieldList() {
        return this.dataFieldList;
    }

    public void setDataFieldList(List list) {
        if (list == null) {
            this.dataFieldList = new ArrayList();
            return;
        }
        this.dataFieldList = new ArrayList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof DataField) {
                this.add((DataField)e);
                continue;
            }
            throw new IllegalAddException(e.getClass().getName(), "a collection of data fields can only contain DataField objects.");
        }
    }

    public List getVariableFieldList() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.controlFieldList.iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        Iterator iterator2 = this.dataFieldList.iterator();
        while (iterator2.hasNext()) {
            arrayList.add(iterator2.next());
        }
        return arrayList;
    }

    public void setVariableFieldList(List list) {
        if (list == null) {
            this.controlFieldList = new ArrayList();
            this.dataFieldList = new ArrayList();
            return;
        }
        this.controlFieldList = new ArrayList();
        this.dataFieldList = new ArrayList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof ControlField) {
                this.add((ControlField)e);
                continue;
            }
            if (e instanceof DataField) {
                this.add((DataField)e);
                continue;
            }
            throw new IllegalAddException(e.getClass().getName(), "a collection of variable fields can only contain ControlField or DataField objects.");
        }
    }

    public String marshal() throws MarcException {
        Object object;
        if (this.leader == null) {
            throw new MarcException("Record contains no leader");
        }
        if (!this.hasControlNumberField()) {
            throw new MarcException("Record contains no control number field (tag 001)");
        }
        StringBuffer stringBuffer = new StringBuffer();
        Directory directory = new Directory();
        Iterator iterator = this.controlFieldList.iterator();
        while (iterator.hasNext()) {
            object = (ControlField)iterator.next();
            directory.add(((ControlField)object).getTag(), ((ControlField)object).getLength());
            stringBuffer.append(((ControlField)object).marshal());
        }
        object = this.dataFieldList.iterator();
        while (object.hasNext()) {
            DataField dataField = (DataField)object.next();
            directory.add(dataField.getTag(), dataField.getLength());
            stringBuffer.append(dataField.marshal());
        }
        int n = 24 + directory.getLength();
        int n2 = n + stringBuffer.length() + 1;
        this.leader.setRecordLength(n2);
        this.leader.setBaseAddressOfData(n);
        return this.leader.marshal() + directory.marshal() + stringBuffer + '\u001d';
    }
}

