/*
 * Decompiled with CFR 0.152.
 */
package com.topologi.diffx.xml;

import com.topologi.diffx.xml.UndeclaredNamespaceException;
import com.topologi.diffx.xml.XMLWriter;
import com.topologi.diffx.xml.XMLWriterBase;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;

public final class NSAwareXMLWriter
extends XMLWriterBase
implements XMLWriter {
    private static final boolean DEBUG = false;
    private static final PrefixMapping DEFAULT_NS = new PrefixMapping("", "");
    private static final Element ROOT;
    private Hashtable prefixMapping = new Hashtable();
    private List tempMapping = null;
    private List elements = new ArrayList();
    private boolean isNude = false;

    public NSAwareXMLWriter(Writer writer) throws NullPointerException {
        super(writer, true);
        this.elements.add(ROOT);
        this.prefixMapping.put("", "");
    }

    public NSAwareXMLWriter(Writer writer, boolean bl) throws NullPointerException {
        super(writer, bl);
        this.elements.add(ROOT);
        this.prefixMapping.put("", "");
    }

    public void writeComment(String string) throws IOException {
        this.deNude();
        super.writeComment(string);
    }

    public void writePI(String string, String string2) throws IOException {
        this.deNude();
        super.writePI(string, string2);
    }

    public void writeText(char c) throws IOException {
        this.deNude();
        this.writerEscape.writeText(c);
    }

    public void writeText(String string) throws IOException {
        if (string == null) {
            return;
        }
        this.deNude();
        this.writerEscape.writeText(string);
    }

    public void writeText(char[] cArray, int n, int n2) throws IOException {
        this.deNude();
        this.writerEscape.writeText(cArray, n, n2);
    }

    public void writeXML(String string) throws IOException {
        if (string == null) {
            return;
        }
        this.deNude();
        this.writer.write(string);
    }

    public void writeXML(char[] cArray, int n, int n2) throws IOException {
        this.deNude();
        this.writer.write(cArray, n, n2);
    }

    private void deNude() throws IOException {
        if (this.isNude) {
            this.writer.write(62);
            if (this.peekElement().hasChildren) {
                this.writer.write(10);
            }
            this.isNude = false;
        }
    }

    public void openElement(String string) throws IOException {
        this.openElement(null, string, false);
    }

    public void openElement(String string, String string2) throws IOException {
        this.openElement(string, string2, false);
    }

    public void openElement(String string, boolean bl) throws IOException {
        this.openElement(null, string, bl);
    }

    public void openElement(String string, String string2, boolean bl) throws IOException {
        this.deNude();
        this.indent();
        String string3 = this.getQName(string, string2);
        this.elements.add(new Element(string3, bl, this.tempMapping));
        this.writer.write(60);
        this.writer.write(string3);
        this.handleNamespaceDeclaration();
        this.isNude = true;
        ++this.depth;
    }

    public void closeElement() throws IOException {
        if (this.elements.size() <= 1) {
            return;
        }
        Element element = this.popElement();
        --this.depth;
        if (this.isNude) {
            this.writer.write(47);
            this.isNude = false;
        } else {
            if (element.hasChildren) {
                this.indent();
            }
            this.writer.write(60);
            this.writer.write(47);
            int n = element.qName.indexOf(32);
            if (n < 0) {
                this.writer.write(element.qName);
            } else {
                this.writer.write(element.qName.substring(0, n));
            }
        }
        this.restorePrefixMapping(element);
        this.writer.write(62);
        if (this.indent) {
            this.writer.write(10);
        }
    }

    public void emptyElement(String string) throws IOException {
        this.emptyElement(null, string);
    }

    public void emptyElement(String string, String string2) throws IOException {
        this.deNude();
        this.indent();
        this.writer.write(60);
        this.writer.write(this.getQName(string, string2));
        this.handleNamespaceDeclaration();
        this.writer.write(47);
        this.writer.write(62);
        if (this.indent) {
            this.writer.write(10);
        }
    }

    private Element peekElement() {
        return (Element)this.elements.get(this.elements.size() - 1);
    }

    private Element popElement() {
        return (Element)this.elements.remove(this.elements.size() - 1);
    }

    public void attribute(String string, String string2) throws IOException, IllegalStateException {
        if (!this.isNude) {
            throw new IllegalArgumentException("Cannot write attribute: too late!");
        }
        this.writer.write(32);
        this.writer.write(string);
        this.writer.write("=\"");
        this.writerEscape.writeAttValue(string2);
        this.writer.write(34);
    }

    public void attribute(String string, int n) throws IOException, IllegalStateException {
        if (!this.isNude) {
            throw new IllegalArgumentException("Cannot write attribute: too late!");
        }
        this.writer.write(32);
        this.writer.write(string);
        this.writer.write("=\"");
        this.writer.write(Integer.toString(n));
        this.writer.write(34);
    }

    public void attribute(String string, String string2, String string3) throws IOException, IllegalStateException {
        if (!this.isNude) {
            throw new IllegalArgumentException("Cannot write attribute: too late!");
        }
        this.writer.write(32);
        this.writer.write(this.getQName(string, string2));
        this.writer.write("=\"");
        this.writerEscape.writeAttValue(string3);
        this.writer.write(34);
        this.handleNamespaceDeclaration();
    }

    public void attribute(String string, String string2, int n) throws IOException, IllegalStateException {
        if (!this.isNude) {
            throw new IllegalArgumentException("Cannot write attribute: too late!");
        }
        this.writer.write(32);
        this.writer.write(this.getQName(string, string2));
        this.writer.write("=\"");
        this.writer.write(Integer.toString(n));
        this.writer.write(34);
        this.handleNamespaceDeclaration();
    }

    public void setPrefixMapping(String string, String string2) throws NullPointerException {
        if (!string2.equals(this.prefixMapping.get(string))) {
            this.removeIfNeeded(string2);
            PrefixMapping prefixMapping = new PrefixMapping(string2, string);
            this.prefixMapping.put(prefixMapping.uri, prefixMapping.prefix);
            if (this.tempMapping == null) {
                this.tempMapping = new ArrayList();
            }
            this.tempMapping.add(prefixMapping);
        }
    }

    private String getQName(String string, String string2) throws UndeclaredNamespaceException {
        String string3 = (String)this.prefixMapping.get(string != null ? string : "");
        if (string3 != null) {
            if (!"".equals(string3)) {
                return this.prefixMapping.get(string) + ":" + string2;
            }
            return string2;
        }
        throw new UndeclaredNamespaceException(string);
    }

    private void handleNamespaceDeclaration() throws IOException {
        if (this.tempMapping != null) {
            PrefixMapping prefixMapping = null;
            for (int i = 0; i < this.tempMapping.size(); ++i) {
                prefixMapping = (PrefixMapping)this.tempMapping.get(i);
                this.writer.write(" xmlns");
                if (!"".equals(prefixMapping.prefix)) {
                    this.writer.write(58);
                    this.writer.write(prefixMapping.prefix);
                }
                this.writer.write("=\"");
                this.writer.write(prefixMapping.uri);
                this.writer.write("\"");
            }
            this.tempMapping = null;
        }
    }

    private void restorePrefixMapping(Element element) {
        if (element.mappings != null) {
            for (int i = 0; i < element.mappings.size(); ++i) {
                PrefixMapping prefixMapping = (PrefixMapping)element.mappings.get(i);
                block1: for (int j = this.elements.size() - 1; j > 0; --j) {
                    if (((Element)this.elements.get(j)).mappings == null) continue;
                    List list = ((Element)this.elements.get(j)).mappings;
                    for (int k = 0; k < list.size(); ++k) {
                        PrefixMapping prefixMapping2 = (PrefixMapping)list.get(k);
                        if (!prefixMapping2.prefix.equals(prefixMapping.prefix)) continue;
                        this.removeIfNeeded(prefixMapping2.prefix);
                        this.prefixMapping.put(prefixMapping2.uri, prefixMapping2.prefix);
                        j = 0;
                        continue block1;
                    }
                }
            }
        }
    }

    private void removeIfNeeded(String string) {
        if (this.prefixMapping.containsValue(string)) {
            Object var2_2 = null;
            Enumeration enumeration = this.prefixMapping.keys();
            while (enumeration.hasMoreElements() && !this.prefixMapping.get(var2_2 = enumeration.nextElement()).equals(string)) {
            }
            this.prefixMapping.remove(var2_2);
        }
    }

    static {
        ArrayList<PrefixMapping> arrayList = new ArrayList<PrefixMapping>();
        arrayList.add(DEFAULT_NS);
        ROOT = new Element("", true, arrayList);
    }

    private static final class PrefixMapping {
        private final String prefix;
        private final String uri;

        public PrefixMapping(String string, String string2) {
            this.prefix = string != null ? string : "";
            this.uri = string2 != null ? string2 : "";
        }
    }

    private static final class Element {
        private String qName;
        private boolean hasChildren;
        private final List mappings;

        public Element(String string, boolean bl, List list) {
            this.qName = string;
            this.hasChildren = bl;
            this.mappings = list;
        }
    }
}

