/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

import com.sleepycat.db.CacheFile;
import com.sleepycat.db.CompactConfig;
import com.sleepycat.db.CompactStats;
import com.sleepycat.db.Cursor;
import com.sleepycat.db.CursorConfig;
import com.sleepycat.db.DatabaseConfig;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.DatabaseStats;
import com.sleepycat.db.Environment;
import com.sleepycat.db.JoinConfig;
import com.sleepycat.db.JoinCursor;
import com.sleepycat.db.KeyRange;
import com.sleepycat.db.LockMode;
import com.sleepycat.db.OperationStatus;
import com.sleepycat.db.Sequence;
import com.sleepycat.db.SequenceConfig;
import com.sleepycat.db.StatsConfig;
import com.sleepycat.db.Transaction;
import com.sleepycat.db.VerifyConfig;
import com.sleepycat.db.internal.Db;
import com.sleepycat.db.internal.DbSequence;
import com.sleepycat.db.internal.Dbc;
import java.io.FileNotFoundException;
import java.io.PrintStream;

public class Database {
    Db db;
    private int autoCommitFlag;
    int rmwFlag;

    Database(Db db) throws DatabaseException {
        this.db = db;
        db.wrapper = this;
        this.autoCommitFlag = db.get_transactional() ? 0x2000000 : 0;
        this.rmwFlag = (db.get_env().get_open_flags() & 0x20000) != 0 ? 0x40000000 : 0;
    }

    public Database(String filename, String databaseName, DatabaseConfig config) throws DatabaseException, FileNotFoundException {
        this(DatabaseConfig.checkNull(config).openDatabase(null, null, filename, databaseName));
        new Environment(this.db.get_env());
    }

    public void close(boolean noSync) throws DatabaseException {
        this.db.close(noSync ? 21 : 0);
    }

    public void close() throws DatabaseException {
        this.close(false);
    }

    public CompactStats compact(Transaction txn, DatabaseEntry start, DatabaseEntry stop, DatabaseEntry end, CompactConfig config) throws DatabaseException {
        config = CompactConfig.checkNull(config);
        CompactStats compact = new CompactStats(config.getFillPercent(), config.getTimeout(), config.getMaxPages());
        this.db.compact(txn == null ? null : txn.txn, start, stop, compact, config.getFlags(), end);
        return compact;
    }

    public Cursor openCursor(Transaction txn, CursorConfig config) throws DatabaseException {
        return new Cursor(this, CursorConfig.checkNull(config).openCursor(this.db, txn == null ? null : txn.txn), config);
    }

    public Sequence openSequence(Transaction txn, DatabaseEntry key, SequenceConfig config) throws DatabaseException {
        return new Sequence(SequenceConfig.checkNull(config).openSequence(this.db, txn == null ? null : txn.txn, key), config);
    }

    public void removeSequence(Transaction txn, DatabaseEntry key, SequenceConfig config) throws DatabaseException {
        config = SequenceConfig.checkNull(config);
        DbSequence seq = config.openSequence(this.db, txn == null ? null : txn.txn, key);
        seq.remove(txn == null ? null : txn.txn, txn == null && this.db.get_transactional() ? 0x2000000 | (config.getAutoCommitNoSync() ? 512 : 0) : 0);
    }

    public String getDatabaseFile() throws DatabaseException {
        return this.db.get_filename();
    }

    public String getDatabaseName() throws DatabaseException {
        return this.db.get_dbname();
    }

    public DatabaseConfig getConfig() throws DatabaseException {
        return new DatabaseConfig(this.db);
    }

    public void setConfig(DatabaseConfig config) throws DatabaseException {
        config.configureDatabase(this.db, this.getConfig());
    }

    public Environment getEnvironment() throws DatabaseException {
        return this.db.get_env().wrapper;
    }

    public CacheFile getCacheFile() throws DatabaseException {
        return new CacheFile(this.db.get_mpf());
    }

    public OperationStatus append(Transaction txn, DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
        return OperationStatus.fromInt(this.db.put(txn == null ? null : txn.txn, key, data, 2 | (txn == null ? this.autoCommitFlag : 0)));
    }

    public OperationStatus consume(Transaction txn, DatabaseEntry key, DatabaseEntry data, boolean wait) throws DatabaseException {
        return OperationStatus.fromInt(this.db.get(txn == null ? null : txn.txn, key, data, (wait ? 5 : 4) | (txn == null ? this.autoCommitFlag : 0)));
    }

    public OperationStatus delete(Transaction txn, DatabaseEntry key) throws DatabaseException {
        return OperationStatus.fromInt(this.db.del(txn == null ? null : txn.txn, key, txn == null ? this.autoCommitFlag : 0));
    }

    public OperationStatus exists(Transaction txn, DatabaseEntry key) throws DatabaseException {
        return OperationStatus.fromInt(this.db.exists(txn == null ? null : txn.txn, key, txn == null ? this.autoCommitFlag : 0));
    }

    public OperationStatus get(Transaction txn, DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        return OperationStatus.fromInt(this.db.get(txn == null ? null : txn.txn, key, data, LockMode.getFlag(lockMode) | (data == null ? 0 : data.getMultiFlag())));
    }

    public KeyRange getKeyRange(Transaction txn, DatabaseEntry key) throws DatabaseException {
        KeyRange range = new KeyRange();
        this.db.key_range(txn == null ? null : txn.txn, key, range, 0);
        return range;
    }

    public OperationStatus getSearchBoth(Transaction txn, DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        return OperationStatus.fromInt(this.db.get(txn == null ? null : txn.txn, key, data, 8 | LockMode.getFlag(lockMode) | (data == null ? 0 : data.getMultiFlag())));
    }

    public OperationStatus getSearchRecordNumber(Transaction txn, DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        return OperationStatus.fromInt(this.db.get(txn == null ? null : txn.txn, key, data, 0x1C | LockMode.getFlag(lockMode) | (data == null ? 0 : data.getMultiFlag())));
    }

    public OperationStatus put(Transaction txn, DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
        return OperationStatus.fromInt(this.db.put(txn == null ? null : txn.txn, key, data, txn == null ? this.autoCommitFlag : 0));
    }

    public OperationStatus putNoDupData(Transaction txn, DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
        return OperationStatus.fromInt(this.db.put(txn == null ? null : txn.txn, key, data, 0x13 | (txn == null ? this.autoCommitFlag : 0)));
    }

    public OperationStatus putNoOverwrite(Transaction txn, DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
        return OperationStatus.fromInt(this.db.put(txn == null ? null : txn.txn, key, data, 0x14 | (txn == null ? this.autoCommitFlag : 0)));
    }

    public JoinCursor join(Cursor[] cursList, JoinConfig config) throws DatabaseException {
        config = JoinConfig.checkNull(config);
        Dbc[] dbcList = new Dbc[cursList.length];
        for (int i = 0; i < cursList.length; ++i) {
            dbcList[i] = cursList[i] == null ? null : cursList[i].dbc;
        }
        return new JoinCursor(this, this.db.join(dbcList, config.getFlags()), config);
    }

    public int truncate(Transaction txn, boolean countRecords) throws DatabaseException {
        int count = this.db.truncate(txn == null ? null : txn.txn, txn == null ? this.autoCommitFlag : 0);
        return countRecords ? count : -1;
    }

    public DatabaseStats getStats(Transaction txn, StatsConfig config) throws DatabaseException {
        return (DatabaseStats)this.db.stat(txn == null ? null : txn.txn, StatsConfig.checkNull(config).getFlags());
    }

    public static void remove(String fileName, String databaseName, DatabaseConfig config) throws DatabaseException, FileNotFoundException {
        Db db = DatabaseConfig.checkNull(config).createDatabase(null);
        db.remove(fileName, databaseName, 0);
    }

    public static void rename(String fileName, String oldDatabaseName, String newDatabaseName, DatabaseConfig config) throws DatabaseException, FileNotFoundException {
        Db db = DatabaseConfig.checkNull(config).createDatabase(null);
        db.rename(fileName, oldDatabaseName, newDatabaseName, 0);
    }

    public void sync() throws DatabaseException {
        this.db.sync(0);
    }

    public static void upgrade(String fileName, DatabaseConfig config) throws DatabaseException, FileNotFoundException {
        Db db = DatabaseConfig.checkNull(config).createDatabase(null);
        db.upgrade(fileName, config.getSortedDuplicates() ? 65536 : 0);
        db.close(0);
    }

    public static boolean verify(String fileName, String databaseName, PrintStream dumpStream, VerifyConfig verifyConfig, DatabaseConfig dbConfig) throws DatabaseException, FileNotFoundException {
        Db db = DatabaseConfig.checkNull(dbConfig).createDatabase(null);
        return db.verify(fileName, databaseName, dumpStream, VerifyConfig.checkNull(verifyConfig).getFlags());
    }
}

