/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.test;

import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.test.FTPTestCase;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestDirOperations
extends FTPTestCase {
    private static String cvsId = "@(#)$Id: TestDirOperations.java,v 1.4 2004/05/01 17:05:43 bruceb Exp $";
    static /* synthetic */ Class class$com$enterprisedt$net$ftp$test$TestDirOperations;

    protected String getLogName() {
        return "TestDirOperations.log";
    }

    public void testDir() throws Exception {
        this.log.debug("testMkDir()");
        this.connect();
        this.login();
        this.ftp.chdir(this.testdir);
        String dir = this.generateRandomFilename();
        this.ftp.mkdir(dir);
        this.ftp.chdir(dir);
        String wd = this.ftp.pwd();
        this.log.debug("PWD: " + wd);
        TestDirOperations.assertTrue((wd.indexOf(dir) >= 0 ? 1 : 0) != 0);
        this.ftp.chdir("..");
        this.ftp.rmdir(dir);
        try {
            this.ftp.chdir(dir);
            TestDirOperations.fail((String)("chdir(" + dir + ") should have failed!"));
        }
        catch (FTPException ex) {
            this.log.debug("Expected exception: " + ex.getMessage());
        }
        this.ftp.quit();
    }

    public void testRenameDir() throws Exception {
        this.log.debug("testRenameDir()");
        this.connect();
        this.login();
        this.ftp.chdir(this.testdir);
        String dir1 = this.generateRandomFilename();
        this.ftp.mkdir(dir1);
        this.ftp.chdir(dir1);
        this.ftp.chdir("..");
        String dir2 = new StringBuffer(dir1).reverse().toString();
        this.ftp.rename(dir1, dir2);
        this.ftp.chdir(dir2);
        String wd = this.ftp.pwd();
        TestDirOperations.assertTrue((wd.indexOf(dir2) >= 0 ? 1 : 0) != 0);
        this.ftp.chdir("..");
        this.ftp.rmdir(dir2);
        try {
            this.ftp.chdir(dir2);
            TestDirOperations.fail((String)("chdir(" + dir2 + ") should have failed!"));
        }
        catch (FTPException ex) {
            this.log.debug("Expected exception: " + ex.getMessage());
        }
        this.ftp.quit();
    }

    public static Test suite() {
        return new TestSuite(class$com$enterprisedt$net$ftp$test$TestDirOperations == null ? (class$com$enterprisedt$net$ftp$test$TestDirOperations = TestDirOperations.class$("com.enterprisedt.net.ftp.test.TestDirOperations")) : class$com$enterprisedt$net$ftp$test$TestDirOperations);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TestDirOperations.suite());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

