/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPFile;
import com.enterprisedt.net.ftp.FTPFileParser;
import com.enterprisedt.net.ftp.UnixFileParser;
import com.enterprisedt.net.ftp.WindowsFileParser;
import com.enterprisedt.util.debug.Logger;
import java.text.ParseException;

public class FTPFileFactory {
    public static String cvsId = "@(#)$Id: FTPFileFactory.java,v 1.4 2004/07/23 08:31:52 bruceb Exp $";
    private Logger log = Logger.getLogger(class$com$enterprisedt$net$ftp$FTPFileFactory == null ? (class$com$enterprisedt$net$ftp$FTPFileFactory = FTPFileFactory.class$("com.enterprisedt.net.ftp.FTPFileFactory")) : class$com$enterprisedt$net$ftp$FTPFileFactory);
    static final String WINDOWS_STR = "WINDOWS";
    static final String UNIX_STR = "UNIX";
    private String system;
    private FTPFileParser windows = new WindowsFileParser();
    private FTPFileParser unix = new UnixFileParser();
    private FTPFileParser parser = null;
    private boolean rotateParsers = true;
    static /* synthetic */ Class class$com$enterprisedt$net$ftp$FTPFileFactory;

    FTPFileFactory(String system) throws FTPException {
        this.setParser(system);
    }

    public FTPFileFactory(FTPFileParser parser) {
        this.parser = parser;
        this.rotateParsers = false;
    }

    private void setParser(String system) throws FTPException {
        this.system = system;
        if (system.toUpperCase().startsWith(WINDOWS_STR)) {
            this.parser = this.windows;
        } else if (system.toUpperCase().startsWith(UNIX_STR)) {
            this.parser = this.unix;
        } else {
            throw new FTPException("Unknown SYST: " + system);
        }
    }

    FTPFile[] parse(String[] files) throws ParseException {
        FTPFile[] temp = new FTPFile[files.length];
        if (files.length == 0) {
            return temp;
        }
        int count = 0;
        for (int i = 0; i < files.length; ++i) {
            try {
                FTPFile file = this.parser.parse(files[i]);
                if (file == null) continue;
                temp[count++] = file;
                continue;
            }
            catch (ParseException ex) {
                if (this.rotateParsers && count == 0) {
                    this.rotateParsers();
                    FTPFile file = this.parser.parse(files[i]);
                    if (file == null) continue;
                    temp[count++] = file;
                    continue;
                }
                throw ex;
            }
        }
        FTPFile[] result = new FTPFile[count];
        System.arraycopy(temp, 0, result, 0, count);
        return result;
    }

    private void rotateParsers() {
        if (this.parser == this.unix) {
            this.parser = this.windows;
            this.log.info("Rotated parser to Windows");
        } else if (this.parser == this.windows) {
            this.parser = this.unix;
            this.log.info("Rotated parser to Unix");
        }
    }

    public String getSystem() {
        return this.system;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

