/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.LinkedList;
import org.cdlib.xtf.util.PackedByteBuf;
import org.cdlib.xtf.util.StructuredStore;
import org.cdlib.xtf.util.SubFileReader;
import org.cdlib.xtf.util.SubFileWriter;
import org.cdlib.xtf.util.SubStoreReader;
import org.cdlib.xtf.util.SubStoreWriter;
import org.cdlib.xtf.util.Tester;

public class StructuredFile
implements StructuredStore {
    private File file;
    private RandomAccessFile realFile;
    private int dirPos;
    private Directory dir;
    private SubFileWriter creatingSubfile;
    private DirEntry creatingEnt;
    private LinkedList openSubfiles = new LinkedList();
    Object curSubFile = null;
    private int openCount = 0;
    private static HashMap fileMap = new HashMap();
    public static final Tester tester = new Tester("StructuredFile"){

        protected void testImpl() throws Exception {
            File testFile = new File("test.sf");
            StructuredFile f = null;
            try {
                f = StructuredFile.create(testFile);
                f.close();
                f = StructuredFile.open(testFile);
                SubStoreWriter sfw1 = f.createSubStore("foo");
                sfw1.writeInt(1);
                sfw1.writeByte(2);
                sfw1.writeInt(3);
                sfw1.close();
                SubStoreWriter sfw2 = f.createSubStore("foo2");
                sfw2.writeByte(8);
                sfw2.writeInt(9);
                sfw2.close();
                f.close();
                f = StructuredFile.open(testFile);
                SubStoreReader sfr2 = f.openSubStore("foo2");
                SubStoreReader sfr1 = f.openSubStore("foo");
                if (!$assertionsDisabled && sfr2.readByte() != 8) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && sfr1.readInt() != 1) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && sfr1.readByte() != 2) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && sfr2.readInt() != 9) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && sfr1.readInt() != 3) {
                    throw new AssertionError();
                }
                boolean ok = false;
                try {
                    sfr1.readInt();
                }
                catch (EOFException e) {
                    ok = true;
                }
                if (!$assertionsDisabled && !ok) {
                    throw new AssertionError();
                }
                ok = false;
                try {
                    sfr2.readByte();
                }
                catch (EOFException e) {
                    ok = true;
                }
                if (!$assertionsDisabled && !ok) {
                    throw new AssertionError();
                }
                sfr1.seek(4L);
                if (!$assertionsDisabled && sfr1.readByte() != 2) {
                    throw new AssertionError();
                }
                sfr1.seek(0L);
                if (!$assertionsDisabled && sfr1.readInt() != 1) {
                    throw new AssertionError();
                }
                ok = false;
                try {
                    sfr1.seek(20L);
                }
                catch (IOException e) {
                    ok = true;
                }
                if (!$assertionsDisabled && !ok) {
                    throw new AssertionError();
                }
                SubStoreWriter sfw3 = f.createSubStore("foo3");
                sfw3.writeInt(10);
                ok = false;
                try {
                    f.createSubStore("foo4");
                }
                catch (IOException e) {
                    ok = true;
                }
                if (!$assertionsDisabled && !ok) {
                    throw new AssertionError();
                }
                sfw3.close();
                SubStoreReader sfr3 = f.openSubStore("foo3");
                if (!$assertionsDisabled && sfr3.readInt() != 10) {
                    throw new AssertionError();
                }
                ok = false;
                try {
                    f.openSubStore("foo99");
                }
                catch (FileNotFoundException e) {
                    ok = true;
                }
                if (!$assertionsDisabled && !ok) {
                    throw new AssertionError();
                }
            }
            finally {
                if (f != null) {
                    f.close();
                }
                testFile.delete();
            }
        }
    };

    private StructuredFile(File file, boolean create) throws IOException {
        this.file = file;
        if (!create && !file.exists()) {
            throw new FileNotFoundException(file.toString());
        }
        this.realFile = new RandomAccessFile(file, "rw");
        try {
            if (create) {
                this.realFile.setLength(0L);
                this.realFile.writeByte(115);
                this.realFile.writeByte(115);
                this.realFile.writeByte(102);
                this.realFile.writeByte(0);
                this.realFile.writeInt(0);
                this.dir = new Directory();
                this.writeDirectory();
            } else {
                this.readHeader();
            }
        }
        catch (IOException e) {
            if (this.realFile != null) {
                this.realFile.close();
            }
            file.delete();
            throw e;
        }
    }

    public String getSystemId() {
        return this.file.getAbsolutePath();
    }

    private void readHeader() throws IOException {
        this.realFile.seek(0L);
        if (this.realFile.readByte() != 115 || this.realFile.readByte() != 115 || this.realFile.readByte() != 102 || this.realFile.readByte() != 0) {
            throw new IOException("File is not a structured file");
        }
        this.dirPos = this.realFile.readInt();
        this.realFile.seek(this.dirPos);
        this.dir = new Directory(this.realFile);
    }

    public static synchronized StructuredFile create(File file) throws IOException {
        StructuredFile sf;
        if (fileMap.get(file) != null) {
            sf = (StructuredFile)fileMap.get(file);
        } else {
            sf = new StructuredFile(file, true);
            fileMap.put(file, sf);
        }
        ++sf.openCount;
        return sf;
    }

    public static synchronized StructuredFile open(File file) throws FileNotFoundException, IOException {
        StructuredFile sf;
        if (fileMap.get(file) != null) {
            sf = (StructuredFile)fileMap.get(file);
        } else {
            sf = new StructuredFile(file, false);
            fileMap.put(file, sf);
        }
        ++sf.openCount;
        return sf;
    }

    public synchronized SubStoreWriter createSubStore(String name) throws IOException {
        SubFileWriter subfile;
        if (this.creatingSubfile != null) {
            throw new IOException("Can only create one sub-file at a time");
        }
        if (this.dir.find(name) != null) {
            throw new IOException("Cannot create sub-file: already exists");
        }
        this.eraseDirectory();
        DirEntry ent = new DirEntry();
        ent.name = name;
        ent.segOffset = (int)this.realFile.length();
        this.dir.add(ent);
        this.creatingSubfile = subfile = new SubFileWriter(this.realFile, this, ent.segOffset);
        this.creatingEnt = ent;
        return subfile;
    }

    public synchronized SubStoreReader openSubStore(String name) throws IOException {
        DirEntry ent = this.dir.find(name);
        if (ent == null) {
            throw new FileNotFoundException("Sub-file " + name + " not found.");
        }
        if (this.creatingEnt == ent) {
            throw new IOException("Cannot open in-progress subfile");
        }
        SubFileReader sub = new SubFileReader(this.realFile, this, ent.segOffset, ent.segLength);
        this.openSubfiles.add(sub);
        return sub;
    }

    synchronized void closeReader(SubFileReader subfile) throws IOException {
        if (!this.openSubfiles.remove(subfile)) assert (false) : "Tried to close sub-file not in list";
        if (this.curSubFile == subfile) {
            this.curSubFile = null;
        }
    }

    synchronized void closeWriter(SubFileWriter subfile) throws IOException {
        if (this.creatingSubfile == subfile) {
            this.creatingEnt.segLength = (int)this.realFile.length() - this.creatingEnt.segOffset;
            this.writeDirectory();
            this.creatingSubfile = null;
            this.creatingEnt = null;
        } else assert (false) : "Tried to close unknown sub-file writer";
    }

    public synchronized void setUserVersion(String ver) throws IOException {
        if (this.dir.getUserVersion().equals(ver)) {
            return;
        }
        this.dir.setUserVersion(ver);
        if (this.dirPos != 0) {
            this.eraseDirectory();
            this.writeDirectory();
        }
    }

    public String getUserVersion() {
        return this.dir.getUserVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws IOException {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            --this.openCount;
            if (this.openCount > 0) {
                return;
            }
            fileMap.remove(this.file);
            if (this.creatingSubfile != null) {
                this.creatingSubfile.close();
                this.creatingSubfile = null;
            }
            while (!this.openSubfiles.isEmpty()) {
                SubFileReader sub = (SubFileReader)this.openSubfiles.getFirst();
                sub.close();
            }
            if (this.realFile != null) {
                this.realFile.close();
                this.realFile = null;
            }
        }
    }

    public void delete() throws IOException {
        if (this.realFile != null) {
            this.close();
        }
        this.file.delete();
    }

    private void eraseDirectory() throws IOException {
        if (this.dirPos == 0) {
            return;
        }
        this.realFile.setLength(this.dirPos);
        this.realFile.seek(4L);
        this.realFile.writeInt(0);
        this.dirPos = 0;
    }

    private void writeDirectory() throws IOException {
        if (this.dirPos != 0) {
            throw new IOException("Cannot writeDirectory() before eraseDirectory()");
        }
        this.dirPos = (int)this.realFile.length();
        this.realFile.seek(this.dirPos);
        this.dir.writeTo(this.realFile);
        this.realFile.seek(4L);
        this.realFile.writeInt(this.dirPos);
    }

    private class DirEntry {
        public String name;
        public int segOffset;
        public int segLength;

        public DirEntry() {
        }

        public DirEntry(PackedByteBuf buf) {
            this.name = buf.readString();
            this.segOffset = buf.readInt();
            this.segLength = buf.readInt();
        }

        public void writeTo(PackedByteBuf buf) {
            buf.writeString(this.name);
            buf.writeInt(this.segOffset);
            buf.writeInt(this.segLength);
        }
    }

    private class Directory {
        private DirEntry[] entries;
        private String userVersion;

        public Directory() {
            this.entries = new DirEntry[0];
            this.userVersion = "";
        }

        public Directory(DataInput in) throws IOException {
            if (in.readByte() != 100 || in.readByte() != 105 || in.readByte() != 114 || in.readByte() != 0) {
                throw new IOException("Structured file directory corrupted");
            }
            int length = in.readInt();
            PackedByteBuf buf = new PackedByteBuf(in, length);
            this.userVersion = buf.readString();
            int nEntries = buf.readInt();
            this.entries = new DirEntry[nEntries];
            int i = 0;
            while (i < nEntries) {
                this.entries[i] = new DirEntry(buf);
                ++i;
            }
        }

        public void writeTo(DataOutput out) throws IOException {
            PackedByteBuf buf = new PackedByteBuf(500);
            buf.writeString(this.userVersion);
            buf.writeInt(this.entries.length);
            int i = 0;
            while (i < this.entries.length) {
                this.entries[i].writeTo(buf);
                ++i;
            }
            out.writeByte(100);
            out.writeByte(105);
            out.writeByte(114);
            out.writeByte(0);
            out.writeInt(buf.length());
            buf.output(out);
        }

        public DirEntry find(String name) {
            int i = 0;
            while (i < this.entries.length) {
                if (this.entries[i].name.equals(name)) {
                    return this.entries[i];
                }
                ++i;
            }
            return null;
        }

        public void add(DirEntry entry) {
            DirEntry[] newEntries = new DirEntry[this.entries.length + 1];
            System.arraycopy(this.entries, 0, newEntries, 0, this.entries.length);
            newEntries[this.entries.length] = entry;
            this.entries = newEntries;
        }

        public String getUserVersion() {
            return this.userVersion;
        }

        public void setUserVersion(String userVersion) {
            this.userVersion = userVersion;
        }
    }
}

