/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.textEngine.facet;

import java.util.HashSet;
import org.cdlib.xtf.textEngine.facet.GroupSelector;

public class SingletonSelector
extends GroupSelector {
    private HashSet parents = new HashSet();

    public void reset(boolean conservative) {
        super.reset(conservative);
        this.parents.clear();
    }

    public void process(int group) {
        if (this.conservative) {
            this.next.process(group);
            return;
        }
        int parent = this.counts.parent(group);
        Integer parentKey = parent;
        if (this.parents.contains(parentKey)) {
            return;
        }
        int childCount = 0;
        int kid = this.counts.child(parent);
        while (kid >= 0) {
            if (this.counts.shouldInclude(kid) && this.counts.isSelected(group)) {
                ++childCount;
            }
            kid = this.counts.sibling(kid);
        }
        if (childCount == 1) {
            this.next.process(group);
        }
        this.parents.add(parentKey);
    }

    public String toString() {
        return "singleton -> " + this.next.toString();
    }
}

