/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.textEngine;

import java.io.File;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.transform.Source;
import net.sf.saxon.Configuration;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.TreeBuilder;
import org.apache.lucene.chunk.SpanChunkedNotQuery;
import org.apache.lucene.chunk.SpanDechunkingQuery;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.spans.SpanNearQuery;
import org.apache.lucene.search.spans.SpanNotNearQuery;
import org.apache.lucene.search.spans.SpanOrNearQuery;
import org.apache.lucene.search.spans.SpanOrQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.cdlib.xtf.textEngine.BoostSetParams;
import org.cdlib.xtf.textEngine.MoreLikeThisQuery;
import org.cdlib.xtf.textEngine.NumericRangeQuery;
import org.cdlib.xtf.textEngine.QueryGenException;
import org.cdlib.xtf.textEngine.QueryRequest;
import org.cdlib.xtf.textEngine.RefieldingQueryRewriter;
import org.cdlib.xtf.textEngine.SpanExactQuery;
import org.cdlib.xtf.textEngine.SpanSectionTypeQuery;
import org.cdlib.xtf.textEngine.SpellcheckParams;
import org.cdlib.xtf.textEngine.XtfSpanRangeQuery;
import org.cdlib.xtf.textEngine.XtfSpanWildcardQuery;
import org.cdlib.xtf.textEngine.facet.FacetSpec;
import org.cdlib.xtf.textEngine.facet.MarkSelector;
import org.cdlib.xtf.textEngine.facet.ParseException;
import org.cdlib.xtf.textEngine.facet.RootSelector;
import org.cdlib.xtf.textEngine.facet.SelectorParser;
import org.cdlib.xtf.util.EasyNode;
import org.cdlib.xtf.util.FloatList;
import org.cdlib.xtf.util.GeneralException;
import org.cdlib.xtf.util.Path;
import org.cdlib.xtf.util.Trace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryRequestParser {
    private QueryRequest req;
    private File baseDir;
    private Configuration config;
    private NodeInfo topNode;
    private HashSet specifiedGlobalAttrs = new HashSet();
    private Vector groupSpecs = new Vector();
    private static final int DEFAULT_MAX_SNIPPETS = 888888888;

    public QueryRequest parseRequest(Source queryDoc, File baseDir, String defaultIndexPath) throws QueryGenException, QueryFormatError {
        this.req = new QueryRequest();
        this.baseDir = baseDir;
        this.req.indexPath = defaultIndexPath;
        if (queryDoc instanceof NodeInfo) {
            this.parseOutputTop(new EasyNode((NodeInfo)queryDoc));
        } else {
            if (this.config == null) {
                this.config = new Configuration();
            }
            try {
                NodeInfo top = TreeBuilder.build(queryDoc, null, this.config);
                this.parseOutputTop(new EasyNode(top));
            }
            catch (XPathException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.groupSpecs.size() > 0) {
            this.req.facetSpecs = this.groupSpecs.toArray(new FacetSpec[this.groupSpecs.size()]);
        }
        return this.req;
    }

    public QueryRequest parseRequest(Source queryDoc, File baseDir) throws QueryGenException, QueryFormatError {
        return this.parseRequest(queryDoc, baseDir, null);
    }

    public Source getSource() {
        return this.topNode;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    private void error(String message) throws QueryGenException {
        throw new QueryGenException(message);
    }

    private void parseOutputTop(EasyNode output) throws QueryGenException, QueryFormatError {
        if ("query".equals(output.name()) || "error".equals(output.name())) {
            this.parseOutput(output);
            return;
        }
        this.topNode = output.getWrappedNode();
        int i = 0;
        while (i < output.nChildren()) {
            EasyNode main = output.child(i);
            String name = main.name();
            if (main.isElement()) {
                if (!name.equals("query") && !name.equals("error")) {
                    this.error("Expected 'query' or 'error' element at top level; found '" + name + "'");
                }
                this.parseOutput(main);
            }
            ++i;
        }
    }

    private void parseOutput(EasyNode main) {
        if (main.name().equals("error")) {
            throw new QueryFormatError(main.attrValue("message"));
        }
        int maxSnippets = 888888888;
        int i = 0;
        while (i < main.nAttrs()) {
            String name = main.attrName(i);
            String val = main.attrValue(i);
            if (name.equals("maxSnippets")) {
                maxSnippets = this.parseIntAttrib(main, name);
                if (maxSnippets < 0) {
                    maxSnippets = 999999999;
                }
            } else {
                this.parseMainAttrib(main, name, val);
            }
            ++i;
        }
        int nChildQueries = 0;
        int i2 = 0;
        while (i2 < main.nChildren()) {
            EasyNode el = main.child(i2);
            if (el.isElement()) {
                if ("facet".equalsIgnoreCase(el.name())) {
                    this.parseFacetSpec(el);
                } else if ("spellcheck".equalsIgnoreCase(el.name())) {
                    this.parseSpellcheck(el);
                } else if (!"resultData".equalsIgnoreCase(el.name())) {
                    this.req.query = QueryRequestParser.deChunk(this.parseQuery(el, null, 888888888));
                    ++nChildQueries;
                }
            }
            ++i2;
        }
        if (nChildQueries > 1) {
            this.error("<" + main.name() + "> element must have " + " at most one child query");
        }
        if (main.name().equals("query") && Trace.getOutputLevel() >= 8) {
            Trace.debug("Lucene query as parsed: " + this.req.query);
        }
        if (main.name().equals("query") && this.req.indexPath == null) {
            this.error("'indexPath' attribute missing from <query> element");
        }
    }

    void parseFacetSpec(EasyNode el) {
        FacetSpec fs = new FacetSpec();
        int i = 0;
        while (i < el.nAttrs()) {
            if (el.attrName(i).equalsIgnoreCase("field")) {
                fs.field = el.attrValue(i);
            } else if (el.attrName(i).equalsIgnoreCase("sortGroupsBy")) {
                if (el.attrValue(i).matches("^(totalDocs|value|reverseValue|maxDocScore)$")) {
                    fs.sortGroupsBy = el.attrValue(i);
                } else {
                    this.error("Expected 'totalDocs', 'maxDocScore', or 'value' for '" + el.attrName(i) + "' attribute, but found '" + el.attrValue(i) + "' (on '" + el.name() + " element)");
                }
            } else if (el.attrName(i).equalsIgnoreCase("sortDocsBy")) {
                fs.sortDocsBy = el.attrValue(i);
            } else if (el.attrName(i).equalsIgnoreCase("includeEmptyGroups")) {
                if (el.attrValue(i).matches("^(true|yes)$")) {
                    fs.includeEmptyGroups = true;
                } else if (el.attrValue(i).matches("^(false|no)$")) {
                    fs.includeEmptyGroups = false;
                } else {
                    this.error("Expected 'yes', 'no', 'true', or 'false' for '" + el.attrName(i) + "' attribute, but found '" + el.attrValue(i) + "' (on '" + el.name() + " element)");
                }
            } else if (el.attrName(i).equalsIgnoreCase("select")) {
                try {
                    SelectorParser parser = new SelectorParser(new StringReader(el.attrValue(i)));
                    fs.groupSelector = parser.parse();
                }
                catch (ParseException e) {
                    this.error("Error parsing '" + el.attrName(i) + "' expression: " + e.getMessage());
                }
            }
            ++i;
        }
        if (fs.field == null || fs.field.length() == 0) {
            this.error("'" + el.name() + "' element requires 'field' attribute");
        }
        if (fs.groupSelector == null) {
            RootSelector root = new RootSelector();
            MarkSelector mark = new MarkSelector();
            root.setNext(mark);
            fs.groupSelector = root;
        }
        i = 0;
        while (i < this.groupSpecs.size()) {
            FacetSpec other = (FacetSpec)this.groupSpecs.elementAt(i);
            if (other.field.equalsIgnoreCase(fs.field)) {
                this.error("Specifying two '" + el.name() + "' elements for the " + "same field is illegal");
            }
            ++i;
        }
        this.groupSpecs.add(fs);
    }

    void parseSpellcheck(EasyNode el) {
        SpellcheckParams params = new SpellcheckParams();
        int i = 0;
        while (i < el.nAttrs()) {
            String attr = el.attrName(i);
            if (attr.equalsIgnoreCase("fields") || attr.equalsIgnoreCase("field")) {
                String fieldsStr = this.parseStringAttrib(el, attr);
                if (!fieldsStr.equals("#all")) {
                    params.fields = new HashSet();
                    StringTokenizer st = new StringTokenizer(fieldsStr, ";,| \t");
                    while (st.hasMoreTokens()) {
                        params.fields.add(st.nextToken());
                    }
                }
            } else if (attr.equalsIgnoreCase("docScoreCutoff")) {
                params.docScoreCutoff = this.parseFloatAttrib(el, attr);
            } else if (attr.equalsIgnoreCase("totalDocsCutoff")) {
                params.totalDocsCutoff = this.parseIntAttrib(el, attr);
            } else if (!attr.equalsIgnoreCase("suggestionsPerTerm")) {
                this.error("Unknown attribute '" + attr + "' on '" + el.name() + "' element");
            }
            ++i;
        }
        this.req.spellcheckParams = params;
    }

    private Query parseQuery(EasyNode parent, String field, int maxSnippets) throws QueryGenException {
        SpanQuery subDoc;
        SpanQuery secType;
        Query result;
        String name = parent.name();
        if (!name.matches("^(query|term|all|range|phrase|exact|near|and|or|not|orNear|allDocs|moreLike|orderedNear|combine|meta|text)$")) {
            this.error("Expected one of: (query term all allDocs range phrase exact near orNear and or not moreLike orderedNear); found '" + name + "'");
        }
        field = name.equals("text") ? "text" : this.parseField(parent, field);
        assert (!name.equals("not"));
        float boost = 1.0f;
        int i = 0;
        while (i < parent.nAttrs()) {
            String attrName = parent.attrName(i);
            String attrVal = parent.attrValue(i);
            if (attrName.equals("boost")) {
                boost = this.parseFloatAttrib(parent, attrName);
            } else if (attrName.equals("maxSnippets")) {
                int oldVal = maxSnippets;
                maxSnippets = this.parseIntAttrib(parent, attrName);
                if (maxSnippets < 0) {
                    maxSnippets = 999999999;
                }
                if (oldVal != 888888888 && maxSnippets != oldVal) {
                    this.error("Value specified for 'maxSnippets' attribute differs from that of an ancestor element.");
                }
            } else {
                this.parseMainAttrib(parent, attrName, attrVal);
            }
            ++i;
        }
        if (this.req.boostSetParams != null) {
            if (this.req.boostSetParams.field != null && this.req.boostSetParams.path == null) {
                this.error("'boostSetField' specified without 'boostSet'");
            }
            if (this.req.boostSetParams.field == null && this.req.boostSetParams.path != null) {
                this.error("'boostSet' specified without 'boostSetField'");
            }
            if (this.req.boostSetParams.exponent != 1.0f && this.req.boostSetParams.path == null) {
                this.error("'boostSetExponent' specified without 'boostSet'");
            }
            if (this.req.boostSetParams.defaultBoost != 1.0f && this.req.boostSetParams.path == null) {
                this.error("'boostSetDefault' specified without 'boostSet'");
            }
        }
        if ((result = this.parseQuery2(parent, name, field, maxSnippets)) == null) {
            return null;
        }
        if (boost != 1.0f) {
            result.setBoost(boost);
        }
        if ((secType = this.parseSectionType(parent, field, maxSnippets)) != null) {
            SpanSectionTypeQuery combo = new SpanSectionTypeQuery((SpanQuery)result, secType);
            combo.setSpanRecording(((SpanQuery)result).getSpanRecording());
            result = combo;
        }
        if ((subDoc = this.parseSubDocument(parent, field, maxSnippets)) != null) {
            SpanSectionTypeQuery combo = new SpanSectionTypeQuery((SpanQuery)result, subDoc);
            combo.setSpanRecording(((SpanQuery)result).getSpanRecording());
            result = combo;
        }
        return result;
    }

    private Query parseQuery2(EasyNode parent, String name, String field, int maxSnippets) throws QueryGenException {
        if (name.equals("allDocs")) {
            return new TermQuery(new Term("docInfo", "1"));
        }
        if (name.equals("term")) {
            Term term = this.parseTerm(parent, field, "term");
            SpanTermQuery q = this.isWildcardTerm(term) ? new XtfSpanWildcardQuery(term, this.req.termLimit) : new SpanTermQuery(term);
            q.setSpanRecording(maxSnippets);
            return q;
        }
        field = this.parseField(parent, field);
        if (name.equals("range")) {
            return this.parseRange(parent, field, maxSnippets);
        }
        if (name.equals("moreLike")) {
            return this.parseMoreLike(parent, field, maxSnippets);
        }
        if (parent.hasAttr("fields")) {
            return this.parseMultiFieldQuery(parent, field, maxSnippets);
        }
        if (name.matches("^(all|phrase|exact|near|orNear|orderedNear)$")) {
            int slop = name.equals("all") ? 999999999 : (name.equals("phrase") ? 0 : (name.equals("exact") ? -1 : this.parseIntAttrib(parent, "slop")));
            return this.makeProxQuery(parent, slop, field, maxSnippets);
        }
        boolean useProximity = this.parseBooleanAttrib(parent, "useProximity", true);
        if (!useProximity && !name.equals("and")) {
            this.error("The 'useProximity' attribute is only applicable to 'and' queries");
        }
        HashMap<String, QueryEntry> subMap = new HashMap<String, QueryEntry>();
        Vector<String> fields = new Vector<String>();
        BooleanQuery bq = new BooleanQuery();
        boolean require = !name.equals("or");
        int i = 0;
        while (i < parent.nChildren()) {
            EasyNode el = parent.child(i);
            if (el.isElement() && !el.name().matches("^(sectionType|subDocument)$") && !el.name().equalsIgnoreCase("resultData")) {
                Query q;
                boolean isNot = false;
                if (el.name().equals("not")) {
                    q = this.parseQuery2(el, name, field, 0);
                    isNot = true;
                } else {
                    q = this.parseQuery(el, field, maxSnippets);
                }
                if (q != null) {
                    if (useProximity && q instanceof SpanQuery) {
                        String queryField = ((SpanQuery)q).getField();
                        QueryEntry ent = (QueryEntry)subMap.get(queryField);
                        if (ent == null) {
                            fields.add(queryField);
                            ent = new QueryEntry(queryField);
                            subMap.put(queryField, ent);
                        }
                        if (isNot) {
                            ent.nots.add(q);
                        } else {
                            ent.queries.add(q);
                        }
                    } else {
                        BooleanClause.Occur occur = isNot ? BooleanClause.Occur.MUST_NOT : (require ? BooleanClause.Occur.MUST : BooleanClause.Occur.SHOULD);
                        bq.add(QueryRequestParser.deChunk(q), occur);
                    }
                }
            }
            ++i;
        }
        BooleanClause[] genericClauses = bq.getClauses();
        if (genericClauses.length == 0) {
            if (subMap.isEmpty()) {
                return null;
            }
            if (fields.size() == 1) {
                QueryEntry ent = (QueryEntry)subMap.get(fields.get(0));
                if (ent.nots.isEmpty()) {
                    return this.processSpanJoin(name, ent.queries, ent.nots, maxSnippets);
                }
            }
        }
        int i2 = 0;
        while (i2 < fields.size()) {
            QueryEntry ent = (QueryEntry)subMap.get(fields.get(i2));
            int nQueries = ent.queries.size();
            int nNots = ent.nots.size();
            if (nQueries > 1 || nQueries == 1 && nNots > 0) {
                SpanQuery sq = this.processSpanJoin(name, ent.queries, ent.nots, maxSnippets);
                bq.add(QueryRequestParser.deChunk(sq), require ? BooleanClause.Occur.MUST : BooleanClause.Occur.SHOULD);
            } else {
                int j = 0;
                while (j < ent.queries.size()) {
                    bq.add(QueryRequestParser.deChunk((Query)ent.queries.get(j)), require ? BooleanClause.Occur.MUST : BooleanClause.Occur.SHOULD);
                    ++j;
                }
                j = 0;
                while (j < ent.nots.size()) {
                    bq.add(QueryRequestParser.deChunk((Query)ent.nots.get(j)), BooleanClause.Occur.MUST_NOT);
                    ++j;
                }
            }
            ++i2;
        }
        BooleanClause[] clauses = bq.getClauses();
        if (clauses.length == 1) {
            if (clauses[0].getOccur() == BooleanClause.Occur.MUST) {
                return clauses[0].getQuery();
            }
            if (clauses[0].getOccur() == BooleanClause.Occur.MUST_NOT) {
                TermQuery allDocsQuery = new TermQuery(new Term("docInfo", "1"));
                bq.add(allDocsQuery, BooleanClause.Occur.MUST);
            }
        }
        return this.simplifyBooleanQuery(bq);
    }

    private Query parseMultiFieldQuery(EasyNode parent, String field, int maxSnippets) {
        String name = parent.name();
        if (!name.matches("^(and|or)$")) {
            this.error("multiple fields only supported for 'and' or 'or' queries");
        }
        if (field != null) {
            this.error("multi-field query requires 'fields' attribute, not 'field'");
        }
        String fieldsStr = this.parseStringAttrib(parent, "fields");
        ArrayList<String> fields = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(fieldsStr, ";,| \t");
        while (st.hasMoreTokens()) {
            fields.add(st.nextToken());
        }
        int slop = this.parseIntAttrib(parent, "slop");
        int maxMetaSnippets = this.parseIntAttrib(parent, "maxMetaSnippets", maxSnippets);
        int maxTextSnippets = this.parseIntAttrib(parent, "maxTextSnippets", maxSnippets);
        float[] boosts = null;
        if (parent.hasAttr("boosts") && (boosts = this.parseFieldBoosts(parent, "boosts")) != null && boosts.length > fields.size()) {
            this.error("'boosts' attribute may not contain more values than 'fields'");
        }
        ArrayList<Query> queryList = new ArrayList<Query>();
        Vector<Query> notVec = new Vector<Query>();
        int i = 0;
        while (i < parent.nChildren()) {
            EasyNode el = parent.child(i);
            if (el.isElement() && !el.name().equalsIgnoreCase("resultData")) {
                if (el.name().equalsIgnoreCase("not")) {
                    notVec.add(this.parseQuery2(el, "not", fieldsStr, maxSnippets));
                } else {
                    Query q = this.parseQuery(el, fieldsStr, maxSnippets);
                    if (q != null) {
                        if (!(q instanceof SpanQuery)) {
                            this.error("Internal error: sub-queries of multi-field query must be span queries");
                        }
                        queryList.add(q);
                    }
                }
            }
            ++i;
        }
        if (queryList.isEmpty()) {
            return null;
        }
        SpanQuery[] subQueries = queryList.toArray(new SpanQuery[queryList.size()]);
        return this.createMultiFieldQuery(parent, fields.toArray(new String[fields.size()]), boosts, subQueries, notVec, slop, maxMetaSnippets, maxTextSnippets);
    }

    private Query createMultiFieldQuery(EasyNode parent, String[] fields, float[] boosts, SpanQuery[] spanQueries, Vector<Query> notVec, int slop, int maxMetaSnippets, int maxTextSnippets) {
        int i;
        BooleanQuery mainQuery = new BooleanQuery(true);
        RefieldingQueryRewriter refielder = new RefieldingQueryRewriter();
        if (parent.name().equals("and")) {
            i = 0;
            while (i < spanQueries.length) {
                BooleanQuery termOrQuery = new BooleanQuery();
                int j = 0;
                while (j < fields.length) {
                    Query tq = refielder.refield(spanQueries[i], fields[j]);
                    if (!notVec.isEmpty()) {
                        Vector<Query> refieldedNotVec = new Vector<Query>();
                        for (Query nq : notVec) {
                            refieldedNotVec.add(refielder.refield(nq, fields[j]));
                        }
                        tq = this.processSpanNots((SpanQuery)tq, refieldedNotVec, 0);
                    }
                    if ((tq = QueryRequestParser.deChunk(tq)) instanceof SpanQuery) {
                        ((SpanQuery)tq).setSpanRecording(0);
                    }
                    termOrQuery.add(tq, BooleanClause.Occur.SHOULD);
                    ++j;
                }
                termOrQuery.setBoost(0.0f);
                mainQuery.add(termOrQuery, BooleanClause.Occur.MUST);
                ++i;
            }
        }
        i = 0;
        while (i < fields.length) {
            SpanQuery[] termQueries = new SpanQuery[spanQueries.length];
            int j = 0;
            while (j < spanQueries.length) {
                termQueries[j] = (SpanQuery)refielder.refield(spanQueries[j], fields[i]);
                if (!notVec.isEmpty()) {
                    Vector<Query> refieldedNotVec = new Vector<Query>();
                    for (Query nq : notVec) {
                        refieldedNotVec.add(refielder.refield(nq, fields[i]));
                    }
                    termQueries[j] = this.processSpanNots(termQueries[j], refieldedNotVec, 0);
                }
                ++j;
            }
            SpanQuery fieldOrQuery = (SpanQuery)QueryRequestParser.deChunk(new SpanOrNearQuery(termQueries, slop, true));
            int maxSnippets = fields[i].equals("text") ? maxTextSnippets : maxMetaSnippets;
            fieldOrQuery.setSpanRecording(maxSnippets);
            if (boosts != null && i < boosts.length) {
                fieldOrQuery.setBoost(boosts[i]);
            }
            mainQuery.add(fieldOrQuery, BooleanClause.Occur.SHOULD);
            ++i;
        }
        return this.simplifyBooleanQuery(mainQuery);
    }

    private Query simplifyBooleanQuery(BooleanQuery bq) {
        int j;
        BooleanClause[] subClauses;
        BooleanQuery subQuery;
        boolean anyBoosting = false;
        boolean anyBoolSubs = false;
        boolean allSame = true;
        boolean first = true;
        boolean prevRequired = true;
        boolean prevProhibited = true;
        BooleanClause[] clauses = bq.getClauses();
        int i = 0;
        while (i < clauses.length) {
            if (!(first || prevRequired == (clauses[i].getOccur() == BooleanClause.Occur.MUST) && prevProhibited == (clauses[i].getOccur() == BooleanClause.Occur.MUST_NOT))) {
                allSame = false;
            }
            prevRequired = clauses[i].getOccur() == BooleanClause.Occur.MUST;
            prevProhibited = clauses[i].getOccur() == BooleanClause.Occur.MUST_NOT;
            first = false;
            if (clauses[i].getQuery().getBoost() != 1.0f) {
                anyBoosting = true;
            }
            if (clauses[i].getQuery() instanceof BooleanQuery) {
                subQuery = (BooleanQuery)clauses[i].getQuery();
                subClauses = subQuery.getClauses();
                j = 0;
                while (j < subClauses.length) {
                    if (prevRequired != (subClauses[j].getOccur() == BooleanClause.Occur.MUST) || prevProhibited != (subClauses[j].getOccur() == BooleanClause.Occur.MUST_NOT)) {
                        allSame = false;
                    }
                    prevRequired = subClauses[j].getOccur() == BooleanClause.Occur.MUST;
                    boolean bl = prevProhibited = subClauses[j].getOccur() == BooleanClause.Occur.MUST_NOT;
                    if (subClauses[j].getQuery().getBoost() != 1.0f) {
                        anyBoosting = true;
                    }
                    ++j;
                }
                anyBoolSubs = true;
            }
            ++i;
        }
        if (!anyBoolSubs || !allSame || anyBoosting) {
            return bq;
        }
        bq = new BooleanQuery();
        i = 0;
        while (i < clauses.length) {
            if (clauses[i].getQuery() instanceof BooleanQuery) {
                subQuery = (BooleanQuery)clauses[i].getQuery();
                subClauses = subQuery.getClauses();
                j = 0;
                while (j < subClauses.length) {
                    bq.add(subClauses[j]);
                    ++j;
                }
            } else {
                bq.add(clauses[i]);
            }
            ++i;
        }
        return bq;
    }

    void parseMainAttrib(EasyNode el, String attrName, String val) {
        if (attrName.equals("style")) {
            this.req.displayStyle = this.onceOnlyPath(this.req.displayStyle, el, attrName);
        } else if (attrName.equals("startDoc")) {
            this.req.startDoc = this.onceOnlyAttrib(this.req.startDoc + 1, el, attrName);
            this.req.startDoc = Math.max(0, this.req.startDoc - 1);
        } else if (attrName.equals("maxDocs")) {
            this.req.maxDocs = this.onceOnlyAttrib(this.req.maxDocs, el, attrName);
        } else if (attrName.equals("indexPath")) {
            this.req.indexPath = this.onceOnlyAttrib(this.req.indexPath, el, attrName);
        } else if (attrName.equals("termLimit")) {
            this.req.termLimit = this.onceOnlyAttrib(this.req.termLimit, el, attrName);
        } else if (attrName.equals("workLimit")) {
            this.req.workLimit = this.onceOnlyAttrib(this.req.workLimit, el, attrName);
        } else if (attrName.equals("sortDocsBy") || attrName.equals("sortMetaFields")) {
            this.req.sortMetaFields = this.onceOnlyAttrib(this.req.sortMetaFields, el, attrName);
        } else if (attrName.equals("returnMetaFields")) {
            this.req.returnMetaFields = this.onceOnlyAttrib(this.req.returnMetaFields, el, attrName);
        } else if (attrName.equals("maxContext") || attrName.equals("contextChars")) {
            this.req.maxContext = this.onceOnlyAttrib(this.req.maxContext, el, attrName);
        } else if (attrName.equals("termMode")) {
            int oldTermMode = this.req.termMode;
            if (val.equalsIgnoreCase("none")) {
                this.req.termMode = 0;
            } else if (val.equalsIgnoreCase("hits")) {
                this.req.termMode = 1;
            } else if (val.equalsIgnoreCase("context")) {
                this.req.termMode = 2;
            } else if (val.equalsIgnoreCase("all")) {
                this.req.termMode = 3;
            } else {
                this.error("Unknown value for 'termMode'; expecting 'none', 'hits', 'context', or 'all'");
            }
            if (this.specifiedGlobalAttrs.contains(attrName) && this.req.termMode != oldTermMode) {
                this.error("'termMode' attribute should only be specified once.");
            }
            this.specifiedGlobalAttrs.add(attrName);
        } else if (attrName.equalsIgnoreCase("boostSet")) {
            if (this.req.boostSetParams == null) {
                this.req.boostSetParams = new BoostSetParams();
            }
            this.req.boostSetParams.path = this.onceOnlyPath(this.req.boostSetParams.path, el, attrName);
        } else if (attrName.equalsIgnoreCase("boostSetField")) {
            if (this.req.boostSetParams == null) {
                this.req.boostSetParams = new BoostSetParams();
            }
            this.req.boostSetParams.field = this.parseStringAttrib(el, attrName);
        } else if (attrName.equalsIgnoreCase("boostSetExponent")) {
            if (this.req.boostSetParams == null) {
                this.req.boostSetParams = new BoostSetParams();
            }
            this.req.boostSetParams.exponent = this.parseFloatAttrib(el, attrName);
        } else if (attrName.equalsIgnoreCase("boostSetDefault")) {
            if (this.req.boostSetParams == null) {
                this.req.boostSetParams = new BoostSetParams();
            }
            this.req.boostSetParams.defaultBoost = this.parseFloatAttrib(el, attrName);
        } else if (attrName.equalsIgnoreCase("normalizeScores")) {
            this.req.normalizeScores = this.parseBooleanAttrib(el, "normalizeScores");
        } else if (attrName.equalsIgnoreCase("explainScores")) {
            this.req.explainScores = this.parseBooleanAttrib(el, "explainScores");
        } else if (!(attrName.equals("field") || attrName.equals("metaField") || attrName.equals("fields") && el.name().matches("^(and|or)$") || (attrName.equals("inclusive") || attrName.equals("numeric")) && el.name().equals("range") || attrName.equals("slop") && el.name().matches("^(near|orNear|orderedNear)$") || attrName.matches("^(slop|boosts)$") && el.name().matches("^(and|or)$") && el.hasAttr("fields") || attrName.matches("^(maxTextSnippets|maxMetaSnippets)$") && el.name().matches("^(and|or)$") && el.hasAttr("fields") || attrName.equalsIgnoreCase("useProximity") && el.name().matches("^(and|or)$") || attrName.matches("^(fields|boosts|minWordLen|maxWordLen|minDocFreq|maxDocFreq|minTermFreq|termBoost|maxQueryTerms)$") && el.name().equals("moreLike"))) {
            this.error("Unrecognized attribute \"" + attrName + "\" " + "on <" + el.name() + "> element");
        }
    }

    private SpanQuery parseSectionType(EasyNode parent, String field, int maxSnippets) throws QueryGenException {
        Query ret;
        EasyNode sectionType = parent.child("sectionType");
        if (sectionType == null) {
            return null;
        }
        if (!"text".equals(field)) {
            this.error("'sectionType' element is only appropriate in queries on the 'text' field");
        }
        if (sectionType.nChildren() != 1) {
            this.error("'sectionType' element requires exactly one child element");
        }
        if (!((ret = this.parseQuery(sectionType.child(0), "sectionType", maxSnippets)) instanceof SpanQuery)) {
            this.error("'sectionType' sub-query must use proximity");
        }
        return (SpanQuery)ret;
    }

    private SpanQuery parseSubDocument(EasyNode parent, String field, int maxSnippets) throws QueryGenException {
        Query ret;
        EasyNode subDocument = parent.child("subDocument");
        if (subDocument == null) {
            return null;
        }
        if (!"text".equals(field)) {
            this.error("'subDocument' element is only appropriate in queries on the 'text' field");
        }
        if (subDocument.nChildren() != 1) {
            this.error("'subDocument' element requires exactly one child element");
        }
        if (!((ret = this.parseQuery(subDocument.child(0), "subDocument", maxSnippets)) instanceof SpanQuery)) {
            this.error("'subDocument' sub-query must use proximity");
        }
        return (SpanQuery)ret;
    }

    private String parseField(EasyNode el, String parentField) throws QueryGenException {
        if (!el.hasAttr("metaField") && !el.hasAttr("field")) {
            return parentField;
        }
        String attVal = el.attrValue("field");
        if (attVal == null || attVal.length() == 0) {
            attVal = el.attrValue("metaField");
        }
        if (attVal.length() == 0) {
            this.error("'field' attribute cannot be empty");
        }
        if (attVal.equals("sectionType") && (parentField == null || !parentField.equals("sectionType"))) {
            this.error("'sectionType' is not valid for the 'field' attribute");
        }
        if (attVal.equals("subDocument") && (parentField == null || !parentField.equals("subDocument"))) {
            this.error("'subDocument' is not valid for the 'field' attribute");
        }
        if (parentField != null && !parentField.equals(attVal)) {
            this.error("Cannot override ancestor 'field' attribute");
        }
        return attVal;
    }

    private SpanQuery processSpanJoin(String name, Vector subVec, Vector notVec, int maxSnippets) {
        SpanQuery[] subQueries = subVec.toArray(new SpanQuery[0]);
        if (subQueries.length == 1 && notVec.isEmpty()) {
            return subQueries[0];
        }
        SpanQuery q = subQueries.length == 1 ? subQueries[0] : (name.equals("orNear") ? new SpanOrNearQuery(subQueries, 999999999, true) : (name.equals("orderedNear") ? new SpanNearQuery(subQueries, 999999999, true) : (!name.equals("or") ? new SpanNearQuery(subQueries, 999999999, false) : new SpanOrQuery(subQueries))));
        q.setSpanRecording(maxSnippets);
        return this.processSpanNots(q, notVec, maxSnippets);
    }

    public static Query deChunk(Query q) {
        if (!(q instanceof SpanQuery)) {
            return q;
        }
        SpanQuery sq = (SpanQuery)q;
        if (!sq.getField().equals("text")) {
            return q;
        }
        if (sq instanceof SpanDechunkingQuery) {
            return q;
        }
        SpanDechunkingQuery dq = new SpanDechunkingQuery(sq);
        dq.setSpanRecording(sq.getSpanRecording());
        return dq;
    }

    private boolean isWildcardTerm(Term term) {
        if (term.text().indexOf(42) >= 0) {
            return true;
        }
        return term.text().indexOf(63) >= 0;
    }

    private Query parseRange(EasyNode parent, String field, int maxSnippets) throws QueryGenException {
        boolean inclusive = this.parseBooleanAttrib(parent, "inclusive", true);
        boolean numeric = this.parseBooleanAttrib(parent, "numeric", false);
        Term lower = null;
        Term upper = null;
        int i = 0;
        while (i < parent.nChildren()) {
            EasyNode child = parent.child(i);
            if (child.isElement()) {
                String name = child.name();
                if (name.equals("lower")) {
                    if (lower != null) {
                        this.error("'lower' only allowed once as child of 'range' element");
                    }
                    lower = child.child("term") != null ? this.parseTerm(child.child("term"), field, "term") : this.parseTerm(child, field, "lower");
                } else if (name.equals("upper")) {
                    if (upper != null) {
                        this.error("'upper' only allowed once as child of 'range' element");
                    }
                    upper = child.child("term") != null ? this.parseTerm(child.child("term"), field, "term") : this.parseTerm(child, field, "upper");
                } else {
                    this.error("'range' element may only have 'lower' and/or 'upper' as child elements");
                }
            }
            ++i;
        }
        if (lower == null && upper == null) {
            this.error("'range' element must have 'lower' and/or 'upper' child element(s)");
        }
        if (numeric) {
            return new NumericRangeQuery(field, lower == null ? null : lower.text(), upper == null ? null : upper.text(), inclusive, inclusive);
        }
        if (upper == null) {
            char[] tmp = new char[]{'\ue900'};
            upper = new Term(lower.field(), new String(tmp));
        }
        XtfSpanRangeQuery q = new XtfSpanRangeQuery(lower, upper, inclusive, this.req.termLimit);
        q.setSpanRecording(maxSnippets);
        return q;
    }

    SpanQuery processSpanNots(SpanQuery query, Vector notClauses, int maxSnippets) {
        SpanQuery nq;
        SpanQuery subQuery;
        if (notClauses.isEmpty()) {
            return query;
        }
        if (notClauses.size() == 1) {
            subQuery = (SpanQuery)notClauses.get(0);
        } else {
            SpanQuery[] subs = notClauses.toArray(new SpanQuery[0]);
            subQuery = new SpanOrQuery(subs);
            subQuery.setSpanRecording(maxSnippets);
        }
        if (query.getField().equals("text")) {
            if (query instanceof SpanDechunkingQuery) {
                query = ((SpanDechunkingQuery)query).getWrapped();
            }
            nq = new SpanChunkedNotQuery(query, subQuery, 999999999);
        } else {
            nq = new SpanNotNearQuery(query, subQuery, 999999999);
        }
        nq.setSpanRecording(maxSnippets);
        return nq;
    }

    Query makeProxQuery(EasyNode parent, int slop, String field, int maxSnippets) throws QueryGenException {
        Vector<Query> terms = new Vector<Query>();
        Vector<Query> notVec = new Vector<Query>();
        int i = 0;
        while (i < parent.nChildren()) {
            EasyNode el = parent.child(i);
            if (el.isElement()) {
                if (el.name().equals("not")) {
                    if (parent.name().matches("^(phrase|exact)$")) {
                        this.error("'not' clauses aren't supported in phrase/exact queries");
                    }
                    notVec.add(this.parseQuery2(el, "not", field, maxSnippets));
                } else if (!el.name().matches("^(sectionType|subDocument)$")) {
                    if (slop == 0) {
                        Term t = this.parseTerm(el, field, "term");
                        SpanTermQuery q = this.isWildcardTerm(t) ? new XtfSpanWildcardQuery(t, this.req.termLimit) : new SpanTermQuery(t);
                        q.setSpanRecording(maxSnippets);
                        terms.add(q);
                    } else {
                        terms.add(this.parseQuery(el, field, maxSnippets));
                    }
                }
            }
            ++i;
        }
        if (terms.size() == 0) {
            this.error("'" + parent.name() + "' element requires at " + "least one term");
        }
        SpanQuery[] termQueries = terms.toArray(new SpanQuery[terms.size()]);
        SpanQuery q = slop < 0 ? new SpanExactQuery(termQueries) : (terms.size() == 1 ? (SpanQuery)terms.elementAt(0) : (parent.name().equals("orNear") ? new SpanOrNearQuery(termQueries, slop, true) : (parent.name().equals("orderedNear") ? new SpanNearQuery(termQueries, slop, true) : new SpanNearQuery(termQueries, slop, slop == 0))));
        q.setSpanRecording(maxSnippets);
        return this.processSpanNots(q, notVec, maxSnippets);
    }

    private Query parseMoreLike(EasyNode parent, String field, int maxSnippets) {
        float[] boosts;
        Query subQuery = null;
        int i = 0;
        while (i < parent.nChildren()) {
            EasyNode el = parent.child(i);
            if (el.isElement() && !el.name().equalsIgnoreCase("resultData")) {
                if (subQuery != null) {
                    this.error("'moreLike' element may not have more than one sub-query");
                }
                subQuery = this.parseQuery(el, field, 0);
            }
            ++i;
        }
        if (subQuery == null) {
            this.error("'moreLike' element requires a sub-query");
        }
        MoreLikeThisQuery ret = new MoreLikeThisQuery(subQuery);
        int i2 = 0;
        while (i2 < parent.nAttrs()) {
            String attrName = parent.attrName(i2);
            if (attrName.equalsIgnoreCase("minWordLen")) {
                ret.setMinWordLen(this.parseIntAttrib(parent, attrName));
            } else if (attrName.equalsIgnoreCase("maxWordLen")) {
                ret.setMaxWordLen(this.parseIntAttrib(parent, attrName));
            } else if (attrName.equalsIgnoreCase("minDocFreq")) {
                ret.setMinDocFreq(this.parseIntAttrib(parent, attrName));
            } else if (attrName.equalsIgnoreCase("maxDocFreq")) {
                ret.setMaxDocFreq(this.parseIntAttrib(parent, attrName));
            } else if (attrName.equalsIgnoreCase("minTermFreq")) {
                ret.setMinTermFreq(this.parseIntAttrib(parent, attrName));
            } else if (attrName.equalsIgnoreCase("termBoost")) {
                ret.setBoost(this.parseBooleanAttrib(parent, attrName));
            } else if (attrName.equalsIgnoreCase("maxQueryTerms")) {
                ret.setMaxQueryTerms(this.parseIntAttrib(parent, attrName));
            } else if (attrName.equalsIgnoreCase("fields")) {
                ret.setFieldNames(this.parseFieldNames(parent, attrName));
            } else if (attrName.equalsIgnoreCase("boosts")) {
                ret.setFieldBoosts(this.parseFieldBoosts(parent, attrName));
            } else {
                this.error("Unrecognized attribute '" + attrName + "' on 'moreLike' element");
            }
            ++i2;
        }
        String[] fields = ret.getFieldNames();
        if (fields == null || fields.length == 0) {
            this.error("At least one field name must be specified in 'fields' attribute on 'moreLike' query");
        }
        if ((boosts = ret.getFieldBoosts()) != null && boosts.length != fields.length) {
            this.error("Must specify same number of boosts as fields in 'boosts' attribute on 'moreLike' query");
        }
        return ret;
    }

    private String[] parseFieldNames(EasyNode parent, String attrName) {
        String val = this.parseStringAttrib(parent, attrName);
        StringTokenizer tok = new StringTokenizer(val, " \t\r\n,;|");
        ArrayList<String> list = new ArrayList<String>();
        while (tok.hasMoreTokens()) {
            list.add(tok.nextToken());
        }
        if (list.size() > 0) {
            return list.toArray(new String[list.size()]);
        }
        return null;
    }

    private float[] parseFieldBoosts(EasyNode parent, String attrName) {
        String val = this.parseStringAttrib(parent, attrName);
        StringTokenizer tok = new StringTokenizer(val, " \t\r\n,;|");
        FloatList list = new FloatList();
        while (tok.hasMoreTokens()) {
            String strVal = tok.nextToken();
            try {
                list.add(Float.parseFloat(strVal));
            }
            catch (NumberFormatException e) {
                this.error("Each value for 'boosts' must be a valid floating-point number");
            }
        }
        if (list.size() > 0) {
            return list.toArray();
        }
        return null;
    }

    private Term parseTerm(EasyNode parent, String field, String expectedName) throws QueryGenException {
        String termText;
        if ((field = this.parseField(parent, field)) == null) {
            this.error("'term' element requires 'field' attribute on itself or an ancestor");
        }
        if (!parent.name().equals(expectedName)) {
            this.error("Expected '" + expectedName + "' as child of '" + parent.parent().name() + "' element, but found '" + parent.name() + "'");
        }
        if ((termText = this.getText(parent)) == null || termText.length() == 0) {
            this.error("Missing term text in element '" + parent.name() + "'");
        }
        Term term = new Term(field, termText);
        return term;
    }

    private String getText(EasyNode el) throws QueryGenException {
        int count = 0;
        String text = null;
        int i = 0;
        while (i < el.nChildren()) {
            EasyNode n = el.child(i);
            if (!n.isElement() && !n.isText()) {
                count = -1;
                break;
            }
            if (n.isText()) {
                text = n.toString();
            }
            ++count;
            ++i;
        }
        if (count != 1) {
            this.error("A single text node is required for the '" + el.name() + "' element");
        }
        return text;
    }

    private int onceOnlyAttrib(int oldVal, EasyNode el, String attribName) {
        int newVal = this.parseIntAttrib(el, attribName);
        if (this.specifiedGlobalAttrs.contains(attribName) && newVal != oldVal) {
            this.error("'" + attribName + "' attribute should only be specified once.");
        }
        this.specifiedGlobalAttrs.add(attribName);
        return newVal;
    }

    private String onceOnlyAttrib(String oldVal, EasyNode el, String attribName) {
        String newVal = this.parseStringAttrib(el, attribName);
        if (this.specifiedGlobalAttrs.contains(attribName) && !oldVal.equals(newVal)) {
            this.error("'" + attribName + "' attribute should only be specified once.");
        }
        this.specifiedGlobalAttrs.add(attribName);
        return newVal;
    }

    private String onceOnlyPath(String oldVal, EasyNode el, String attribName) {
        String newVal = this.parseStringAttrib(el, attribName);
        String path = newVal.startsWith("http:") ? newVal : Path.resolveRelOrAbs(this.baseDir, newVal);
        if (this.specifiedGlobalAttrs.contains(attribName) && !oldVal.equals(path)) {
            this.error("'" + attribName + "' attribute should only be specified once.");
        }
        this.specifiedGlobalAttrs.add(attribName);
        if (!(path.startsWith("http:") || newVal.equals("NullStyle.xsl") || new File(path).canRead())) {
            this.error("File \"" + newVal + "\" specified in '" + el.name() + "' element " + "does not exist");
        }
        return path;
    }

    private int parseIntAttrib(EasyNode el, String attribName) throws QueryGenException {
        return this.parseIntAttrib(el, attribName, false, 0);
    }

    private int parseIntAttrib(EasyNode el, String attribName, int defaultVal) throws QueryGenException {
        return this.parseIntAttrib(el, attribName, true, defaultVal);
    }

    private int parseIntAttrib(EasyNode el, String attribName, boolean useDefault, int defaultVal) throws QueryGenException {
        String elName = el.name();
        String str = this.parseStringAttrib(el, attribName, useDefault, null);
        if (str == null && useDefault) {
            return defaultVal;
        }
        if (str.equals("all")) {
            return 999999999;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (Exception e) {
            this.error("'" + attribName + "' attribute of '" + elName + "' element is not a valid integer");
            return 0;
        }
    }

    private float parseFloatAttrib(EasyNode el, String attribName) throws QueryGenException {
        return this.parseFloatAttrib(el, attribName, false, 0.0f);
    }

    private float parseFloatAttrib(EasyNode el, String attribName, float defaultVal) throws QueryGenException {
        return this.parseFloatAttrib(el, attribName, true, defaultVal);
    }

    private float parseFloatAttrib(EasyNode el, String attribName, boolean useDefault, float defaultVal) throws QueryGenException {
        String elName = el.name();
        String str = this.parseStringAttrib(el, attribName, useDefault, null);
        if (str == null && useDefault) {
            return defaultVal;
        }
        try {
            float ret = Float.parseFloat(str);
            if (ret < 0.0f) {
                this.error("'" + attribName + "' attribute of '" + elName + "' element is not allowed to be negative");
            }
            return ret;
        }
        catch (NumberFormatException e) {
            this.error("'" + attribName + "' attribute of '" + elName + "' element is not a valid floating-point number");
            return 0.0f;
        }
    }

    private boolean parseBooleanAttrib(EasyNode el, String attribName) throws QueryGenException {
        return this.parseBooleanAttrib(el, attribName, false, false);
    }

    private boolean parseBooleanAttrib(EasyNode el, String attribName, boolean defaultVal) throws QueryGenException {
        return this.parseBooleanAttrib(el, attribName, true, defaultVal);
    }

    private boolean parseBooleanAttrib(EasyNode el, String attribName, boolean useDefault, boolean defaultVal) throws QueryGenException {
        String elName = el.name();
        String str = this.parseStringAttrib(el, attribName, useDefault, null);
        if (str == null && useDefault) {
            return defaultVal;
        }
        if (str.matches("^(yes|true|1)$")) {
            return true;
        }
        if (str.matches("^(no|false|0)$")) {
            return false;
        }
        this.error("'" + attribName + "' attribute of '" + elName + "' element is not a valid boolean (yes/no/true/false/1/0)");
        return false;
    }

    private String parseStringAttrib(EasyNode el, String attribName) throws QueryGenException {
        return this.parseStringAttrib(el, attribName, false, null);
    }

    private String parseStringAttrib(EasyNode el, String attribName, String defaultVal) throws QueryGenException {
        return this.parseStringAttrib(el, attribName, true, defaultVal);
    }

    private String parseStringAttrib(EasyNode el, String attribName, boolean useDefault, String defaultVal) throws QueryGenException {
        String elName = el.name();
        String str = el.attrValue(attribName);
        if (str == null) {
            if (!useDefault) {
                this.error("'" + elName + "' element must specify '" + attribName + "' attribute");
            }
            return defaultVal;
        }
        if (str.length() == 0) {
            if (!useDefault) {
                this.error("'" + elName + "' element specified empty '" + attribName + "' attribute");
            }
            return defaultVal;
        }
        return str;
    }

    private static class QueryEntry {
        public Vector queries = new Vector();
        public Vector nots = new Vector();
        public String field;

        public QueryEntry(String field) {
            this.field = field;
        }
    }

    public class QueryFormatError
    extends GeneralException {
        public QueryFormatError(String message) {
            super(message);
        }

        public boolean isSevere() {
            return false;
        }
    }
}

