/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.dynaXML;

import org.cdlib.xtf.dynaXML.DynaXML;
import org.cdlib.xtf.servletBase.TextConfig;
import org.cdlib.xtf.util.GeneralException;

class DynaXMLConfig
extends TextConfig {
    public String reverseProxyIP;
    public String reverseProxyMarker;
    public String reverseProxyDefaultMarker = "X-Forwarded-For";
    public String docLookupSheet;
    public int authCacheSize = 1000;
    public int authCacheExpire = 1800;
    public int loginCacheSize = 100;
    public int loginCacheExpire = 300;
    public int ipListCacheSize = 10;
    public int ipListCacheExpire = 900;
    public boolean useLazyFiles = true;
    public boolean buildLazyFilesAlone = false;

    public DynaXMLConfig(DynaXML servlet, String path) throws GeneralException {
        super(servlet);
        super.read("dynaXML-config", path);
        DynaXMLConfig.requireOrElse(this.docLookupSheet, "Config file error: docReqParser path not specified");
    }

    public boolean handleProperty(String tagAttr, String strVal) {
        if (tagAttr.equalsIgnoreCase("reverseProxy.IP")) {
            this.reverseProxyIP = strVal;
            return true;
        }
        if (tagAttr.equalsIgnoreCase("reverseProxy.marker")) {
            this.reverseProxyMarker = strVal;
            return true;
        }
        if (tagAttr.equalsIgnoreCase("reqParserCache.size") || tagAttr.equalsIgnoreCase("reqParserCache.expire") || tagAttr.equalsIgnoreCase("docReqParser.params")) {
            return true;
        }
        if (tagAttr.equalsIgnoreCase("docReqParser.path")) {
            this.docLookupSheet = this.servlet.getRealPath(strVal);
            return true;
        }
        if (tagAttr.equalsIgnoreCase("ipListCache.size")) {
            this.ipListCacheSize = DynaXMLConfig.parseInt(tagAttr, strVal);
            return true;
        }
        if (tagAttr.equalsIgnoreCase("ipListCache.expire")) {
            this.ipListCacheExpire = DynaXMLConfig.parseInt(tagAttr, strVal);
            return true;
        }
        if (tagAttr.equalsIgnoreCase("authCache.size")) {
            this.authCacheSize = DynaXMLConfig.parseInt(tagAttr, strVal);
            return true;
        }
        if (tagAttr.equalsIgnoreCase("authCache.expire")) {
            this.authCacheExpire = DynaXMLConfig.parseInt(tagAttr, strVal);
            return true;
        }
        if (tagAttr.equalsIgnoreCase("loginCache.size")) {
            this.loginCacheSize = DynaXMLConfig.parseInt(tagAttr, strVal);
            return true;
        }
        if (tagAttr.equalsIgnoreCase("loginCache.expire")) {
            this.loginCacheExpire = DynaXMLConfig.parseInt(tagAttr, strVal);
            return true;
        }
        if (tagAttr.equalsIgnoreCase("lazyTrees.use")) {
            this.useLazyFiles = DynaXMLConfig.parseBoolean(tagAttr, strVal);
            return true;
        }
        if (tagAttr.equalsIgnoreCase("lazyTrees.buildAlone")) {
            this.buildLazyFilesAlone = DynaXMLConfig.parseBoolean(tagAttr, strVal);
            return true;
        }
        return super.handleProperty(tagAttr, strVal);
    }
}

