/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.crossQuery;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trace.TraceListener;
import org.cdlib.xtf.util.Trace;

public class TimeProfilingListener
implements TraceListener {
    private ThreadLocal<LinkedList<ProfileInstr>> stack = new ThreadLocal();
    private ThreadLocal<HashMap<ProfileInstr, ProfileTime>> timeMap = new ThreadLocal();

    public void open() {
        if (this.stack.get() == null) {
            this.stack.set(new LinkedList());
        }
        if (this.timeMap.get() == null) {
            this.timeMap.set(new HashMap());
        }
        this.clearStack();
    }

    public void close() {
        ProfileInstr t = this.stack.get().get(0);
        long totalTime = System.currentTimeMillis() - t.start;
        long selfTime = totalTime - t.descendantTime;
        this.addTime(t, selfTime);
    }

    private void clearStack() {
        this.stack.get().clear();
        ProfileInstr globalInstr = new ProfileInstr("[Global variables and keys]", 0);
        globalInstr.start = System.currentTimeMillis();
        this.stack.get().add(globalInstr);
    }

    public void enter(InstructionInfo instruction, XPathContext context) {
        ProfileInstr pi = new ProfileInstr(instruction.getSystemId(), instruction.getLineNumber());
        pi.start = System.currentTimeMillis();
        this.stack.get().addLast(pi);
    }

    private void addTime(ProfileInstr instr, long selfTime) {
        if (selfTime == 0L) {
            return;
        }
        ProfileTime ent = this.timeMap.get().get(instr);
        if (ent == null) {
            ent = new ProfileTime(instr);
            this.timeMap.get().put(instr, ent);
        }
        ent.time += selfTime;
    }

    public void leave(InstructionInfo instruction) {
        ProfileInstr curInstr = this.stack.get().removeLast();
        long curTime = System.currentTimeMillis() - curInstr.start;
        long selfTime = curTime - curInstr.descendantTime;
        assert (selfTime >= 0L);
        this.addTime(curInstr, selfTime);
        ProfileInstr parentInstr = this.stack.get().getLast();
        parentInstr.descendantTime += curTime;
    }

    public void startCurrentItem(Item currentItem) {
    }

    public void endCurrentItem(Item currentItem) {
    }

    public ProfileTime[] getTimes() {
        ArrayList<ProfileTime> list = new ArrayList<ProfileTime>(this.timeMap.get().values());
        Collections.sort(list, new Comparator<ProfileTime>(){

            @Override
            public int compare(ProfileTime p1, ProfileTime p2) {
                if (p1.time != p2.time) {
                    return (int)(p1.time - p2.time);
                }
                if (!p1.instr.systemId.equals(p2.instr.systemId)) {
                    return p1.instr.systemId.compareTo(p2.instr.systemId);
                }
                return p1.instr.lineNum - p2.instr.lineNum;
            }
        });
        ProfileTime[] array = new ProfileTime[list.size()];
        list.toArray(array);
        this.timeMap.get().clear();
        return array;
    }

    public void printProfile() throws IOException {
        ProfileTime[] times = this.getTimes();
        int i = times.length - 1;
        while (i >= 0) {
            String s = String.valueOf(times[i].time) + " " + times[i].instr.systemId;
            if (times[i].instr.lineNum != 0) {
                s = String.valueOf(s) + ":" + times[i].instr.lineNum;
            }
            Trace.info(s);
            --i;
        }
    }

    public static class ProfileInstr {
        public String systemId;
        public int lineNum;
        public long start;
        public long descendantTime;

        public ProfileInstr(String sysid, int line) {
            this.systemId = sysid;
            this.lineNum = line;
        }

        public int hashCode() {
            if (this.systemId != null) {
                return this.lineNum ^ this.systemId.hashCode();
            }
            return this.lineNum;
        }

        public boolean equals(Object other) {
            if (!(other instanceof ProfileInstr)) {
                return false;
            }
            ProfileInstr p = (ProfileInstr)other;
            return p.systemId == this.systemId && p.lineNum == this.lineNum;
        }
    }

    public static class ProfileTime {
        public ProfileInstr instr;
        public long time;

        public ProfileTime(ProfileInstr instr) {
            this.instr = instr;
        }
    }
}

