/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.Arrays;
import org.apache.lucene.util.Prime;

public class LongSet {
    private int hashSize;
    private long[] ents;
    private int curSize = 0;

    public LongSet(int maxSize) {
        this.hashSize = Prime.findAfter(maxSize * 2);
        this.ents = new long[this.hashSize];
        Arrays.fill(this.ents, -1L);
    }

    public void add(long val) {
        int pos = (int)(val % (long)this.hashSize);
        while (true) {
            long cur;
            if ((cur = this.ents[pos]) == val) {
                return;
            }
            if (cur < 0L) break;
            pos = (pos + 1) % this.hashSize;
        }
        this.ents[pos] = val;
        ++this.curSize;
        if (this.curSize * 2 >= this.hashSize) {
            this.grow();
        }
    }

    public boolean contains(long val) {
        int pos = (int)(val % (long)this.hashSize);
        while (true) {
            long cur;
            if ((cur = this.ents[pos]) == val) {
                return true;
            }
            if (cur < 0L) break;
            pos = (pos + 1) % this.hashSize;
        }
        return false;
    }

    private void grow() {
        int newSize = Prime.findAfter(this.hashSize * 3 / 2);
        long[] newEnts = new long[newSize];
        Arrays.fill(newEnts, -1L);
        int i = 0;
        while (i < this.hashSize) {
            long val = this.ents[i];
            if (val >= 0L) {
                int pos = (int)(val % (long)newSize);
                while (newEnts[pos] >= 0L) {
                    pos = (pos + 1) % newSize;
                }
                newEnts[pos] = val;
            }
            ++i;
        }
        this.ents = newEnts;
        this.hashSize = newSize;
    }

    public int size() {
        return this.curSize;
    }
}

