/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spelt;

final class TRStringDistance2 {
    final char[] sa;
    final int n;
    final int[][][] cache = new int[30][][];

    public TRStringDistance2(String target) {
        this.sa = target.toCharArray();
        this.n = this.sa.length;
    }

    public final int getDistance(String other) {
        int[][] d;
        char[] ta = other.toCharArray();
        int m = ta.length;
        if (this.n == 0) {
            return m;
        }
        if (m == 0) {
            return this.n;
        }
        if (m >= this.cache.length) {
            d = TRStringDistance2.form(this.n, m);
        } else if (this.cache[m] != null) {
            d = this.cache[m];
        } else {
            this.cache[m] = TRStringDistance2.form(this.n, m);
            d = this.cache[m];
        }
        char s_i2 = '\u0000';
        int i = 1;
        while (i <= this.n) {
            char s_i = this.sa[i - 1];
            char t_j2 = '\u0000';
            int j = 1;
            while (j <= m) {
                char t_j = ta[j - 1];
                int baseCost = s_i == t_j ? 0 : 2;
                int replaceCost = d[i - 1][j - 1] + baseCost;
                int insertCost = d[i - 1][j] + (s_i == s_i2 ? 1 : 2);
                int deleteCost = d[i][j - 1] + (t_j == t_j2 ? 1 : 2);
                d[i][j] = TRStringDistance2.min3(replaceCost, insertCost, deleteCost);
                if (s_i != t_j && s_i == t_j2 && t_j == s_i2) {
                    d[i][j] = Math.min(d[i][j], d[i - 2][j - 2] + 1);
                }
                t_j2 = t_j;
                ++j;
            }
            s_i2 = s_i;
            ++i;
        }
        return d[this.n][m];
    }

    private static int[][] form(int n, int m) {
        int[][] d = new int[n + 1][m + 1];
        int i = 0;
        while (i <= n) {
            d[i][0] = i * 2;
            ++i;
        }
        int j = 0;
        while (j <= m) {
            d[0][j] = j;
            ++j;
        }
        return d;
    }

    private static int min3(int a, int b, int c) {
        int mi = a;
        if (b < mi) {
            mi = b;
        }
        if (c < mi) {
            mi = c;
        }
        return mi;
    }
}

