/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spelt;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.lucene.util.Hash64;
import org.apache.lucene.util.IntList;
import org.apache.lucene.util.LongList;

class FreqData {
    private LongList keys = new LongList();
    private IntList counts = new IntList();
    private int sortTop = 0;
    private static final int MAX_UNSORTED = 1000000;
    static final long MAGIC_NUM = 5792026535304261937L;

    FreqData() {
    }

    public final void add(String word, int count) {
        this.add(Hash64.hash(word), count);
    }

    public final void add(String word1, String word2, int count) {
        this.add(Hash64.hash(word1, word2), count);
    }

    public void add(long hash, int count) {
        int pos = this.searchSorted(hash);
        if (pos >= 0) {
            this.counts.set(pos, this.counts.get(pos) + count);
            return;
        }
        this.keys.add(hash);
        this.counts.add(count);
        if (this.keys.size() - this.sortTop > 1000000) {
            this.sort();
        }
    }

    private int searchSorted(long hash) {
        int low = 0;
        int high = this.sortTop - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            long probe = this.keys.get(mid);
            if (probe < hash) {
                low = mid + 1;
                continue;
            }
            if (probe > hash) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -1;
    }

    public final int get(String word) {
        return this.get(Hash64.hash(word));
    }

    public final int get(String word1, String word2) {
        return this.get(Hash64.hash(word1, word2));
    }

    public final int get(long hash) {
        this.sort();
        int pos = this.keys.binarySearch(hash);
        if (pos < 0) {
            return 0;
        }
        return this.counts.get(pos);
    }

    public void add(File f) throws IOException {
        int prevSize = this.keys.size();
        DataInputStream s = new DataInputStream(new BufferedInputStream(new FileInputStream(f)));
        try {
            long magic = s.readLong();
            if (magic != 5792026535304261937L) {
                throw new IOException("unrecognized format of frequency data");
            }
            int numCounts = s.readInt();
            this.keys.ensureCapacity(this.keys.size() + numCounts);
            this.counts.ensureCapacity(this.keys.size() + numCounts);
            long prevKey = -1L;
            int i = 0;
            while (i < numCounts) {
                long key = s.readLong();
                int count = s.readInt();
                if (key <= prevKey) {
                    throw new IOException("freq data was not sorted correctly on disk, or file is corrupt");
                }
                prevKey = key;
                if (count < 0) {
                    throw new IOException("frequency data file is corrupted");
                }
                this.keys.add(key);
                this.counts.add(count);
                ++i;
            }
            if (prevSize == 0) {
                this.sortTop = this.keys.size();
            }
        }
        finally {
            s.close();
        }
    }

    public void save(File f) throws IOException {
        this.sort();
        DataOutputStream s = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(f)));
        try {
            s.writeLong(5792026535304261937L);
            s.writeInt(this.keys.size());
            int i = 0;
            while (i < this.keys.size()) {
                s.writeLong(this.keys.get(i));
                s.writeInt(this.counts.get(i));
                ++i;
            }
        }
        finally {
            s.close();
        }
    }

    private void sort() {
        if (this.sortTop == this.keys.size()) {
            return;
        }
        int[] map = this.keys.calcSortMap();
        this.keys.remap(map);
        this.counts.remap(map);
        long key = this.keys.get(0);
        int count = this.counts.get(0);
        int dp = 0;
        int sp = 1;
        while (sp < this.keys.size()) {
            long nextKey = this.keys.get(sp);
            if (nextKey != key) {
                assert (nextKey > key) : "calcSortMap didn't work right";
                this.keys.set(dp, key);
                this.counts.set(dp, count);
                ++dp;
                key = nextKey;
                count = 0;
            }
            count += this.counts.get(sp);
            ++sp;
        }
        this.keys.set(dp, key);
        this.counts.set(dp, count);
        this.keys.resize(++dp);
        this.counts.resize(dp);
        this.sortTop = this.keys.size();
    }
}

