/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans;

import java.io.IOException;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.spans.Spans;

class SpanScorer
extends Scorer {
    protected Spans spans;
    protected Weight weight;
    protected float value;
    protected boolean firstTime = true;
    protected boolean more = true;
    protected int doc;
    protected float freq;

    SpanScorer(Spans spans, Weight weight, Similarity similarity) throws IOException {
        super(similarity);
        this.spans = spans;
        this.weight = weight;
        this.value = weight.getValue();
    }

    public boolean next() throws IOException {
        if (this.firstTime) {
            this.more = this.spans.next();
            this.firstTime = false;
        }
        return this.advance();
    }

    protected boolean advance() throws IOException {
        if (!this.more) {
            return false;
        }
        this.freq = 0.0f;
        this.doc = this.spans.doc();
        boolean anyMatches = false;
        while (this.more && this.doc == this.spans.doc()) {
            this.freq += this.spans.score();
            anyMatches = true;
            this.more = this.spans.next();
        }
        return this.more || anyMatches;
    }

    public int doc() {
        return this.doc;
    }

    public float score() throws IOException {
        return this.getSimilarity().tf(this.freq) * this.value;
    }

    public boolean skipTo(int target) throws IOException {
        if (this.firstTime || this.more && target > this.spans.doc()) {
            this.more = this.spans.skipTo(target);
            this.firstTime = false;
        }
        return this.advance();
    }

    public Explanation explain(int target) throws IOException {
        Explanation sfExpl = new Explanation(0.0f, "spanFreq, sum of:");
        this.more = this.spans.skipTo(target);
        this.freq = 0.0f;
        int nSpans = 0;
        while (this.more && this.spans.doc() == target) {
            float score = this.spans.score();
            sfExpl.addDetail(this.spans.explain());
            ++nSpans;
            this.freq += score;
            this.more = this.spans.next();
        }
        sfExpl.setValue(this.freq);
        Explanation tfExpl = new Explanation(this.getSimilarity().tf(this.freq), "tf(spanFreq=" + this.freq + ")");
        if (nSpans == 1) {
            tfExpl.addDetail(sfExpl.getDetails()[0]);
        } else {
            tfExpl.addDetail(sfExpl);
        }
        return tfExpl;
    }
}

