/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.Serializable;
import java.util.Hashtable;
import sun.awt.FontConfiguration;
import sun.awt.PlatformFont;
import sun.awt.image.ByteComponentRaster;
import sun.awt.image.BytePackedRaster;
import sun.awt.windows.FontKey1;
import sun.awt.windows.FontKey2;
import sun.awt.windows.WPrinterJob;
import sun.font.CompositeFont;
import sun.font.Font2D;
import sun.font.FontManager;
import sun.java2d.SunGraphicsEnvironment;
import sun.print.PathGraphics;
import sun.print.ProxyGraphics2D;

class WPathGraphics
extends PathGraphics {
    private static final int DEFAULT_USER_RES = 72;
    private static final float MIN_DEVICE_LINEWIDTH = 1.2f;
    private static final float MAX_THINLINE_INCHES = 0.014f;
    private Font lastFont;
    private Font lastDeviceSizeFont;
    private int lastAngle;
    private float lastScaledFontSize;
    private float lastAverageWidthScale;
    private FontKey1 fontKey1;
    private FontKey2 fontKey2;

    WPathGraphics(Graphics2D graphics2D, PrinterJob printerJob, Printable printable, PageFormat pageFormat, int n, boolean bl) {
        super(graphics2D, printerJob, printable, pageFormat, n, bl);
    }

    public Graphics create() {
        return new WPathGraphics((Graphics2D)this.getDelegate().create(), this.getPrinterJob(), this.getPrintable(), this.getPageFormat(), this.getPageIndex(), this.canDoRedraws());
    }

    public void draw(Shape shape) {
        Stroke stroke = this.getStroke();
        if (stroke instanceof BasicStroke) {
            BasicStroke basicStroke = null;
            BasicStroke basicStroke2 = (BasicStroke)stroke;
            float f = basicStroke2.getLineWidth();
            Point2D.Float float_ = new Point2D.Float(f, f);
            AffineTransform affineTransform = this.getTransform();
            affineTransform.deltaTransform(float_, float_);
            float f2 = Math.min(Math.abs(float_.x), Math.abs(float_.y));
            if (f2 < 1.2f) {
                Point2D.Float float_2 = new Point2D.Float(1.2f, 1.2f);
                try {
                    AffineTransform affineTransform2 = affineTransform.createInverse();
                    affineTransform2.deltaTransform(float_2, float_2);
                    float f3 = Math.max(Math.abs(float_2.x), Math.abs(float_2.y));
                    basicStroke = new BasicStroke(f3, basicStroke2.getEndCap(), basicStroke2.getLineJoin(), basicStroke2.getMiterLimit(), basicStroke2.getDashArray(), basicStroke2.getDashPhase());
                    this.setStroke(basicStroke);
                }
                catch (NoninvertibleTransformException noninvertibleTransformException) {
                    // empty catch block
                }
            }
            super.draw(shape);
            if (basicStroke != null) {
                this.setStroke(basicStroke2);
            }
        } else {
            super.draw(shape);
        }
    }

    public void drawString(String string, int n, int n2) {
        this.drawString(string, (float)n, (float)n2);
    }

    public void drawString(String string, float f, float f2) {
        this.drawString(string, f, f2, this.getFont(), this.getFontRenderContext(), 0.0f);
    }

    protected int platformFontCount(Font font, String string) {
        boolean bl;
        AffineTransform affineTransform = this.getTransform();
        AffineTransform affineTransform2 = new AffineTransform(affineTransform);
        affineTransform2.concatenate(this.getFont().getTransform());
        int n = affineTransform2.getType();
        boolean bl2 = bl = n != 32 && (n & 0x40) == 0;
        if (!bl) {
            return 0;
        }
        WPrinterJob wPrinterJob = (WPrinterJob)this.getPrinterJob();
        Font2D font2D = FontManager.getFont2D(font);
        if (font2D instanceof CompositeFont) {
            if (!((CompositeFont)font2D).isStdComposite() || FontManager.usingAlternateCompositeFonts()) {
                Font font2 = new Font(font.getFamily(), font.getStyle(), 12);
                if (font2.canDisplayUpTo(string) == -1) {
                    return wPrinterJob.setFont(font2, 0, 1.0f) ? 1 : 0;
                }
                return 0;
            }
            return wPrinterJob.setLogicalFont(font, 0, 1.0f) ? 1 : 0;
        }
        return wPrinterJob.setFont(font, 0, 1.0f) ? 1 : 0;
    }

    public void drawString(String string, float f, float f2, Font font, FontRenderContext fontRenderContext, float f3) {
        if (string.length() == 0) {
            return;
        }
        if (font.hasLayoutAttributes() && !this.printingGlyphVector) {
            TextLayout textLayout = new TextLayout(string, font, fontRenderContext);
            textLayout.draw(this, f, f2);
            return;
        }
        Font font2 = this.getFont();
        if (!font2.equals(font)) {
            this.setFont(font);
        } else {
            font2 = null;
        }
        boolean bl = false;
        AffineTransform affineTransform = this.getTransform();
        AffineTransform affineTransform2 = new AffineTransform(affineTransform);
        affineTransform2.concatenate(this.getFont().getTransform());
        int n = affineTransform2.getType();
        boolean bl2 = n != 32 && (n & 0x40) == 0;
        boolean bl3 = this.stringNeedsShaping(string);
        if (!WPrinterJob.shapeTextProp && bl2 && !bl3) {
            Font font3;
            double d;
            float f4;
            Serializable serializable;
            Point2D.Float float_ = new Point2D.Float(f, f2);
            if (this.getFont().isTransformed()) {
                serializable = this.getFont().getTransform();
                f4 = (float)((AffineTransform)serializable).getTranslateX();
                float f5 = (float)((AffineTransform)serializable).getTranslateY();
                if ((double)Math.abs(f4) < 1.0E-5) {
                    f4 = 0.0f;
                }
                if ((double)Math.abs(f5) < 1.0E-5) {
                    f5 = 0.0f;
                }
                float_.x += f4;
                float_.y += f5;
            }
            affineTransform.transform(float_, float_);
            serializable = this.getFont();
            f4 = ((Font)serializable).getSize2D();
            Point2D.Double double_ = new Point2D.Double(0.0, 1.0);
            affineTransform2.deltaTransform(double_, double_);
            double d2 = Math.sqrt(double_.x * double_.x + double_.y * double_.y);
            float f6 = (float)((double)f4 * d2);
            Point2D.Double double_2 = new Point2D.Double(1.0, 0.0);
            affineTransform2.deltaTransform(double_2, double_2);
            double d3 = Math.sqrt(double_2.x * double_2.x + double_2.y * double_2.y);
            float f7 = (float)((double)f4 * d3);
            float f8 = (float)(d3 / d2);
            if (f8 > 0.999f && f8 < 1.001f) {
                f8 = 1.0f;
            }
            if ((d = Math.toDegrees(Math.atan2(double_2.y, double_2.x))) < 0.0) {
                d += 360.0;
            }
            if (d != 0.0) {
                d = 360.0 - d;
            }
            int n2 = (int)Math.round(d * 10.0);
            WPrinterJob wPrinterJob = (WPrinterJob)this.getPrinterJob();
            if (serializable != null && this.lastFont != null && this.lastDeviceSizeFont != null && f6 == this.lastScaledFontSize && f8 == this.lastAverageWidthScale && ((Font)serializable).equals(this.lastFont) && n2 == this.lastAngle) {
                font3 = this.lastDeviceSizeFont;
            } else {
                if (this.fontKey1 == null) {
                    this.fontKey1 = new FontKey1();
                }
                this.fontKey1.init((Font)serializable, n2, f6, f8);
                font3 = wPrinterJob.fontCache1.get(this.fontKey1);
                if (font3 == null) {
                    font3 = ((Font)serializable).deriveFont(f6);
                    if (wPrinterJob.fontCache1.size() > 500) {
                        wPrinterJob.fontCache1 = new Hashtable();
                    }
                    wPrinterJob.fontCache1.put(this.fontKey1.copy(), font3);
                }
                this.lastAngle = n2;
                this.lastScaledFontSize = f6;
                this.lastAverageWidthScale = f8;
                this.lastDeviceSizeFont = font3;
                this.lastFont = serializable;
            }
            Font2D font2D = FontManager.getFont2D(font3);
            boolean bl4 = font2D instanceof CompositeFont && !((CompositeFont)font2D).isStdComposite();
            Font font4 = null;
            boolean bl5 = false;
            boolean bl6 = wPrinterJob.setFont(font3, n2, f8);
            if (bl6 && bl4) {
                Font font5 = new Font(font3.getFamily(), font3.getStyle(), 12);
                boolean bl7 = bl6 = font5.canDisplayUpTo(string) == -1;
            }
            if (!bl6 && SunGraphicsEnvironment.isLogicalFont(font3)) {
                if (!FontManager.usingAlternateCompositeFonts() && !bl4) {
                    font4 = font3;
                    if (FontConfiguration.isLogicalFontFaceName(font4.getFontName())) {
                        int n3 = font2D.getStyle() | font4.getStyle();
                        if (this.fontKey2 == null) {
                            this.fontKey2 = new FontKey2();
                        }
                        this.fontKey2.init(font3.getFamily(), n3, font3.getSize(), n2, f8);
                        font4 = wPrinterJob.fontCache2.get(this.fontKey2);
                        if (font4 == null) {
                            font4 = new Font(font3.getFamily(), n3, font3.getSize());
                            if (wPrinterJob.fontCache2.size() > 500) {
                                wPrinterJob.fontCache2 = new Hashtable();
                            }
                            wPrinterJob.fontCache2.put(this.fontKey2.copy(), font4);
                        }
                    }
                    bl5 = wPrinterJob.setLogicalFont(font4, n2, f8);
                }
                if (bl5) {
                    try {
                        if (((PlatformFont)font4.getPeer()).makeMultiCharsetString(string, false) == null) {
                            bl5 = false;
                        }
                    }
                    catch (Exception exception) {
                        bl5 = false;
                    }
                }
            }
            if (bl6 || bl5) {
                try {
                    wPrinterJob.setTextColor((Color)this.getPaint());
                }
                catch (ClassCastException classCastException) {
                    if (font2 != null) {
                        this.setFont(font2);
                    }
                    throw new IllegalArgumentException("Expected a Color instance");
                }
                if (this.getClip() != null) {
                    this.deviceClip(this.getClip().getPathIterator(affineTransform));
                }
                wPrinterJob.textOut(string, float_.x, float_.y, bl5 ? font4 : null);
                bl = true;
            }
        }
        if (!bl) {
            if (font2 != null) {
                this.setFont(font2);
                font2 = null;
            }
            super.drawString(string, f, f2, font, fontRenderContext, f3);
        }
        if (font2 != null) {
            this.setFont(font2);
        }
    }

    private boolean stringNeedsShaping(String string) {
        boolean bl = false;
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if ((c & 0xFE00) == 0) continue;
            if (c >= '\u0590' && c <= '\u05ff') {
                bl = true;
                break;
            }
            if (c >= '\u0600' && c <= '\u06ff') {
                bl = true;
                break;
            }
            if (c >= '\u202a' && c <= '\u202e') {
                bl = true;
                break;
            }
            if (c < '\u206a' || c > '\u206f') continue;
            bl = true;
            break;
        }
        return bl;
    }

    protected boolean drawImageToPlatform(Image image, AffineTransform affineTransform, Color color, int n, int n2, int n3, int n4, boolean bl) {
        boolean bl2;
        BufferedImage bufferedImage = this.getBufferedImage(image);
        if (bufferedImage == null) {
            return true;
        }
        WPrinterJob wPrinterJob = (WPrinterJob)this.getPrinterJob();
        AffineTransform affineTransform2 = this.getTransform();
        if (affineTransform == null) {
            affineTransform = new AffineTransform();
        }
        affineTransform2.concatenate(affineTransform);
        double[] dArray = new double[6];
        affineTransform2.getMatrix(dArray);
        Point2D.Float float_ = new Point2D.Float(1.0f, 0.0f);
        Point2D.Float float_2 = new Point2D.Float(0.0f, 1.0f);
        affineTransform2.deltaTransform(float_, float_);
        affineTransform2.deltaTransform(float_2, float_2);
        Point2D.Float float_3 = new Point2D.Float(0.0f, 0.0f);
        double d = float_.distance(float_3);
        double d2 = float_2.distance(float_3);
        double d3 = wPrinterJob.getXRes();
        double d4 = wPrinterJob.getYRes();
        double d5 = d3 / 72.0;
        double d6 = d4 / 72.0;
        int n5 = affineTransform2.getType();
        boolean bl3 = bl2 = (n5 & 0x30) != 0;
        if (bl2) {
            if (d > d5) {
                d = d5;
            }
            if (d2 > d6) {
                d2 = d6;
            }
        }
        if (d != 0.0 && d2 != 0.0) {
            AffineTransform affineTransform3 = new AffineTransform(dArray[0] / d, dArray[1] / d2, dArray[2] / d, dArray[3] / d2, dArray[4] / d, dArray[5] / d2);
            Rectangle2D.Float float_4 = new Rectangle2D.Float(n, n2, n3, n4);
            Shape shape = affineTransform3.createTransformedShape(float_4);
            Rectangle2D rectangle2D = shape.getBounds2D();
            rectangle2D.setRect(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth() + 0.001, rectangle2D.getHeight() + 0.001);
            int n6 = (int)rectangle2D.getWidth();
            int n7 = (int)rectangle2D.getHeight();
            if (n6 > 0 && n7 > 0) {
                byte[] byArray;
                Object object;
                boolean bl5 = true;
                if (!bl && this.hasTransparentPixels(bufferedImage)) {
                    bl5 = false;
                    if (this.isBitmaskTransparency(bufferedImage)) {
                        if (color == null) {
                            if (this.drawBitmaskImage(bufferedImage, affineTransform, color, n, n2, n3, n4)) {
                                return true;
                            }
                        } else if (color.getTransparency() == 1) {
                            bl5 = true;
                        }
                    }
                    if (!this.canDoRedraws()) {
                        bl5 = true;
                    }
                } else {
                    color = null;
                }
                if ((n + n3 > bufferedImage.getWidth(null) || n2 + n4 > bufferedImage.getHeight(null)) && this.canDoRedraws()) {
                    bl5 = false;
                }
                if (!bl5) {
                    int byArray2;
                    affineTransform2.getMatrix(dArray);
                    AffineTransform affineTransform4 = new AffineTransform(dArray[0] / d5, dArray[1] / d6, dArray[2] / d5, dArray[3] / d6, dArray[4] / d5, dArray[5] / d6);
                    Rectangle2D.Float float_5 = new Rectangle2D.Float(n, n2, n3, n4);
                    Shape shape2 = affineTransform2.createTransformedShape(float_5);
                    Rectangle2D rectangle2D2 = shape2.getBounds2D();
                    rectangle2D2.setRect(rectangle2D2.getX(), rectangle2D2.getY(), rectangle2D2.getWidth() + 0.001, rectangle2D2.getHeight() + 0.001);
                    int n9 = (int)rectangle2D2.getWidth();
                    int n10 = (int)rectangle2D2.getHeight();
                    int n15 = n9 * n10 * 3;
                    int bl6 = 0x800000;
                    double object2 = d3 < d4 ? d3 : d4;
                    double shape3 = 1.0;
                    for (byArray2 = (int)object2; n15 > bl6 && byArray2 > 72; byArray2 /= 2, n15 /= 4) {
                        shape3 *= 2.0;
                    }
                    if (byArray2 < 72) {
                        shape3 = object2 / 72.0;
                    }
                    rectangle2D2.setRect(rectangle2D2.getX() / shape3, rectangle2D2.getY() / shape3, rectangle2D2.getWidth() / shape3, rectangle2D2.getHeight() / shape3);
                    wPrinterJob.saveState(this.getTransform(), this.getClip(), rectangle2D2, shape3, shape3);
                    return true;
                }
                int n13 = 5;
                IndexColorModel indexColorModel = null;
                ColorModel colorModel = bufferedImage.getColorModel();
                int n14 = bufferedImage.getType();
                if (colorModel instanceof IndexColorModel && colorModel.getPixelSize() <= 8 && (n14 == 12 || n14 == 13)) {
                    indexColorModel = (IndexColorModel)colorModel;
                    n13 = n14;
                    if (n14 == 12 && colorModel.getPixelSize() == 2) {
                        int[] nArray = new int[16];
                        indexColorModel.getRGBs(nArray);
                        boolean bl4 = indexColorModel.getTransparency() != 1;
                        int bufferedImage2 = indexColorModel.getTransparentPixel();
                        indexColorModel = new IndexColorModel(4, 16, nArray, 0, bl4, bufferedImage2, 0);
                    }
                }
                int n16 = (int)rectangle2D.getWidth();
                int n8 = (int)rectangle2D.getHeight();
                BufferedImage bufferedImage2 = null;
                boolean bl4 = true;
                if (bl4) {
                    bufferedImage2 = indexColorModel == null ? new BufferedImage(n16, n8, n13) : new BufferedImage(n16, n8, n13, indexColorModel);
                    object = bufferedImage2.createGraphics();
                    ((Graphics)object).clipRect(0, 0, bufferedImage2.getWidth(), bufferedImage2.getHeight());
                    ((Graphics2D)object).translate(-rectangle2D.getX(), -rectangle2D.getY());
                    ((Graphics2D)object).transform(affineTransform3);
                    if (color == null) {
                        color = Color.white;
                    }
                    ((Graphics)object).drawImage(bufferedImage, n, n2, n + n3, n2 + n4, n, n2, n + n3, n2 + n4, color, null);
                    ((Graphics)object).dispose();
                } else {
                    bufferedImage2 = bufferedImage;
                }
                object = new Rectangle2D.Float((float)(rectangle2D.getX() * d), (float)(rectangle2D.getY() * d2), (float)(rectangle2D.getWidth() * d), (float)(rectangle2D.getHeight() * d2));
                WritableRaster writableRaster = bufferedImage2.getRaster();
                if (writableRaster instanceof ByteComponentRaster) {
                    byArray = ((ByteComponentRaster)writableRaster).getDataStorage();
                } else if (writableRaster instanceof BytePackedRaster) {
                    byArray = ((BytePackedRaster)writableRaster).getDataStorage();
                } else {
                    return false;
                }
                Shape shape2 = this.getClip();
                this.clip(affineTransform.createTransformedShape(float_4));
                this.deviceClip(this.getClip().getPathIterator(this.getTransform()));
                wPrinterJob.drawDIBImage(byArray, ((Rectangle2D.Float)object).x, ((Rectangle2D.Float)object).y, (float)Math.rint((double)((Rectangle2D.Float)object).width + 0.5), (float)Math.rint((double)((Rectangle2D.Float)object).height + 0.5), 0.0f, 0.0f, bufferedImage2.getWidth(), bufferedImage2.getHeight(), indexColorModel);
                this.setClip(shape2);
            }
        }
        return true;
    }

    public void redrawRegion(Rectangle2D rectangle2D, double d, double d2, Shape shape, AffineTransform affineTransform) throws PrinterException {
        WPrinterJob wPrinterJob = (WPrinterJob)this.getPrinterJob();
        Printable printable = this.getPrintable();
        PageFormat pageFormat = this.getPageFormat();
        int n = this.getPageIndex();
        BufferedImage bufferedImage = new BufferedImage((int)rectangle2D.getWidth(), (int)rectangle2D.getHeight(), 5);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        ProxyGraphics2D proxyGraphics2D = new ProxyGraphics2D(graphics2D, wPrinterJob);
        proxyGraphics2D.setColor(Color.white);
        proxyGraphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        proxyGraphics2D.clipRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        proxyGraphics2D.translate(-rectangle2D.getX(), -rectangle2D.getY());
        float f = (float)(wPrinterJob.getXRes() / d);
        float f2 = (float)(wPrinterJob.getYRes() / d2);
        proxyGraphics2D.scale(f / 72.0f, f2 / 72.0f);
        proxyGraphics2D.translate(-wPrinterJob.getPhysicalPrintableX(pageFormat.getPaper()) / wPrinterJob.getXRes() * 72.0, -wPrinterJob.getPhysicalPrintableY(pageFormat.getPaper()) / wPrinterJob.getYRes() * 72.0);
        proxyGraphics2D.transform(new AffineTransform(this.getPageFormat().getMatrix()));
        proxyGraphics2D.setPaint(Color.black);
        printable.print(proxyGraphics2D, pageFormat, n);
        graphics2D.dispose();
        this.deviceClip(shape.getPathIterator(affineTransform));
        Rectangle2D.Float float_ = new Rectangle2D.Float((float)(rectangle2D.getX() * d), (float)(rectangle2D.getY() * d2), (float)(rectangle2D.getWidth() * d), (float)(rectangle2D.getHeight() * d2));
        ByteComponentRaster byteComponentRaster = (ByteComponentRaster)bufferedImage.getRaster();
        wPrinterJob.drawImage3ByteBGR(byteComponentRaster.getDataStorage(), float_.x, float_.y, float_.width, float_.height, 0.0f, 0.0f, bufferedImage.getWidth(), bufferedImage.getHeight());
    }

    protected void deviceFill(PathIterator pathIterator, Color color) {
        WPrinterJob wPrinterJob = (WPrinterJob)this.getPrinterJob();
        this.convertToWPath(pathIterator);
        wPrinterJob.selectSolidBrush(color);
        wPrinterJob.fillPath();
    }

    protected void deviceClip(PathIterator pathIterator) {
        WPrinterJob wPrinterJob = (WPrinterJob)this.getPrinterJob();
        this.convertToWPath(pathIterator);
        wPrinterJob.selectClipPath();
    }

    protected void deviceFrameRect(int n, int n2, int n3, int n4, Color color) {
        boolean bl;
        AffineTransform affineTransform = this.getTransform();
        int n5 = affineTransform.getType();
        boolean bl2 = bl = (n5 & 0x30) != 0;
        if (bl) {
            this.draw(new Rectangle2D.Float(n, n2, n3, n4));
            return;
        }
        Stroke stroke = this.getStroke();
        if (stroke instanceof BasicStroke) {
            BasicStroke basicStroke = (BasicStroke)stroke;
            int n6 = basicStroke.getEndCap();
            int n7 = basicStroke.getLineJoin();
            if (n6 == 2 && n7 == 0 && basicStroke.getMiterLimit() == 10.0f) {
                float f = basicStroke.getLineWidth();
                Point2D.Float float_ = new Point2D.Float(f, f);
                affineTransform.deltaTransform(float_, float_);
                float f2 = Math.min(Math.abs(float_.x), Math.abs(float_.y));
                Point2D.Float float_2 = new Point2D.Float(n, n2);
                affineTransform.transform(float_2, float_2);
                Point2D.Float float_3 = new Point2D.Float(n + n3, n2 + n4);
                affineTransform.transform(float_3, float_3);
                float f3 = (float)(float_3.getX() - float_2.getX());
                float f4 = (float)(float_3.getY() - float_2.getY());
                WPrinterJob wPrinterJob = (WPrinterJob)this.getPrinterJob();
                if (wPrinterJob.selectStylePen(n6, n7, f2, color)) {
                    wPrinterJob.frameRect((float)float_2.getX(), (float)float_2.getY(), f3, f4);
                } else {
                    double d = Math.min(wPrinterJob.getXRes(), wPrinterJob.getYRes());
                    if ((double)f2 / d < (double)0.014f) {
                        wPrinterJob.selectPen(f2, color);
                        wPrinterJob.frameRect((float)float_2.getX(), (float)float_2.getY(), f3, f4);
                    } else {
                        this.draw(new Rectangle2D.Float(n, n2, n3, n4));
                    }
                }
            } else {
                this.draw(new Rectangle2D.Float(n, n2, n3, n4));
            }
        }
    }

    protected void deviceFillRect(int n, int n2, int n3, int n4, Color color) {
        boolean bl;
        AffineTransform affineTransform = this.getTransform();
        int n5 = affineTransform.getType();
        boolean bl2 = bl = (n5 & 0x30) != 0;
        if (bl) {
            this.fill(new Rectangle2D.Float(n, n2, n3, n4));
            return;
        }
        Point2D.Float float_ = new Point2D.Float(n, n2);
        affineTransform.transform(float_, float_);
        Point2D.Float float_2 = new Point2D.Float(n + n3, n2 + n4);
        affineTransform.transform(float_2, float_2);
        float f = (float)(float_2.getX() - float_.getX());
        float f2 = (float)(float_2.getY() - float_.getY());
        WPrinterJob wPrinterJob = (WPrinterJob)this.getPrinterJob();
        wPrinterJob.fillRect((float)float_.getX(), (float)float_.getY(), f, f2, color);
    }

    protected void deviceDrawLine(int n, int n2, int n3, int n4, Color color) {
        Stroke stroke = this.getStroke();
        if (stroke instanceof BasicStroke) {
            WPrinterJob wPrinterJob;
            BasicStroke basicStroke = (BasicStroke)stroke;
            if (basicStroke.getDashArray() != null) {
                this.draw(new Line2D.Float(n, n2, n3, n4));
                return;
            }
            float f = basicStroke.getLineWidth();
            Point2D.Float float_ = new Point2D.Float(f, f);
            AffineTransform affineTransform = this.getTransform();
            affineTransform.deltaTransform(float_, float_);
            float f2 = Math.min(Math.abs(float_.x), Math.abs(float_.y));
            Point2D.Float float_2 = new Point2D.Float(n, n2);
            affineTransform.transform(float_2, float_2);
            Point2D.Float float_3 = new Point2D.Float(n3, n4);
            affineTransform.transform(float_3, float_3);
            int n5 = basicStroke.getEndCap();
            int n6 = basicStroke.getLineJoin();
            if (float_3.getX() == float_2.getX() && float_3.getY() == float_2.getY()) {
                n5 = 1;
            }
            if ((wPrinterJob = (WPrinterJob)this.getPrinterJob()).selectStylePen(n5, n6, f2, color)) {
                wPrinterJob.moveTo((float)float_2.getX(), (float)float_2.getY());
                wPrinterJob.lineTo((float)float_3.getX(), (float)float_3.getY());
            } else {
                double d = Math.min(wPrinterJob.getXRes(), wPrinterJob.getYRes());
                if (n5 == 1 || (n == n3 || n2 == n4) && (double)f2 / d < (double)0.014f) {
                    wPrinterJob.selectPen(f2, color);
                    wPrinterJob.moveTo((float)float_2.getX(), (float)float_2.getY());
                    wPrinterJob.lineTo((float)float_3.getX(), (float)float_3.getY());
                } else {
                    this.draw(new Line2D.Float(n, n2, n3, n4));
                }
            }
        }
    }

    private void convertToWPath(PathIterator pathIterator) {
        float[] fArray = new float[6];
        WPrinterJob wPrinterJob = (WPrinterJob)this.getPrinterJob();
        int n = pathIterator.getWindingRule() == 0 ? 1 : 2;
        wPrinterJob.setPolyFillMode(n);
        wPrinterJob.beginPath();
        while (!pathIterator.isDone()) {
            int n2 = pathIterator.currentSegment(fArray);
            switch (n2) {
                case 0: {
                    wPrinterJob.moveTo(fArray[0], fArray[1]);
                    break;
                }
                case 1: {
                    wPrinterJob.lineTo(fArray[0], fArray[1]);
                    break;
                }
                case 2: {
                    int n3 = wPrinterJob.getPenX();
                    int n4 = wPrinterJob.getPenY();
                    float f = (float)n3 + (fArray[0] - (float)n3) * 2.0f / 3.0f;
                    float f2 = (float)n4 + (fArray[1] - (float)n4) * 2.0f / 3.0f;
                    float f3 = fArray[2] - (fArray[2] - fArray[0]) * 2.0f / 3.0f;
                    float f4 = fArray[3] - (fArray[3] - fArray[1]) * 2.0f / 3.0f;
                    wPrinterJob.polyBezierTo(f, f2, f3, f4, fArray[2], fArray[3]);
                    break;
                }
                case 3: {
                    wPrinterJob.polyBezierTo(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                    break;
                }
                case 4: {
                    wPrinterJob.closeFigure();
                }
            }
            pathIterator.next();
        }
        wPrinterJob.endPath();
    }
}

