/*
 * Decompiled with CFR 0.152.
 */
package com.apple.mrj;

import com.apple.eawt.Application;
import com.apple.eawt.ApplicationAdapter;
import com.apple.eawt.ApplicationEvent;
import com.apple.eawt.ApplicationListener;
import com.apple.eio.FileManager;
import com.apple.mrj.MRJAboutHandler;
import com.apple.mrj.MRJOSType;
import com.apple.mrj.MRJOpenApplicationHandler;
import com.apple.mrj.MRJOpenDocumentHandler;
import com.apple.mrj.MRJPrefsHandler;
import com.apple.mrj.MRJPrintDocumentHandler;
import com.apple.mrj.MRJQuitHandler;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

class MRJPriv {
    private MRJPriv() {
    }

    static boolean setFileLastModified(File file, long aDate) {
        return file.setLastModified(aDate);
    }

    static void setDefaultFileType(MRJOSType defaultType) {
    }

    static void setDefaultFileCreator(MRJOSType defaultCreator) {
    }

    static void doSetFile(File file, MRJOSType type, MRJOSType creator) throws IOException {
        FileManager.setFileTypeAndCreator((String)file.toString(), (int)type.toInt(), (int)creator.toInt());
    }

    static final void setFileTypeAndCreator(File file, MRJOSType type, MRJOSType creator) throws IOException {
        MRJPriv.doSetFile(file, type, creator);
    }

    static final void setFileType(File file, MRJOSType type) throws IOException {
        FileManager.setFileType((String)file.toString(), (int)type.toInt());
    }

    static final void setFileCreator(File file, MRJOSType creator) throws IOException {
        FileManager.setFileType((String)file.toString(), (int)creator.toInt());
    }

    static final MRJOSType getFileType(File file) throws IOException {
        return new MRJOSType(FileManager.getFileType((String)file.toString()));
    }

    static final MRJOSType getFileCreator(File file) throws IOException {
        return new MRJOSType(FileManager.getFileCreator((String)file.toString()));
    }

    static File findFolder(MRJOSType folderType) throws FileNotFoundException {
        return new File(FileManager.findFolder((int)folderType.toInt()));
    }

    static File findFolder(short domain, MRJOSType folderType) throws FileNotFoundException {
        return new File(FileManager.findFolder((short)domain, (int)folderType.toInt()));
    }

    static File findFolder(short domain, MRJOSType folderType, boolean createIfNeeded) throws FileNotFoundException {
        return new File(FileManager.findFolder((short)domain, (int)folderType.toInt(), (boolean)createIfNeeded));
    }

    static File findApplication(MRJOSType applSig) throws FileNotFoundException {
        return null;
    }

    static void openURL(String url) throws IOException {
        FileManager.openURL((String)url);
    }

    static File getBundleResource(String resourceName, String subDirName) throws FileNotFoundException {
        return new File(FileManager.getResource((String)resourceName, (String)subDirName));
    }

    static synchronized void registerAboutHandler(MRJAboutHandler handler) {
        Application fApplication = new Application();
        MRJAboutApplicationAdapter fAdapter = new MRJAboutApplicationAdapter(handler);
        fApplication.addApplicationListener((ApplicationListener)fAdapter);
    }

    static synchronized void registerOpenApplicationHandler(MRJOpenApplicationHandler handler) {
        Application fApplication = new Application();
        MRJOpenApplicationApplicationAdapter fAdapter = new MRJOpenApplicationApplicationAdapter(handler);
        fApplication.addApplicationListener((ApplicationListener)fAdapter);
    }

    static synchronized void registerOpenDocumentHandler(MRJOpenDocumentHandler handler) {
        Application fApplication = new Application();
        MRJOpenDocumentApplicationAdapter fAdapter = new MRJOpenDocumentApplicationAdapter(handler);
        fApplication.addApplicationListener((ApplicationListener)fAdapter);
    }

    static synchronized void registerPrintDocumentHandler(MRJPrintDocumentHandler handler) {
        Application fApplication = new Application();
        MRJPrintDocumentApplicationAdapter fAdapter = new MRJPrintDocumentApplicationAdapter(handler);
        fApplication.addApplicationListener((ApplicationListener)fAdapter);
    }

    static synchronized void registerQuitHandler(MRJQuitHandler handler) {
        Application fApplication = new Application();
        MRJQuitApplicationAdapter fAdapter = new MRJQuitApplicationAdapter(handler);
        fApplication.addApplicationListener((ApplicationListener)fAdapter);
    }

    static synchronized void registerPrefsHandler(MRJPrefsHandler handler) {
        Application fApplication = new Application();
        MRJPreferencesApplicationAdapter fAdapter = new MRJPreferencesApplicationAdapter(handler);
        fApplication.setEnabledPreferencesMenu(true);
        fApplication.addApplicationListener((ApplicationListener)fAdapter);
    }

    static final void setMenuItemCmdKey(Menu menu, int item, char ch) {
        MRJPriv.setMenuItemCmdKey(menu.getItem(item), ch);
    }

    static final void setMenuItemCmdKey(MenuItem item, char ch) {
        item.setShortcut(new MenuShortcut(ch, false));
    }

    static final boolean isMRJToolkitAvailable() {
        return false;
    }

    private static class MRJQuitApplicationAdapter
    extends ApplicationAdapter {
        MRJQuitHandler handler;

        public MRJQuitApplicationAdapter(MRJQuitHandler o) {
            this.handler = o;
        }

        public void handleQuit(ApplicationEvent e) {
            try {
                this.handler.handleQuit();
            }
            catch (IllegalStateException ex) {
                e.setHandled(false);
            }
        }
    }

    private static class MRJPreferencesApplicationAdapter
    extends ApplicationAdapter {
        MRJPrefsHandler handler;

        public MRJPreferencesApplicationAdapter(MRJPrefsHandler o) {
            this.handler = o;
        }

        public void handlePreferences(ApplicationEvent e) {
            this.handler.handlePrefs();
        }
    }

    private static class MRJPrintDocumentApplicationAdapter
    extends ApplicationAdapter {
        MRJPrintDocumentHandler handler;

        public MRJPrintDocumentApplicationAdapter(MRJPrintDocumentHandler o) {
            this.handler = o;
        }

        public void handlePrintFile(ApplicationEvent e) {
            this.handler.handlePrintFile(new File(e.getFilename()));
        }
    }

    private static class MRJOpenDocumentApplicationAdapter
    extends ApplicationAdapter {
        MRJOpenDocumentHandler handler;

        public MRJOpenDocumentApplicationAdapter(MRJOpenDocumentHandler o) {
            this.handler = o;
        }

        public void handleOpenFile(ApplicationEvent e) {
            this.handler.handleOpenFile(new File(e.getFilename()));
        }
    }

    private static class MRJOpenApplicationApplicationAdapter
    extends ApplicationAdapter {
        MRJOpenApplicationHandler handler;

        public MRJOpenApplicationApplicationAdapter(MRJOpenApplicationHandler o) {
            this.handler = o;
        }

        public void handleOpenApplication(ApplicationEvent e) {
            this.handler.handleOpenApplication();
        }
    }

    private static class MRJAboutApplicationAdapter
    extends ApplicationAdapter {
        MRJAboutHandler handler;

        public MRJAboutApplicationAdapter(MRJAboutHandler o) {
            this.handler = o;
        }

        public void handleAbout(ApplicationEvent e) {
            this.handler.handleAbout();
            e.setHandled(true);
        }
    }
}

