/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.LabelUI;
import org.openide.awt.HtmlRenderer;
import org.openide.awt.HtmlRendererImpl;

class HtmlLabelUI
extends LabelUI {
    private static final boolean antialias = Boolean.getBoolean("nb.cellrenderer.antialiasing") || "GTK".equals(UIManager.getLookAndFeel().getID()) && HtmlLabelUI.gtkShouldAntialias();
    private static HtmlLabelUI uiInstance = null;
    private static int FIXED_HEIGHT = 0;
    private static Map hintsMap;
    private static Color unfocusedSelBg;
    private static Color unfocusedSelFg;
    private static Boolean gtkAA;

    HtmlLabelUI() {
    }

    public static ComponentUI createUI(JComponent jComponent) {
        if (uiInstance == null) {
            uiInstance = new HtmlLabelUI();
        }
        return uiInstance;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return this.calcPreferredSize((HtmlRendererImpl)jComponent);
    }

    private static int textWidth(String string, Graphics graphics, Font font, boolean bl) {
        if (string != null) {
            if (bl) {
                return Math.round(Math.round(Math.ceil(HtmlRenderer.renderHTML(string, graphics, 0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE, font, Color.BLACK, 0, false))));
            }
            return Math.round(Math.round(Math.ceil(HtmlRenderer.renderPlainString(string, graphics, 0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE, font, Color.BLACK, 0, false))));
        }
        return 0;
    }

    private Dimension calcPreferredSize(HtmlRendererImpl htmlRendererImpl) {
        Insets insets = htmlRendererImpl.getInsets();
        Dimension dimension = new Dimension(insets.left + insets.right, insets.top + insets.bottom);
        String string = htmlRendererImpl.getText();
        Graphics graphics = htmlRendererImpl.getGraphics();
        Icon icon = htmlRendererImpl.getIcon();
        if (string != null) {
            FontMetrics fontMetrics = graphics.getFontMetrics(htmlRendererImpl.getFont());
            dimension.height += fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent();
        }
        if (icon != null) {
            if (htmlRendererImpl.isCentered()) {
                dimension.height += icon.getIconHeight() + htmlRendererImpl.getIconTextGap();
                dimension.width += icon.getIconWidth();
            } else {
                dimension.height = Math.max(icon.getIconHeight() + insets.top + insets.bottom, dimension.height);
                dimension.width += icon.getIconWidth() + htmlRendererImpl.getIconTextGap();
            }
        }
        if (antialias) {
            ((Graphics2D)graphics).addRenderingHints(HtmlLabelUI.getHints());
        }
        int n = HtmlLabelUI.textWidth(string, graphics, htmlRendererImpl.getFont(), htmlRendererImpl.isHtml()) + 4;
        dimension.width = htmlRendererImpl.isCentered() ? Math.max(dimension.width, n + insets.right + insets.left) : (dimension.width += n + htmlRendererImpl.getIndent());
        if (FIXED_HEIGHT > 0) {
            dimension.height = FIXED_HEIGHT;
        }
        return dimension;
    }

    static final Map getHints() {
        if (hintsMap == null) {
            hintsMap = new HashMap();
            hintsMap.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            hintsMap.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            hintsMap.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        return hintsMap;
    }

    public void update(Graphics graphics, JComponent jComponent) {
        Color color = HtmlLabelUI.getBackgroundFor((HtmlRendererImpl)jComponent);
        if (color != null) {
            graphics.setColor(color);
            graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
        }
        if (((HtmlRendererImpl)jComponent).isLeadSelection()) {
            Color color2 = UIManager.getColor("textHighlight");
            if (color2 == null) {
                color2 = Color.BLUE;
            }
            graphics.setColor(color2);
            graphics.drawRect(0, 0, jComponent.getWidth() - 1, jComponent.getHeight() - 1);
        }
        this.paint(graphics, jComponent);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        HtmlRendererImpl htmlRendererImpl;
        if (antialias) {
            ((Graphics2D)graphics).addRenderingHints(HtmlLabelUI.getHints());
        }
        if ((htmlRendererImpl = (HtmlRendererImpl)jComponent).isCentered()) {
            this.paintIconAndTextCentered(graphics, htmlRendererImpl);
        } else {
            this.paintIconAndText(graphics, htmlRendererImpl);
        }
    }

    private void paintIconAndText(Graphics graphics, HtmlRendererImpl htmlRendererImpl) {
        int n;
        Font font = htmlRendererImpl.getFont();
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n2 = fontMetrics.getHeight();
        Insets insets = htmlRendererImpl.getInsets();
        int n3 = htmlRendererImpl.getHeight() - (insets.top + insets.bottom);
        int n4 = n3 >= n2 ? n2 + insets.top + (n3 / 2 - n2 / 2) - fontMetrics.getMaxDescent() : fontMetrics.getMaxAscent();
        int n5 = htmlRendererImpl.getIndent();
        Icon icon = htmlRendererImpl.getIcon();
        if (icon != null && icon.getIconWidth() > 0 && icon.getIconHeight() > 0) {
            int n6 = n3 > icon.getIconHeight() ? insets.top + (n3 / 2 - icon.getIconHeight() / 2) : (n3 == icon.getIconHeight() ? 0 : insets.top);
            n = insets.left + htmlRendererImpl.getIndent() + 1;
            try {
                icon.paintIcon(htmlRendererImpl, graphics, n, n6);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            n5 = n + icon.getIconWidth() + htmlRendererImpl.getIconTextGap();
        } else {
            n5 += insets.left;
        }
        String string = htmlRendererImpl.getText();
        if (string == null) {
            return;
        }
        n = icon != null ? htmlRendererImpl.getWidth() - (insets.left + insets.right + icon.getIconWidth() + htmlRendererImpl.getIconTextGap() + htmlRendererImpl.getIndent()) : htmlRendererImpl.getWidth() - (insets.left + insets.right + htmlRendererImpl.getIndent());
        Color color = HtmlLabelUI.getForegroundFor(htmlRendererImpl);
        if (htmlRendererImpl.isHtml()) {
            HtmlRenderer.renderHTML(string, graphics, n5, n4, n, n2, font, color, htmlRendererImpl.getRenderStyle(), true);
        } else {
            HtmlRenderer.renderString(string, graphics, n5, n4, n, n2, font, color, htmlRendererImpl.getRenderStyle(), true);
        }
    }

    private void paintIconAndTextCentered(Graphics graphics, HtmlRendererImpl htmlRendererImpl) {
        int n;
        int n2;
        Insets insets = htmlRendererImpl.getInsets();
        Icon icon = htmlRendererImpl.getIcon();
        int n3 = htmlRendererImpl.getWidth() - (insets.left + insets.right);
        int n4 = insets.left;
        int n5 = 0;
        if (icon != null && icon.getIconWidth() > 0 && icon.getIconHeight() > 0) {
            n2 = n3 > icon.getIconWidth() ? n3 / 2 - icon.getIconWidth() / 2 : n4;
            n = 0;
            icon.paintIcon(htmlRendererImpl, graphics, n2, n);
            n5 += icon.getIconHeight() + htmlRendererImpl.getIconTextGap();
        }
        n4 = (n2 = htmlRendererImpl.getPreferredSize().width) < htmlRendererImpl.getWidth() ? htmlRendererImpl.getWidth() / 2 - n2 / 2 : 0;
        n = htmlRendererImpl.getHeight() - n5;
        Font font = htmlRendererImpl.getFont();
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        n5 += fontMetrics.getMaxAscent();
        Color color = HtmlLabelUI.getForegroundFor(htmlRendererImpl);
        if (htmlRendererImpl.isHtml()) {
            HtmlRenderer.renderHTML(htmlRendererImpl.getText(), graphics, n4, n5, n2, n, font, color, htmlRendererImpl.getRenderStyle(), true);
        } else {
            HtmlRenderer.renderString(htmlRendererImpl.getText(), graphics, n4, n5, n2, n, htmlRendererImpl.getFont(), color, htmlRendererImpl.getRenderStyle(), true);
        }
    }

    static Color getBackgroundFor(HtmlRendererImpl htmlRendererImpl) {
        if (htmlRendererImpl.isOpaque()) {
            return htmlRendererImpl.getBackground();
        }
        if (htmlRendererImpl.isSelected() && !htmlRendererImpl.isParentFocused() && !HtmlLabelUI.isGTK()) {
            return HtmlLabelUI.getUnfocusedSelectionBackground();
        }
        if (HtmlLabelUI.isGTK()) {
            return null;
        }
        Color color = null;
        if (htmlRendererImpl.isSelected()) {
            switch (htmlRendererImpl.getType()) {
                case 1: {
                    color = UIManager.getColor("List.selectionBackground");
                    break;
                }
                case 2: {
                    color = UIManager.getColor("Table.selectionBackground");
                    break;
                }
                case 0: {
                    return UIManager.getColor("Tree.selectionBackground");
                }
            }
            return color == null ? htmlRendererImpl.getBackground() : color;
        }
        return null;
    }

    static Color getForegroundFor(HtmlRendererImpl htmlRendererImpl) {
        if (htmlRendererImpl.isSelected() && !htmlRendererImpl.isParentFocused()) {
            return HtmlLabelUI.getUnfocusedSelectionForeground();
        }
        if (!htmlRendererImpl.isEnabled()) {
            return UIManager.getColor("textInactiveText");
        }
        Color color = null;
        if (htmlRendererImpl.isSelected()) {
            switch (htmlRendererImpl.getType()) {
                case 1: {
                    color = UIManager.getColor("List.selectionForeground");
                }
                case 2: {
                    color = UIManager.getColor("Table.selectionForeground");
                }
                case 0: {
                    color = UIManager.getColor("Tree.selectionForeground");
                }
            }
        }
        return color == null ? htmlRendererImpl.getForeground() : color;
    }

    private static boolean isGTK() {
        return "GTK".equals(UIManager.getLookAndFeel().getID());
    }

    private static Color getUnfocusedSelectionBackground() {
        if (unfocusedSelBg == null && (unfocusedSelBg = UIManager.getColor("nb.explorer.unfocusedSelBg")) == null) {
            unfocusedSelBg = UIManager.getColor("controlShadow");
            if (unfocusedSelBg == null) {
                unfocusedSelBg = Color.lightGray;
            }
            unfocusedSelBg = unfocusedSelBg.brighter();
        }
        return unfocusedSelBg;
    }

    private static Color getUnfocusedSelectionForeground() {
        if (unfocusedSelFg == null && (unfocusedSelFg = UIManager.getColor("nb.explorer.unfocusedSelFg")) == null && (unfocusedSelFg = UIManager.getColor("textText")) == null) {
            unfocusedSelFg = Color.BLACK;
        }
        return unfocusedSelFg;
    }

    public static final boolean gtkShouldAntialias() {
        if (gtkAA == null) {
            Object object = Toolkit.getDefaultToolkit().getDesktopProperty("gnome.Xft/Antialias");
            gtkAA = new Integer(1).equals(object) ? Boolean.TRUE : Boolean.FALSE;
        }
        return gtkAA;
    }

    static {
        String string = System.getProperty("nb.cellrenderer.fixedheight");
        if (string != null) {
            try {
                FIXED_HEIGHT = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        hintsMap = null;
        unfocusedSelBg = null;
        unfocusedSelFg = null;
        gtkAA = null;
    }
}

