/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.plaf.AbstractViewTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.BaseTabLayoutModel;
import org.netbeans.swing.tabcontrol.plaf.ColorUtil;
import org.netbeans.swing.tabcontrol.plaf.TabLayoutModel;
import org.openide.awt.HtmlRenderer;

public final class WinXPViewTabDisplayerUI
extends AbstractViewTabDisplayerUI {
    private static boolean colorsReady = false;
    private static Color unselFillBrightC;
    private static Color unselFillDarkC;
    private static Color selFillC;
    private static Color focusFillBrightC;
    private static Color focusFillDarkC;
    private static Color txtC;
    private static Color borderC;
    private static Color bottomBorderC;
    private static Color selBorderC;
    private static Color bgFillC;
    private static AbstractViewTabDisplayerUI.IconLoader closeIcon;
    private Dimension prefSize;
    private Rectangle tempRect = new Rectangle();

    private WinXPViewTabDisplayerUI(TabDisplayer tabDisplayer) {
        super(tabDisplayer);
        this.prefSize = new Dimension(Integer.MAX_VALUE, 17);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new WinXPViewTabDisplayerUI((TabDisplayer)jComponent);
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        WinXPViewTabDisplayerUI.initColors();
        jComponent.setBackground(UIManager.getColor("nb_workplace_fill"));
        jComponent.setOpaque(true);
    }

    protected AbstractViewTabDisplayerUI.Controller createController() {
        return new OwnController();
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        FontMetrics fontMetrics = this.getTxtFontMetrics();
        int n = fontMetrics == null ? 17 : fontMetrics.getAscent() + 2 * fontMetrics.getDescent() + 3;
        Insets insets = jComponent.getInsets();
        this.prefSize.height = n + insets.bottom + insets.top;
        return this.prefSize;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        super.paint(graphics, jComponent);
    }

    protected void paintTabContent(Graphics graphics, int n, String string, int n2, int n3, int n4, int n5) {
        FontMetrics fontMetrics = this.getTxtFontMetrics();
        String string2 = null;
        graphics.setFont(this.getTxtFont());
        if (!this.isTabInFront(n) && this.isMoreThanOne()) {
            ++n3;
            --n5;
        }
        if (this.isSelected(n)) {
            if (closeIcon == null) {
                closeIcon = new AbstractViewTabDisplayerUI.IconLoader();
            }
            String string3 = this.findIconPath(n);
            Icon icon = closeIcon.obtainIcon(string3);
            int n6 = icon.getIconWidth();
            AbstractViewTabDisplayerUI.PinButton pinButton = this.getPinButton(n);
            int n7 = pinButton != null ? pinButton.getWidth() + 1 : 0;
            int n8 = n6 + 4 + n7;
            string2 = WinXPViewTabDisplayerUI.stripTextToFit(string, n4 - 16 - n8, fontMetrics);
            int n9 = BaseTabLayoutModel.textWidth(string2, this.getTxtFont());
            this.getCloseIconRect(this.tempRect, n);
            if (pinButton != null) {
                pinButton.setLocation(this.tempRect.x - n7, this.tempRect.y);
            }
            icon.paintIcon(this.getDisplayer(), graphics, this.tempRect.x, this.tempRect.y);
        } else {
            string2 = WinXPViewTabDisplayerUI.stripTextToFit(string, n4 - 16, fontMetrics);
        }
        ColorUtil.paintXpTabDragTexture(this.getDisplayer(), graphics, n2 + 3, n3 + 5, n5 - 8);
        HtmlRenderer.renderString(string2, graphics, n2 + 8, n3 + fontMetrics.getAscent() + 3, n4, n5, this.getTxtFont(), txtC, 0, true);
    }

    protected void paintTabBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        boolean bl = n == 0;
        boolean bl2 = this.isTabHighlighted(n);
        graphics.translate(n2, n3);
        ColorUtil.paintXpTabHeader(bl2 ? 1 : 0, graphics, 0, 0, n4);
        Color color = bl2 ? selBorderC : borderC;
        graphics.setColor(color);
        if (bl) {
            graphics.drawLine(0, 3, 0, n5 - 2);
        }
        graphics.drawLine(n4 - 1, 3, n4 - 1, n5 - 2);
        graphics.setColor(bottomBorderC);
        graphics.drawLine(0, n5 - 1, n4 - 1, n5 - 1);
        graphics.translate(-n2, -n3);
    }

    protected void paintTabBackground(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        boolean bl;
        n3 += 3;
        --n4;
        n5 -= 4;
        boolean bl2 = this.isSelected(n);
        boolean bl3 = bl = bl2 && this.isActive();
        if (bl) {
            ColorUtil.xpFillRectGradient((Graphics2D)graphics, n2, n3, n4, n5, focusFillBrightC, focusFillDarkC);
        } else if (bl2 && this.isMoreThanOne()) {
            graphics.setColor(selFillC);
            graphics.fillRect(n2, n3, n4, n5);
        } else {
            ColorUtil.xpFillRectGradient((Graphics2D)graphics, n2, n3, n4, n5, unselFillBrightC, unselFillDarkC);
        }
    }

    protected Font getTxtFont() {
        Font font = super.getTxtFont();
        if (!font.isBold()) {
            font = font.deriveFont(1);
        }
        return font;
    }

    private String findIconPath(int n) {
        if (this.isFocused(n)) {
            if (((OwnController)this.getController()).isClosePressed() == n) {
                return "org/netbeans/swing/tabcontrol/resources/xp-close-focus-pressed.gif";
            }
            if (((OwnController)this.getController()).isMouseInCloseButton() == n) {
                return "org/netbeans/swing/tabcontrol/resources/xp-close-focus-rollover.gif";
            }
            return "org/netbeans/swing/tabcontrol/resources/xp-close-focus-normal.gif";
        }
        if (this.isSelected(n)) {
            if (((OwnController)this.getController()).isClosePressed() == n) {
                return "org/netbeans/swing/tabcontrol/resources/xp-close-sel-pressed.gif";
            }
            if (((OwnController)this.getController()).isMouseInCloseButton() == n) {
                return "org/netbeans/swing/tabcontrol/resources/xp-close-sel-rollover.gif";
            }
            return "org/netbeans/swing/tabcontrol/resources/xp-close-sel-normal.gif";
        }
        if (((OwnController)this.getController()).isClosePressed() == n) {
            return "org/netbeans/swing/tabcontrol/resources/xp-close-unsel-pressed.gif";
        }
        if (((OwnController)this.getController()).isMouseInCloseButton() == n) {
            return "org/netbeans/swing/tabcontrol/resources/xp-close-unsel-rollover.gif";
        }
        return "org/netbeans/swing/tabcontrol/resources/xp-close-unsel-normal.gif";
    }

    private boolean isTabHighlighted(int n) {
        if (((OwnController)this.getController()).getMouseIndex() == n) {
            return true;
        }
        return this.isTabInFront(n) && this.isMoreThanOne();
    }

    private boolean isTabInFront(int n) {
        return this.isSelected(n) && (this.isActive() || this.isMoreThanOne());
    }

    private boolean isMoreThanOne() {
        return this.getDataModel().size() > 1;
    }

    private static void initColors() {
        if (!colorsReady) {
            txtC = UIManager.getColor("TabbedPane.foreground");
            selFillC = UIManager.getColor("TabbedPane.highlight");
            focusFillBrightC = UIManager.getColor("tab_focus_fill_bright");
            focusFillDarkC = UIManager.getColor("tab_focus_fill_dark");
            unselFillBrightC = UIManager.getColor("tab_unsel_fill_bright");
            unselFillDarkC = UIManager.getColor("tab_unsel_fill_dark");
            borderC = UIManager.getColor("tab_border");
            bottomBorderC = UIManager.getColor("tab_bottom_border");
            selBorderC = UIManager.getColor("tab_sel_border");
            bgFillC = UIManager.getColor("workplace_fill");
            colorsReady = true;
        }
    }

    private Rectangle getCloseIconRect(Rectangle rectangle, int n) {
        TabLayoutModel tabLayoutModel = this.getLayoutModel();
        int n2 = tabLayoutModel.getX(n);
        int n3 = tabLayoutModel.getY(n);
        int n4 = tabLayoutModel.getW(n);
        int n5 = tabLayoutModel.getH(n);
        String string = this.findIconPath(n);
        if (closeIcon == null) {
            closeIcon = new AbstractViewTabDisplayerUI.IconLoader();
        }
        Icon icon = closeIcon.obtainIcon(string);
        int n6 = icon.getIconWidth();
        int n7 = icon.getIconHeight();
        rectangle.x = n2 + n4 - n6 - 4;
        rectangle.y = this.getCenteredIconY(icon, n);
        rectangle.width = n6;
        rectangle.height = n7;
        return rectangle;
    }

    protected AbstractViewTabDisplayerUI.PinButton createPinButton() {
        HashMap<Object, String> hashMap = new HashMap<Object, String>(6);
        hashMap.put(TabDisplayer.ORIENTATION_EAST, "org/netbeans/swing/tabcontrol/resources/xp-pin-select-normal-east.gif");
        hashMap.put(TabDisplayer.ORIENTATION_WEST, "org/netbeans/swing/tabcontrol/resources/xp-pin-select-normal-west.gif");
        hashMap.put(TabDisplayer.ORIENTATION_SOUTH, "org/netbeans/swing/tabcontrol/resources/xp-pin-select-normal-south.gif");
        hashMap.put(TabDisplayer.ORIENTATION_CENTER, "org/netbeans/swing/tabcontrol/resources/xp-pin-select-normal-center.gif");
        HashMap<Object, String> hashMap2 = new HashMap<Object, String>(6);
        hashMap2.put(TabDisplayer.ORIENTATION_EAST, "org/netbeans/swing/tabcontrol/resources/xp-pin-select-pressed-east.gif");
        hashMap2.put(TabDisplayer.ORIENTATION_WEST, "org/netbeans/swing/tabcontrol/resources/xp-pin-select-pressed-west.gif");
        hashMap2.put(TabDisplayer.ORIENTATION_SOUTH, "org/netbeans/swing/tabcontrol/resources/xp-pin-select-pressed-south.gif");
        hashMap2.put(TabDisplayer.ORIENTATION_CENTER, "org/netbeans/swing/tabcontrol/resources/xp-pin-select-pressed-center.gif");
        HashMap<Object, String> hashMap3 = new HashMap<Object, String>(6);
        hashMap3.put(TabDisplayer.ORIENTATION_EAST, "org/netbeans/swing/tabcontrol/resources/xp-pin-select-rollover-east.gif");
        hashMap3.put(TabDisplayer.ORIENTATION_WEST, "org/netbeans/swing/tabcontrol/resources/xp-pin-select-rollover-west.gif");
        hashMap3.put(TabDisplayer.ORIENTATION_SOUTH, "org/netbeans/swing/tabcontrol/resources/xp-pin-select-rollover-south.gif");
        hashMap3.put(TabDisplayer.ORIENTATION_CENTER, "org/netbeans/swing/tabcontrol/resources/xp-pin-select-rollover-center.gif");
        HashMap<Object, String> hashMap4 = new HashMap<Object, String>(6);
        hashMap4.put(TabDisplayer.ORIENTATION_EAST, "org/netbeans/swing/tabcontrol/resources/xp-pin-focused-normal-east.gif");
        hashMap4.put(TabDisplayer.ORIENTATION_WEST, "org/netbeans/swing/tabcontrol/resources/xp-pin-focused-normal-west.gif");
        hashMap4.put(TabDisplayer.ORIENTATION_SOUTH, "org/netbeans/swing/tabcontrol/resources/xp-pin-focused-normal-south.gif");
        hashMap4.put(TabDisplayer.ORIENTATION_CENTER, "org/netbeans/swing/tabcontrol/resources/xp-pin-focused-normal-center.gif");
        HashMap<Object, String> hashMap5 = new HashMap<Object, String>(6);
        hashMap5.put(TabDisplayer.ORIENTATION_EAST, "org/netbeans/swing/tabcontrol/resources/xp-pin-focused-pressed-east.gif");
        hashMap5.put(TabDisplayer.ORIENTATION_WEST, "org/netbeans/swing/tabcontrol/resources/xp-pin-focused-pressed-west.gif");
        hashMap5.put(TabDisplayer.ORIENTATION_SOUTH, "org/netbeans/swing/tabcontrol/resources/xp-pin-focused-pressed-south.gif");
        hashMap5.put(TabDisplayer.ORIENTATION_CENTER, "org/netbeans/swing/tabcontrol/resources/xp-pin-focused-pressed-center.gif");
        HashMap<Object, String> hashMap6 = new HashMap<Object, String>(6);
        hashMap6.put(TabDisplayer.ORIENTATION_EAST, "org/netbeans/swing/tabcontrol/resources/xp-pin-focused-rollover-east.gif");
        hashMap6.put(TabDisplayer.ORIENTATION_WEST, "org/netbeans/swing/tabcontrol/resources/xp-pin-focused-rollover-west.gif");
        hashMap6.put(TabDisplayer.ORIENTATION_SOUTH, "org/netbeans/swing/tabcontrol/resources/xp-pin-focused-rollover-south.gif");
        hashMap6.put(TabDisplayer.ORIENTATION_CENTER, "org/netbeans/swing/tabcontrol/resources/xp-pin-focused-rollover-center.gif");
        return new XPPinButton(this.displayer, hashMap4, hashMap5, hashMap6, hashMap, hashMap2, hashMap3);
    }

    protected static class XPPinButton
    extends AbstractViewTabDisplayerUI.PinButton {
        private Map focusedNormal;
        private Map focusedRollover;
        private Map focusedPressed;
        private TabDisplayer displayer;

        protected XPPinButton(TabDisplayer tabDisplayer, Map map, Map map2, Map map3, Map map4, Map map5, Map map6) {
            super(map4, map5, map6);
            this.focusedPressed = map2;
            this.focusedRollover = map3;
            this.focusedNormal = map;
            this.displayer = tabDisplayer;
        }

        public Icon getIcon() {
            if (this.displayer.isActive()) {
                return AbstractViewTabDisplayerUI.iconCache.obtainIcon((String)this.focusedNormal.get(this.getOrientation()));
            }
            return super.getIcon();
        }

        public Icon getRolloverIcon() {
            if (this.displayer.isActive()) {
                return AbstractViewTabDisplayerUI.iconCache.obtainIcon((String)this.focusedRollover.get(this.getOrientation()));
            }
            return super.getRolloverIcon();
        }

        public Icon getPressedIcon() {
            if (this.displayer.isActive()) {
                return AbstractViewTabDisplayerUI.iconCache.obtainIcon((String)this.focusedPressed.get(this.getOrientation()));
            }
            return super.getPressedIcon();
        }
    }

    private class OwnController
    extends AbstractViewTabDisplayerUI.Controller {
        private int lastIndex = -1;

        private OwnController() {
        }

        public int getMouseIndex() {
            return this.lastIndex;
        }

        protected int inCloseIconRect(Point point) {
            int n = WinXPViewTabDisplayerUI.this.getLayoutModel().indexOfPoint(point.x, point.y);
            if (n < 0) {
                return -1;
            }
            return WinXPViewTabDisplayerUI.this.getCloseIconRect(WinXPViewTabDisplayerUI.this.tempRect, n).contains(point) ? n : -1;
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            super.mouseMoved(mouseEvent);
            Point point = mouseEvent.getPoint();
            this.updateHighlight(WinXPViewTabDisplayerUI.this.getLayoutModel().indexOfPoint(point.x, point.y));
        }

        public void mouseExited(MouseEvent mouseEvent) {
            super.mouseExited(mouseEvent);
            this.updateHighlight(-1);
        }

        private void updateHighlight(int n) {
            int n2;
            int n3;
            int n4;
            int n5;
            if (n == this.lastIndex) {
                return;
            }
            TabLayoutModel tabLayoutModel = WinXPViewTabDisplayerUI.this.getLayoutModel();
            Rectangle rectangle = null;
            if (n != -1) {
                n5 = tabLayoutModel.getX(n);
                n4 = tabLayoutModel.getY(n);
                n3 = tabLayoutModel.getW(n);
                n2 = tabLayoutModel.getH(n);
                rectangle = new Rectangle(n5, n4, n3, n2);
            }
            if (this.lastIndex != -1 && this.lastIndex < WinXPViewTabDisplayerUI.this.getDataModel().size()) {
                n5 = tabLayoutModel.getX(this.lastIndex);
                n4 = tabLayoutModel.getY(this.lastIndex);
                n3 = tabLayoutModel.getW(this.lastIndex);
                n2 = tabLayoutModel.getH(this.lastIndex);
                rectangle = rectangle != null ? rectangle.union(new Rectangle(n5, n4, n3, n2)) : new Rectangle(n5, n4, n3, n2);
            }
            if (rectangle != null) {
                WinXPViewTabDisplayerUI.this.getDisplayer().repaint(rectangle);
            }
            this.lastIndex = n;
        }
    }
}

