/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.AlphaComposite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SingleSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.swing.tabcontrol.LocationInformer;
import org.netbeans.swing.tabcontrol.TabData;
import org.netbeans.swing.tabcontrol.TabDataModel;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.TabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.DefaultTabSelectionModel;
import org.netbeans.swing.tabcontrol.plaf.EqualPolygon;
import org.netbeans.swing.tabcontrol.plaf.TabLayoutModel;
import org.netbeans.swing.tabcontrol.plaf.ViewTabLayoutModel;

public abstract class AbstractViewTabDisplayerUI
extends TabDisplayerUI {
    private TabDataModel dataModel;
    private ViewTabLayoutModel layoutModel;
    private FontMetrics fm;
    private Font txtFont;
    protected Controller controller;
    protected static IconLoader iconCache = new IconLoader();
    protected PinButton pinButton;
    private final Action pinAction = new PinAction();

    public AbstractViewTabDisplayerUI(TabDisplayer tabDisplayer) {
        super(tabDisplayer);
        tabDisplayer.setLayout(null);
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.controller = this.createController();
        this.dataModel = this.displayer.getModel();
        this.layoutModel = new ViewTabLayoutModel(this.dataModel, this.displayer);
        this.dataModel.addChangeListener(this.controller);
        this.displayer.addPropertyChangeListener(this.controller);
        this.selectionModel.addChangeListener(this.controller);
        this.displayer.addMouseListener(this.controller);
        this.displayer.addMouseMotionListener(this.controller);
        LocationInformer locationInformer = this.displayer.getLocationInformer();
        if (locationInformer != null) {
            this.pinButton = this.createPinButton();
        }
        this.installPinButton();
    }

    protected void installPinButton() {
        if (this.pinButton != null) {
            this.displayer.add(this.pinButton);
            this.pinButton.addActionListener(this.controller);
        }
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        this.displayer.removePropertyChangeListener(this.controller);
        this.dataModel.removeChangeListener(this.controller);
        this.selectionModel.removeChangeListener(this.controller);
        this.displayer.removeMouseListener(this.controller);
        this.displayer.removeMouseMotionListener(this.controller);
        if (this.pinButton != null) {
            this.displayer.remove(this.pinButton);
            this.pinButton.removeActionListener(this.controller);
            this.pinButton = null;
        }
        this.layoutModel = null;
        this.selectionModel = null;
        this.dataModel = null;
        this.controller = null;
    }

    protected abstract Controller createController();

    public void paint(Graphics graphics, JComponent jComponent) {
        for (int i = 0; i < this.dataModel.size(); ++i) {
            TabData tabData = this.dataModel.getTab(i);
            int n = this.layoutModel.getX(i);
            int n2 = this.layoutModel.getY(i);
            int n3 = this.layoutModel.getW(i);
            int n4 = this.layoutModel.getH(i);
            String string = tabData.getText();
            if (!graphics.hitClip(n, n2, n3, n4)) continue;
            this.paintTabBackground(graphics, i, n, n2, n3, n4);
            this.paintTabContent(graphics, i, string, n, n2, n3, n4);
            this.paintTabBorder(graphics, i, n, n2, n3, n4);
        }
    }

    protected final TabDataModel getDataModel() {
        return this.dataModel;
    }

    public final TabLayoutModel getLayoutModel() {
        return this.layoutModel;
    }

    protected final TabDisplayer getDisplayer() {
        return this.displayer;
    }

    protected final SingleSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public Controller getController() {
        return this.controller;
    }

    protected final boolean isSelected(int n) {
        return this.selectionModel.getSelectedIndex() == n;
    }

    protected final boolean isActive() {
        return this.displayer.isActive();
    }

    protected final boolean isFocused(int n) {
        return this.isSelected(n) && this.isActive();
    }

    protected final SingleSelectionModel createSelectionModel() {
        return new DefaultTabSelectionModel(this.displayer.getModel());
    }

    public String getCommandAtPoint(Point point) {
        return this.controller.inCloseIconRect(point) != -1 ? "close" : "select";
    }

    public int dropIndexOfPoint(Point point) {
        int n = 0;
        for (int i = 0; i < this.displayer.getModel().size(); ++i) {
            int n2 = this.getLayoutModel().getX(i);
            int n3 = this.getLayoutModel().getW(i);
            if (point.x < n2 || point.x > n2 + n3) continue;
            if (i == this.displayer.getModel().size() - 1) {
                if (point.x > n2 + n3 / 2) {
                    n = this.displayer.getModel().size();
                    break;
                }
                n = i;
                break;
            }
            n = i;
            break;
        }
        return n;
    }

    protected Font getTxtFont() {
        if (this.txtFont == null) {
            this.txtFont = (Font)UIManager.get("windowTitleFont");
            if (this.txtFont == null) {
                this.txtFont = new Font("Dialog", 0, 11);
            } else if (this.txtFont.isBold()) {
                this.txtFont = this.txtFont.deriveFont(0);
            }
        }
        return this.txtFont;
    }

    protected final FontMetrics getTxtFontMetrics() {
        if (this.fm == null) {
            TabDisplayer tabDisplayer = this.getDisplayer();
            this.fm = tabDisplayer.getFontMetrics(this.getTxtFont());
        }
        return this.fm;
    }

    protected abstract void paintTabContent(Graphics var1, int var2, String var3, int var4, int var5, int var6, int var7);

    protected abstract void paintTabBorder(Graphics var1, int var2, int var3, int var4, int var5, int var6);

    protected abstract void paintTabBackground(Graphics var1, int var2, int var3, int var4, int var5, int var6);

    protected static final String stripTextToFit(String string, int n, FontMetrics fontMetrics) {
        int n2 = fontMetrics.charWidth('.');
        int n3 = n2;
        if (n < n3) {
            return "";
        }
        if (n < (n3 += n2)) {
            return ".";
        }
        if (n < (n3 += n2)) {
            return "..";
        }
        for (int i = 0; i < string.length(); ++i) {
            if (n >= (n3 += fontMetrics.charWidth(string.charAt(i)))) continue;
            if (i == 0) {
                return "...";
            }
            StringBuffer stringBuffer = new StringBuffer(string.substring(0, i));
            stringBuffer.append("...");
            return stringBuffer.toString();
        }
        return string;
    }

    protected final int getCenteredIconY(Icon icon, int n) {
        TabLayoutModel tabLayoutModel = this.getLayoutModel();
        int n2 = tabLayoutModel.getY(n);
        int n3 = tabLayoutModel.getH(n);
        int n4 = icon.getIconHeight();
        return n2 + Math.max(0, n3 / 2 - n4 / 2);
    }

    protected final PinButton getPinButton(int n) {
        if (this.pinButton == null) {
            return null;
        }
        LocationInformer locationInformer = this.getDisplayer().getLocationInformer();
        if (locationInformer == null) {
            return null;
        }
        Object object = locationInformer.getOrientation(this.getDisplayer().getModel().getTab(n).getComponent());
        this.pinButton.setOrientation(object);
        return this.pinButton;
    }

    protected PinButton createPinButton() {
        HashMap<Object, String> hashMap = new HashMap<Object, String>(6);
        hashMap.put(TabDisplayer.ORIENTATION_EAST, "org/netbeans/swing/tabcontrol/resources/win-pin-normal-east.gif");
        hashMap.put(TabDisplayer.ORIENTATION_WEST, "org/netbeans/swing/tabcontrol/resources/win-pin-normal-west.gif");
        hashMap.put(TabDisplayer.ORIENTATION_SOUTH, "org/netbeans/swing/tabcontrol/resources/win-pin-normal-south.gif");
        hashMap.put(TabDisplayer.ORIENTATION_CENTER, "org/netbeans/swing/tabcontrol/resources/win-pin-normal-center.gif");
        HashMap<Object, String> hashMap2 = new HashMap<Object, String>(6);
        hashMap2.put(TabDisplayer.ORIENTATION_EAST, "org/netbeans/swing/tabcontrol/resources/win-pin-pressed-east.gif");
        hashMap2.put(TabDisplayer.ORIENTATION_WEST, "org/netbeans/swing/tabcontrol/resources/win-pin-pressed-west.gif");
        hashMap2.put(TabDisplayer.ORIENTATION_SOUTH, "org/netbeans/swing/tabcontrol/resources/win-pin-pressed-south.gif");
        hashMap2.put(TabDisplayer.ORIENTATION_CENTER, "org/netbeans/swing/tabcontrol/resources/win-pin-pressed-center.gif");
        HashMap<Object, String> hashMap3 = new HashMap<Object, String>(6);
        hashMap3.put(TabDisplayer.ORIENTATION_EAST, "org/netbeans/swing/tabcontrol/resources/win-pin-rollover-east.gif");
        hashMap3.put(TabDisplayer.ORIENTATION_WEST, "org/netbeans/swing/tabcontrol/resources/win-pin-rollover-west.gif");
        hashMap3.put(TabDisplayer.ORIENTATION_SOUTH, "org/netbeans/swing/tabcontrol/resources/win-pin-rollover-south.gif");
        hashMap3.put(TabDisplayer.ORIENTATION_CENTER, "org/netbeans/swing/tabcontrol/resources/win-pin-rollover-center.gif");
        return new PinButton(hashMap, hashMap2, hashMap3);
    }

    protected void performPinAction() {
        int n = this.getSelectionModel().getSelectedIndex();
        PinButton pinButton = this.getPinButton(n);
        if (pinButton != null) {
            if (TabDisplayer.ORIENTATION_CENTER.equals(pinButton.getOrientation())) {
                this.shouldPerformAction("disableAutoHide", n, null);
            } else {
                this.shouldPerformAction("enableAutoHide", n, null);
            }
        }
    }

    public void unregisterShortcuts(JComponent jComponent) {
        jComponent.getInputMap(1).remove(KeyStroke.getKeyStroke(8, 128));
        jComponent.getActionMap().remove("pinAction");
    }

    public void registerShortcuts(JComponent jComponent) {
        jComponent.getInputMap(1).put(KeyStroke.getKeyStroke(8, 128), "pinAction");
        jComponent.getActionMap().put("pinAction", this.pinAction);
    }

    public Polygon getExactTabIndication(int n) {
        TabDisplayer tabDisplayer = this.getDisplayer();
        int n2 = tabDisplayer.getHeight();
        TabLayoutModel tabLayoutModel = this.getLayoutModel();
        int n3 = tabLayoutModel.getX(n);
        int n4 = n3 + tabLayoutModel.getW(n);
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        nArray[0] = n3;
        nArray2[0] = 0;
        nArray[1] = n4;
        nArray2[1] = 0;
        nArray[2] = n4;
        nArray2[2] = n2 - 1;
        nArray[3] = n3;
        nArray2[3] = n2 - 1;
        return new EqualPolygon(nArray, nArray2);
    }

    public Polygon getInsertTabIndication(int n) {
        int n2;
        int n3;
        EqualPolygon equalPolygon = new EqualPolygon();
        TabDisplayer tabDisplayer = this.getDisplayer();
        int n4 = tabDisplayer.getHeight();
        int n5 = tabDisplayer.getWidth();
        TabLayoutModel tabLayoutModel = this.getLayoutModel();
        if (n == 0) {
            n3 = 0;
            n2 = tabLayoutModel.getW(0) / 2;
        } else if (n >= this.getDataModel().size()) {
            n3 = tabLayoutModel.getX(n - 1) + tabLayoutModel.getW(n - 1) / 2;
            n2 = n3 + tabLayoutModel.getW(n - 1);
            if (n2 > n5) {
                n2 = n5;
            }
        } else {
            n3 = tabLayoutModel.getX(n - 1) + tabLayoutModel.getW(n - 1) / 2;
            n2 = tabLayoutModel.getX(n) + tabLayoutModel.getW(n) / 2;
        }
        equalPolygon.moveTo(n3, 0);
        equalPolygon.lineTo(n2, 0);
        equalPolygon.lineTo(n2, n4 - 1);
        equalPolygon.lineTo(n3, n4 - 1);
        return equalPolygon;
    }

    private static Image loadImage(String string) {
        try {
            URL uRL = AbstractViewTabDisplayerUI.class.getResource("/" + string);
            return ImageIO.read(uRL);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public Image createImageOfTab(int n) {
        Rectangle rectangle = new Rectangle();
        this.getTabRect(n, rectangle);
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(rectangle.width, rectangle.height);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.5f);
        graphics2D.setComposite(alphaComposite);
        graphics2D.translate(-rectangle.x, -rectangle.y);
        this.displayer.paint(graphics2D);
        return bufferedImage;
    }

    public Rectangle getTabRect(int n, Rectangle rectangle) {
        if (n < 0 || n > this.displayer.getModel().size()) {
            throw new ArrayIndexOutOfBoundsException("Tab index out of bounds: " + n);
        }
        rectangle.x = this.layoutModel.getX(n);
        rectangle.width = this.layoutModel.getW(n);
        rectangle.height = this.layoutModel.getH(n);
        rectangle.y = Math.min(0, this.displayer.getHeight() - rectangle.height);
        return rectangle;
    }

    public int tabForCoordinate(Point point) {
        int n = this.displayer.getModel().size();
        if (n == 0 || point.y > this.displayer.getHeight() || point.y < 0 || point.x < 0 || point.x > this.displayer.getWidth()) {
            return -1;
        }
        for (int i = 0; i < n; ++i) {
            int n2 = this.layoutModel.getX(i);
            int n3 = n2 + this.layoutModel.getW(i);
            if (point.x <= n2 || point.x >= n3) continue;
            return i;
        }
        return -1;
    }

    private final class PinAction
    extends AbstractAction {
        private PinAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AbstractViewTabDisplayerUI.this.performPinAction();
        }
    }

    protected static class PinButton
    extends JButton {
        private Map pressedIcons;
        private Map rolloverIcons;
        private Map regularIcons;
        private Object orientation;

        public PinButton(Map map, Map map2, Map map3) {
            this.regularIcons = map;
            this.pressedIcons = map2;
            this.rolloverIcons = map3;
            this.setFocusable(false);
            this.setBorder(null);
            this.setContentAreaFilled(false);
            this.setRolloverEnabled(map3 != null);
            this.setOrientation(TabDisplayer.ORIENTATION_CENTER);
        }

        public Object getOrientation() {
            return this.orientation;
        }

        public void setOrientation(Object object) {
            this.orientation = object;
            Icon icon = iconCache.obtainIcon((String)this.regularIcons.get(object));
            this.setIcon(icon);
            this.setSize(icon.getIconWidth(), icon.getIconHeight());
            if (this.pressedIcons != null) {
                this.setPressedIcon(iconCache.obtainIcon((String)this.regularIcons.get(object)));
            }
            if (this.rolloverIcons != null) {
                this.setRolloverIcon(iconCache.obtainIcon((String)this.rolloverIcons.get(object)));
            }
        }
    }

    abstract class Controller
    extends MouseAdapter
    implements MouseMotionListener,
    ChangeListener,
    PropertyChangeListener,
    ActionListener {
        private int closePressed = -1;
        private int mouseInCloseButton = -1;
        private boolean selectionChanged;

        Controller() {
        }

        protected abstract int inCloseIconRect(Point var1);

        protected boolean shouldReact(MouseEvent mouseEvent) {
            boolean bl = SwingUtilities.isLeftMouseButton(mouseEvent);
            return bl;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            AbstractViewTabDisplayerUI.this.displayer.repaint();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("active".equals(propertyChangeEvent.getPropertyName())) {
                AbstractViewTabDisplayerUI.this.displayer.repaint();
            }
        }

        protected void performAction(MouseEvent mouseEvent) {
            if (AbstractViewTabDisplayerUI.this.shouldPerformAction("close", this.mouseInCloseButton, mouseEvent)) {
                AbstractViewTabDisplayerUI.this.getDataModel().removeTab(this.mouseInCloseButton);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            SingleSelectionModel singleSelectionModel;
            Point point = mouseEvent.getPoint();
            int n = AbstractViewTabDisplayerUI.this.getLayoutModel().indexOfPoint(point.x, point.y);
            boolean bl = this.selectionChanged = n != (singleSelectionModel = AbstractViewTabDisplayerUI.this.getSelectionModel()).getSelectedIndex();
            if (n != -1 || !this.selectionChanged) {
                AbstractViewTabDisplayerUI.this.getSelectionModel().setSelectedIndex(n);
            }
            if (this.shouldReact(mouseEvent) && !this.selectionChanged) {
                this.setClosePressed(this.inCloseIconRect(mouseEvent.getPoint()));
            }
            if (n != -1 && mouseEvent.isPopupTrigger()) {
                AbstractViewTabDisplayerUI.this.shouldPerformAction("popup", n, mouseEvent);
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() >= 2 && !mouseEvent.isPopupTrigger()) {
                SingleSelectionModel singleSelectionModel;
                Point point = mouseEvent.getPoint();
                int n = AbstractViewTabDisplayerUI.this.getLayoutModel().indexOfPoint(point.x, point.y);
                boolean bl = this.selectionChanged = n != (singleSelectionModel = AbstractViewTabDisplayerUI.this.getSelectionModel()).getSelectedIndex();
                if (n != -1 || !this.selectionChanged) {
                    AbstractViewTabDisplayerUI.this.getSelectionModel().setSelectedIndex(n);
                }
                if (n != -1) {
                    AbstractViewTabDisplayerUI.this.shouldPerformAction("maximize", n, mouseEvent);
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            Point point;
            if (this.shouldReact(mouseEvent) && !this.selectionChanged) {
                this.setClosePressed(-1);
                point = mouseEvent.getPoint();
                this.mouseInCloseButton = this.inCloseIconRect(point);
                if (this.mouseInCloseButton >= 0) {
                    this.performAction(mouseEvent);
                    this.setMouseInCloseButton(point);
                }
            }
            point = mouseEvent.getPoint();
            int n = AbstractViewTabDisplayerUI.this.getLayoutModel().indexOfPoint(point.x, point.y);
            if (n != -1 && mouseEvent.isPopupTrigger()) {
                AbstractViewTabDisplayerUI.this.shouldPerformAction("popup", n, mouseEvent);
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            this.setMouseInCloseButton(mouseEvent.getPoint());
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            this.setClosePressed(this.inCloseIconRect(mouseEvent.getPoint()));
            this.setMouseInCloseButton(mouseEvent.getPoint());
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.setMouseInCloseButton(mouseEvent.getPoint());
        }

        public int isClosePressed() {
            return this.closePressed;
        }

        public int isMouseInCloseButton() {
            return this.mouseInCloseButton;
        }

        protected void setClosePressed(int n) {
            if (this.closePressed == n) {
                return;
            }
            int n2 = this.closePressed;
            this.closePressed = n;
            if (this.closePressed == -1) {
                TabLayoutModel tabLayoutModel = AbstractViewTabDisplayerUI.this.getLayoutModel();
                AbstractViewTabDisplayerUI.this.getDisplayer().repaint(tabLayoutModel.getX(n2), tabLayoutModel.getY(n2), tabLayoutModel.getW(n2), tabLayoutModel.getH(n2));
            } else if (n2 == -1) {
                TabLayoutModel tabLayoutModel = AbstractViewTabDisplayerUI.this.getLayoutModel();
                AbstractViewTabDisplayerUI.this.getDisplayer().repaint(tabLayoutModel.getX(this.closePressed), tabLayoutModel.getY(this.closePressed), tabLayoutModel.getW(this.closePressed), tabLayoutModel.getH(this.closePressed));
            } else {
                AbstractViewTabDisplayerUI.this.getDisplayer().repaint();
            }
        }

        protected void setMouseInCloseButton(Point point) {
            int n = this.inCloseIconRect(point);
            if (this.mouseInCloseButton == n || AbstractViewTabDisplayerUI.this.dataModel.size() == 0) {
                return;
            }
            int n2 = this.mouseInCloseButton;
            this.mouseInCloseButton = n;
            if (n == -1) {
                TabLayoutModel tabLayoutModel = AbstractViewTabDisplayerUI.this.getLayoutModel();
                AbstractViewTabDisplayerUI.this.getDisplayer().repaint(tabLayoutModel.getX(n2), tabLayoutModel.getY(n2), tabLayoutModel.getW(n2), tabLayoutModel.getH(n2));
            } else if (n2 == -1) {
                TabLayoutModel tabLayoutModel = AbstractViewTabDisplayerUI.this.getLayoutModel();
                AbstractViewTabDisplayerUI.this.getDisplayer().repaint(tabLayoutModel.getX(n), tabLayoutModel.getY(n), tabLayoutModel.getW(n), tabLayoutModel.getH(n));
            } else {
                AbstractViewTabDisplayerUI.this.getDisplayer().repaint();
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AbstractViewTabDisplayerUI.this.performPinAction();
        }
    }

    static final class IconLoader {
        private Map paths2Icons;

        IconLoader() {
        }

        public Icon obtainIcon(String string) {
            Icon icon;
            if (this.paths2Icons == null) {
                this.paths2Icons = new HashMap(6);
            }
            if ((icon = (Icon)this.paths2Icons.get(string)) == null) {
                Image image = AbstractViewTabDisplayerUI.loadImage(string);
                if (image == null) {
                    throw new IllegalArgumentException("Icon with resource path: " + string + " can't be loaded, probably wrong path.");
                }
                icon = new ImageIcon(image);
                this.paths2Icons.put(string, icon);
            }
            return icon;
        }
    }
}

