/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol;

import java.awt.Component;
import java.awt.Graphics;
import java.util.Arrays;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.event.ListDataEvent;
import org.netbeans.swing.tabcontrol.DefaultTabDataModel;
import org.netbeans.swing.tabcontrol.TabData;
import org.netbeans.swing.tabcontrol.TabDataModel;
import org.netbeans.swing.tabcontrol.TabbedContainer;
import org.netbeans.swing.tabcontrol.event.ComplexListDataEvent;

public class DataModelTest {
    ComplexListDataEvent lastEvent = null;
    String lastListenerCall = null;
    TabDataModel mdl = null;
    Icon ic = new Icon(){

        public int getIconWidth() {
            return 16;
        }

        public int getIconHeight() {
            return 16;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        }
    };
    Icon sameSizeIcon = new Icon(){

        public int getIconWidth() {
            return 16;
        }

        public int getIconHeight() {
            return 16;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        }
    };
    Icon biggerIcon = new Icon(){

        public int getIconWidth() {
            return 22;
        }

        public int getIconHeight() {
            return 22;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        }
    };
    TabData[] data = null;
    boolean noEvent = false;

    public DataModelTest(String string) {
    }

    public void setUp() {
        this.prepareModel();
    }

    private void assertPravda(boolean bl, String string) {
    }

    private void assertText(String string, int n) {
        TabData tabData = this.mdl.getTab(n);
        this.assertPravda(tabData.getText().equals(string), "Text at " + n + " was not " + string + " it was " + tabData.getText());
    }

    private void assertData(int n, TabData tabData) {
        TabData tabData2 = this.mdl.getTab(n);
        this.assertPravda(tabData.equals(tabData2), "TabData at " + n + " is not " + tabData + " it is " + tabData2);
    }

    private void assertListenerCall(String string) {
        this.assertPravda(this.lastEvent != null, "Last listener call should be non-null");
        this.assertPravda(string.equals(this.lastListenerCall), "Last listener call should have been " + string + " but was " + this.lastListenerCall);
    }

    private void assertEventIndices(int[] nArray) {
        this.assertPravda(this.lastEvent != null, "Last event should have been fired but is null");
        int[] nArray2 = this.lastEvent.getIndices();
        Arrays.sort(nArray);
        Arrays.sort(nArray2);
        this.assertPravda(nArray2.length == nArray.length, "Indices length in last change should be " + nArray.length + " but is " + nArray2.length + " expected indices: " + DataModelTest.arrToStr(nArray) + " actual indices " + DataModelTest.arrToStr(nArray2));
        for (int i = 0; i < nArray2.length; ++i) {
            this.assertPravda(nArray2[i] == nArray[i], "Event indices should be " + DataModelTest.arrToStr(nArray) + " but are " + DataModelTest.arrToStr(nArray2));
        }
    }

    private void assertEventIndices(int n, int n2) {
        this.assertPravda(this.lastEvent != null, "Last event should have been fired but is null");
        this.assertPravda(n == this.lastEvent.getIndex0(), "Event start index should be " + n + " but is " + this.lastEvent.getIndex0());
        this.assertPravda(n2 == this.lastEvent.getIndex1(), "Event end index should be " + n2 + " but is " + this.lastEvent.getIndex1());
    }

    private void assertWidthChanged() {
        this.assertPravda(this.lastEvent != null, "Last event should have been fired but is null");
        this.assertPravda(this.lastEvent.isTextChanged(), "Last event should have been a text change event but wasn't");
    }

    private void assertWidthNotChanged() {
        this.assertPravda(this.lastEvent != null, "Last event should have been fired but is null");
        this.assertPravda(!this.lastEvent.isTextChanged(), "Last event should not have been a text change event but was");
    }

    public void testEverything() {
        this.doTestContentsValid();
        this.doTestAdd();
        this.doTestRemove();
        this.doTestAddContiguous();
        this.doTestRemoveContiguous();
        this.doTestAddNonContiguous();
        this.doTestRemoveNonContiguous();
        this.doTestSetTab();
        this.doTestSetTextNonContiguous();
        this.doTestSetIconNonContiguous();
        this.doTestSetIconAndTextNonContiguous();
        System.err.println("All tests passed");
    }

    public void doTestContentsValid() {
        System.err.println("testContentsValid");
        this._testContentsValid();
    }

    private void _testContentsValid() {
        int n = 0;
        for (char c = 'a'; c < 'z'; c = (char)(c + '\u0001')) {
            TabData tabData = this.mdl.getTab(n);
            this.assertPravda(tabData.getText().charAt(0) == c, "Name at " + n + " is not " + c + " it is " + tabData.getText());
            ++n;
        }
    }

    public void doTestAdd() {
        System.err.println("testAdd");
        TabData tabData = new TabData(new JLabel("testAdd"), this.ic, "testAdd", "Tip:testAdd");
        this.mdl.addTabs(0, new TabData[]{tabData});
        this.assertData(0, tabData);
    }

    public void doTestRemove() {
        System.err.println("testRemove");
        this.mdl.removeTab(0);
        this.assertText("a", 0);
    }

    public void doTestAddContiguous() {
        int n;
        System.err.println("testAddContiguous");
        int n2 = this.mdl.size();
        TabData[] tabDataArray = new TabData[10];
        for (n = 0; n < 10; ++n) {
            String string = Integer.toString(n);
            JLabel jLabel = new JLabel();
            tabDataArray[n] = new TabData(jLabel, this.ic, string, "Tip:" + string);
        }
        this.mdl.addTabs(10, tabDataArray);
        n = n2 + 10;
        this.assertPravda(this.mdl.size() == n, "Model size should be " + n + " after adding 10 items, but is " + this.mdl.size());
        for (int i = 10; i < 20; ++i) {
            this.assertData(i, tabDataArray[i - 10]);
        }
    }

    public void doTestRemoveContiguous() {
        System.err.println("testRemoveContiguous");
        int n = this.mdl.size();
        this.mdl.removeTabs(10, 20);
        int n2 = n - 10;
        this.assertPravda(this.mdl.size() == n2, "Model size should be " + n2 + " after removing 10 items, but is " + this.mdl.size());
        try {
            this._testContentsValid();
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
    }

    public void doTestAddNonContiguous() {
        System.err.println("testAddNonContiguous");
        int[] nArray = new int[]{3, 1, 5};
        this.data = new TabData[3];
        for (int i = 0; i < nArray.length; ++i) {
            String string = Integer.toString(nArray[i]);
            this.data[i] = new TabData(new JLabel(), this.ic, string, "Tip:" + string);
        }
        this.mdl.addTabs(nArray, this.data);
        this.assertData(3, this.data[0]);
        this.assertData(1, this.data[1]);
        this.assertData(5, this.data[2]);
        Arrays.sort(nArray);
        this.assertEventIndices(nArray);
        this.assertListenerCall("indicesAdded");
    }

    public void doTestRemoveNonContiguous() {
        int[] nArray = new int[]{5, 1, 3};
        this.mdl.removeTabs(nArray);
        try {
            this._testContentsValid();
        }
        catch (RuntimeException runtimeException) {
            System.err.println("After non-contiguous removal of " + DataModelTest.arrToStr(nArray) + ", contents should be original contents, but are " + this.mdl.toString());
            throw runtimeException;
        }
        Arrays.sort(nArray);
        this.assertEventIndices(nArray);
        this.assertListenerCall("indicesRemoved");
    }

    public void doTestSetTab() {
        System.err.println("testSetTab");
        TabData tabData = this.mdl.getTab(22);
        TabData tabData2 = new TabData(new JLabel(), this.ic, "foo", "Tip:foo");
        this.mdl.setTab(22, tabData2);
        this.assertData(22, tabData2);
        this.mdl.setTab(22, tabData);
        this.assertListenerCall("contentsChanged");
        this.assertEventIndices(22, 22);
        this.noEvent = true;
        this.mdl.setTab(22, tabData);
        this.mdl.setText(22, tabData.getText());
        this.mdl.setIcon(22, this.ic);
        this.noEvent = false;
    }

    public void doTestSetTextNonContiguous() {
        int n;
        System.err.println("testSetTextNonContiguous");
        String[] stringArray = new String[5];
        int[] nArray = new int[]{22, 11, 15, 8, 3};
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.mdl.getTab(nArray[i]).getText();
        }
        this.noEvent = true;
        this.mdl.setText(nArray, stringArray);
        this.noEvent = false;
        String[] stringArray2 = new String[stringArray.length];
        for (n = 0; n < stringArray2.length; ++n) {
            stringArray2[n] = stringArray[n] + "modified";
        }
        this.mdl.setText(nArray, stringArray2);
        for (n = 0; n < stringArray2.length; ++n) {
            this.assertText(stringArray2[n], nArray[n]);
        }
        Arrays.sort(nArray);
        this.assertEventIndices(nArray);
        this.assertListenerCall("contentsChanged");
        this.assertWidthChanged();
        this.mdl.setText(nArray, stringArray);
    }

    public void doTestSetIcon() {
        System.err.println("testSetIcon");
        TabData tabData = this.mdl.getTab(20);
        this.noEvent = true;
        this.mdl.setIcon(20, tabData.getIcon());
        this.noEvent = false;
        this.mdl.setIcon(20, this.sameSizeIcon);
        this.assertEventIndices(20, 20);
        this.assertListenerCall("contentsChanged");
        this.assertPravda(tabData.getIcon() == this.sameSizeIcon, "Icon was changed but same old still returned from TabData");
        this.assertWidthNotChanged();
        ComplexListDataEvent complexListDataEvent = this.lastEvent;
        this.mdl.setIcon(20, this.biggerIcon);
        this.assertWidthChanged();
        this.assertPravda(complexListDataEvent != this.lastEvent, "Icon changed but no event fired");
        this.mdl.setIcon(20, this.ic);
    }

    public void doTestSetIconNonContiguous() {
        System.err.println("testSetIconNonContiguous");
        Object[] objectArray = new Icon[5];
        int[] nArray = new int[]{22, 11, 15, 8, 3};
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = this.mdl.getTab(nArray[i]).getIcon();
        }
        this.noEvent = true;
        this.mdl.setIcon(nArray, (Icon[])objectArray);
        this.noEvent = false;
        ComplexListDataEvent complexListDataEvent = this.lastEvent;
        Arrays.fill(objectArray, this.sameSizeIcon);
        this.mdl.setIcon(nArray, (Icon[])objectArray);
        this.assertPravda(complexListDataEvent != this.lastEvent, "Icons changed but no event fired");
        complexListDataEvent = this.lastEvent;
        this.assertListenerCall("contentsChanged");
        this.assertWidthNotChanged();
        Arrays.fill(objectArray, this.biggerIcon);
        objectArray[2] = this.sameSizeIcon;
        int[] nArray2 = new int[]{3, 8, 22, 11};
        this.mdl.setIcon(nArray, (Icon[])objectArray);
        this.assertPravda(complexListDataEvent != this.lastEvent, "Icons changed but no event fired");
        this.assertListenerCall("contentsChanged");
        this.assertWidthChanged();
        this.assertEventIndices(nArray2);
        Arrays.fill(objectArray, this.ic);
        this.mdl.setIcon(nArray, (Icon[])objectArray);
    }

    public void doTestSetIconAndTextNonContiguous() {
        System.err.println("testSetIconAndTextNonContiguous");
        int[] nArray = new int[]{3, 10, 5};
        Object[] objectArray = new Icon[3];
        Arrays.fill(objectArray, this.ic);
        String[] stringArray = new String[3];
        for (int i = 0; i < 3; ++i) {
            stringArray[i] = this.mdl.getTab(i).getText();
        }
        this.mdl.setIconsAndText(nArray, stringArray, (Icon[])objectArray);
        this.noEvent = true;
        this.mdl.setIconsAndText(nArray, stringArray, (Icon[])objectArray);
        this.noEvent = false;
        String[] stringArray2 = new String[stringArray.length];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        ComplexListDataEvent complexListDataEvent = this.lastEvent;
        objectArray[0] = this.sameSizeIcon;
        this.mdl.setIconsAndText(nArray, stringArray, (Icon[])objectArray);
        this.assertPravda(complexListDataEvent != this.lastEvent, "Icons and text changed but no event fired");
        this.assertWidthNotChanged();
        this.assertEventIndices(new int[]{3});
        complexListDataEvent = this.lastEvent;
        objectArray[0] = this.biggerIcon;
        stringArray[1] = "foobar";
        this.mdl.setIconsAndText(nArray, stringArray, (Icon[])objectArray);
        this.assertPravda(complexListDataEvent != this.lastEvent, "Icons and text changed but no event fired");
        this.assertWidthChanged();
        this.assertEventIndices(new int[]{3, 10});
        complexListDataEvent = this.lastEvent;
        objectArray[0] = this.ic;
        stringArray[1] = "boo";
        this.mdl.setIconsAndText(nArray, stringArray, (Icon[])objectArray);
        this.assertPravda(complexListDataEvent != this.lastEvent, "Icons and text changed but no event fired");
        this.assertWidthChanged();
        this.assertEventIndices(new int[]{3, 10});
        Arrays.fill(objectArray, this.ic);
        this.mdl.setIconsAndText(nArray, stringArray2, (Icon[])objectArray);
    }

    static String arrToStr(int[] nArray) {
        if (nArray == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer(nArray.length * 3);
        for (int i = 0; i < nArray.length; ++i) {
            stringBuffer.append(nArray[i]);
            if (i == nArray.length - 1) continue;
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    private void prepareModel() {
        if (this.mdl != null) {
            // empty if block
        }
        TabData[] tabDataArray = new TabData[25];
        int n = 0;
        for (char c = 'a'; c < 'z'; c = (char)((char)(c + 1))) {
            String string = new String(new char[]{c});
            JLabel jLabel = new JLabel(string);
            jLabel.setName(string);
            tabDataArray[n] = new TabData(jLabel, this.ic, string, "tip:" + string);
            ++n;
        }
        this.mdl = new DefaultTabDataModel(tabDataArray);
    }

    public static void main(String[] stringArray) {
        DefaultTabDataModel defaultTabDataModel = new DefaultTabDataModel();
        TabData tabData = new TabData(new JTree(), null, "TEST", "OK");
        TabData tabData2 = new TabData(new JTree(), null, "TEST2", "OK2");
        defaultTabDataModel.addTab(0, tabData);
        defaultTabDataModel.addTab(1, tabData2);
        JFrame jFrame = new JFrame();
        jFrame.setSize(400, 400);
        TabbedContainer tabbedContainer = new TabbedContainer(defaultTabDataModel, 1);
        jFrame.getContentPane().add(tabbedContainer);
        jFrame.setVisible(true);
    }

    public void contentsChanged(ListDataEvent listDataEvent) {
        this.lastListenerCall = "contentsChanged";
        this.lastEvent = (ComplexListDataEvent)listDataEvent;
        if (this.noEvent) {
            this.assertPravda(false, "No event expected but " + listDataEvent + " receieved");
        }
    }

    public void indicesAdded(ComplexListDataEvent complexListDataEvent) {
        this.lastListenerCall = "indicesAdded";
        this.lastEvent = complexListDataEvent;
        if (this.noEvent) {
            this.assertPravda(false, "No event expected but " + complexListDataEvent + " receieved");
        }
    }

    public void indicesChanged(ComplexListDataEvent complexListDataEvent) {
        this.lastListenerCall = "indicesChanged";
        this.lastEvent = complexListDataEvent;
        if (this.noEvent) {
            this.assertPravda(false, "No event expected but " + complexListDataEvent + " receieved");
        }
    }

    public void indicesRemoved(ComplexListDataEvent complexListDataEvent) {
        this.lastListenerCall = "indicesRemoved";
        this.lastEvent = complexListDataEvent;
        if (this.noEvent) {
            this.assertPravda(false, "No event expected but " + complexListDataEvent + " receieved");
        }
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
        this.lastListenerCall = "intervalAdded";
        this.assertPravda(listDataEvent.getIndex0() <= listDataEvent.getIndex1(), "Event start index > end index");
        this.lastEvent = (ComplexListDataEvent)listDataEvent;
        if (this.noEvent) {
            this.assertPravda(false, "No event expected but " + listDataEvent + " receieved");
        }
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.lastListenerCall = "intervalRemoved";
        this.lastEvent = (ComplexListDataEvent)listDataEvent;
        if (this.noEvent) {
            this.assertPravda(false, "No event expected but " + listDataEvent + " receieved");
        }
    }
}

