/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.url;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.provider.AbstractFileObject;
import org.apache.commons.vfs.provider.URLFileName;
import org.apache.commons.vfs.provider.url.UrlFileSystem;

public class UrlFileObject
extends AbstractFileObject
implements FileObject {
    private URL url;

    protected UrlFileObject(UrlFileSystem urlFileSystem, FileName fileName) {
        super(fileName, urlFileSystem);
    }

    protected void doAttach() throws Exception {
        if (this.url == null) {
            this.url = this.createURL(this.getName());
        }
    }

    protected URL createURL(FileName fileName) throws MalformedURLException, FileSystemException, URIException {
        if (fileName instanceof URLFileName) {
            URLFileName uRLFileName = (URLFileName)this.getName();
            return new URL(uRLFileName.getURIEncoded(null));
        }
        return new URL(this.getName().getURI());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected FileType doGetType() throws Exception {
        try {
            URLConnection uRLConnection = this.url.openConnection();
            InputStream inputStream = uRLConnection.getInputStream();
            try {
                int n;
                if (uRLConnection instanceof HttpURLConnection && 200 != (n = ((HttpURLConnection)uRLConnection).getResponseCode())) {
                    FileType fileType = FileType.IMAGINARY;
                    return fileType;
                }
                FileType fileType = FileType.FILE;
                return fileType;
            }
            finally {
                inputStream.close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            return FileType.IMAGINARY;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long doGetContentSize() throws Exception {
        URLConnection uRLConnection = this.url.openConnection();
        InputStream inputStream = uRLConnection.getInputStream();
        try {
            long l = uRLConnection.getContentLength();
            return l;
        }
        finally {
            inputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long doGetLastModifiedTime() throws Exception {
        URLConnection uRLConnection = this.url.openConnection();
        InputStream inputStream = uRLConnection.getInputStream();
        try {
            long l = uRLConnection.getLastModified();
            return l;
        }
        finally {
            inputStream.close();
        }
    }

    protected String[] doListChildren() throws Exception {
        throw new FileSystemException("Not implemented.");
    }

    protected InputStream doGetInputStream() throws Exception {
        return this.url.openStream();
    }
}

