/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.tar;

import java.io.File;
import java.util.Date;
import org.apache.commons.vfs.provider.tar.TarUtils;

class TarEntry {
    private int m_checkSum;
    private int m_devMajor;
    private int m_devMinor;
    private File m_file;
    private int m_groupID;
    private StringBuffer m_groupName;
    private byte m_linkFlag;
    private StringBuffer m_linkName;
    private StringBuffer m_magic = new StringBuffer("ustar");
    private long m_modTime;
    private int m_mode;
    private StringBuffer m_name = new StringBuffer();
    private long m_size;
    private int m_userID;
    private StringBuffer m_userName;

    TarEntry(byte[] byArray) {
        this();
        this.parseTarHeader(byArray);
    }

    private TarEntry() {
        this.m_linkName = new StringBuffer();
        String string = System.getProperty("user.name", "");
        if (string.length() > 31) {
            string = string.substring(0, 31);
        }
        this.m_userName = new StringBuffer(string);
        this.m_groupName = new StringBuffer("");
    }

    public void setName(String string) {
        this.m_name = new StringBuffer(string);
    }

    public Date getModTime() {
        return new Date(this.m_modTime * 1000L);
    }

    public String getName() {
        return this.m_name.toString();
    }

    public long getSize() {
        return this.m_size;
    }

    public boolean isDirectory() {
        if (this.m_file != null) {
            return this.m_file.isDirectory();
        }
        if (this.m_linkFlag == 53) {
            return true;
        }
        return this.getName().endsWith("/");
    }

    public boolean isGNULongNameEntry() {
        return this.m_linkFlag == 76 && this.m_name.toString().equals("././@LongLink");
    }

    public boolean equals(TarEntry tarEntry) {
        return this.getName().equals(tarEntry.getName());
    }

    private void parseTarHeader(byte[] byArray) {
        int n = 0;
        this.m_name = TarUtils.parseName(byArray, n, 100);
        this.m_mode = (int)TarUtils.parseOctal(byArray, n += 100, 8);
        this.m_userID = (int)TarUtils.parseOctal(byArray, n += 8, 8);
        this.m_groupID = (int)TarUtils.parseOctal(byArray, n += 8, 8);
        this.m_size = TarUtils.parseOctal(byArray, n += 8, 12);
        this.m_modTime = TarUtils.parseOctal(byArray, n += 12, 12);
        this.m_checkSum = (int)TarUtils.parseOctal(byArray, n += 12, 8);
        n += 8;
        this.m_linkFlag = byArray[n++];
        this.m_linkName = TarUtils.parseName(byArray, n, 100);
        this.m_magic = TarUtils.parseName(byArray, n += 100, 8);
        this.m_userName = TarUtils.parseName(byArray, n += 8, 32);
        this.m_groupName = TarUtils.parseName(byArray, n += 32, 32);
        this.m_devMajor = (int)TarUtils.parseOctal(byArray, n += 32, 8);
        this.m_devMinor = (int)TarUtils.parseOctal(byArray, n += 8, 8);
    }
}

