/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.http;

import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.provider.AbstractRandomAccessStreamContent;
import org.apache.commons.vfs.provider.http.HttpFileObject;
import org.apache.commons.vfs.provider.http.HttpFileSystem;
import org.apache.commons.vfs.util.MonitorInputStream;
import org.apache.commons.vfs.util.RandomAccessMode;

class HttpRandomAccesContent
extends AbstractRandomAccessStreamContent {
    private final HttpFileObject fileObject;
    private final HttpFileSystem fileSystem;
    protected long filePointer = 0L;
    private DataInputStream dis = null;
    private MonitorInputStream mis = null;

    HttpRandomAccesContent(HttpFileObject httpFileObject, RandomAccessMode randomAccessMode) {
        super(randomAccessMode);
        this.fileObject = httpFileObject;
        this.fileSystem = (HttpFileSystem)this.fileObject.getFileSystem();
    }

    public long getFilePointer() throws IOException {
        return this.filePointer;
    }

    public void seek(long l) throws IOException {
        if (l == this.filePointer) {
            return;
        }
        if (l < 0L) {
            throw new FileSystemException("vfs.provider/random-access-invalid-position.error", new Object[]{new Long(l)});
        }
        if (this.dis != null) {
            this.close();
        }
        this.filePointer = l;
    }

    protected DataInputStream getDataInputStream() throws IOException {
        if (this.dis != null) {
            return this.dis;
        }
        GetMethod getMethod = new GetMethod();
        this.fileObject.setupMethod((HttpMethod)getMethod);
        getMethod.setRequestHeader("Range", "bytes=" + this.filePointer + "-");
        int n = this.fileSystem.getClient().executeMethod((HttpMethod)getMethod);
        if (n != 206) {
            throw new FileSystemException("vfs.provider.http/get-range.error", new Object[]{this.fileObject.getName(), new Long(this.filePointer)});
        }
        this.mis = new HttpFileObject.HttpInputStream(getMethod);
        this.dis = new DataInputStream(new FilterInputStream(this.mis){

            public int read() throws IOException {
                int n = super.read();
                if (n > -1) {
                    ++HttpRandomAccesContent.this.filePointer;
                }
                return n;
            }

            public int read(byte[] byArray) throws IOException {
                int n = super.read(byArray);
                if (n > -1) {
                    HttpRandomAccesContent.this.filePointer += (long)n;
                }
                return n;
            }

            public int read(byte[] byArray, int n, int n2) throws IOException {
                int n3 = super.read(byArray, n, n2);
                if (n3 > -1) {
                    HttpRandomAccesContent.this.filePointer += (long)n3;
                }
                return n3;
            }
        });
        return this.dis;
    }

    public void close() throws IOException {
        if (this.dis != null) {
            this.dis.close();
            this.dis = null;
            this.mis = null;
        }
    }

    public long length() throws IOException {
        return this.fileObject.getContent().getSize();
    }
}

