/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider;

import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.provider.AbstractFileNameParser;
import org.apache.commons.vfs.provider.LayeredFileName;
import org.apache.commons.vfs.provider.UriParser;
import org.apache.commons.vfs.provider.VfsComponentContext;

public class LayeredFileNameParser
extends AbstractFileNameParser {
    private static final LayeredFileNameParser INSTANCE = new LayeredFileNameParser();

    public static LayeredFileNameParser getInstance() {
        return INSTANCE;
    }

    public boolean encodeCharacter(char c) {
        return super.encodeCharacter(c) || c == '!';
    }

    public FileName parseUri(VfsComponentContext vfsComponentContext, FileName fileName, String string) throws FileSystemException {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = UriParser.extractScheme(string, stringBuffer);
        String string3 = this.extractRootName(stringBuffer);
        FileName fileName2 = null;
        if (string3 != null) {
            fileName2 = vfsComponentContext.parseURI(string3);
        }
        UriParser.canonicalizePath(stringBuffer, 0, stringBuffer.length(), this);
        UriParser.fixSeparators(stringBuffer);
        FileType fileType = UriParser.normalisePath(stringBuffer);
        String string4 = stringBuffer.toString();
        return new LayeredFileName(string2, fileName2, string4, fileType);
    }

    protected String extractRootName(StringBuffer stringBuffer) throws FileSystemException {
        int n;
        int n2 = stringBuffer.length();
        for (n = n2 - 1; n > 0 && stringBuffer.charAt(n) != '!'; --n) {
        }
        if (n == 0 && stringBuffer.charAt(n) != '!') {
            n = n2;
        }
        String string = stringBuffer.substring(0, n);
        if (n < n2) {
            stringBuffer.delete(0, n + 1);
        } else {
            stringBuffer.setLength(0);
        }
        return string;
    }
}

