/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.cache;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.cache.AbstractFilesCache;

public class DefaultFilesCache
extends AbstractFilesCache {
    private final Map filesystemCache = new HashMap(10);

    public void putFile(FileObject fileObject) {
        Map map = this.getOrCreateFilesystemCache(fileObject.getFileSystem());
        map.put(fileObject.getName(), fileObject);
    }

    public FileObject getFile(FileSystem fileSystem, FileName fileName) {
        Map map = this.getOrCreateFilesystemCache(fileSystem);
        return (FileObject)map.get(fileName);
    }

    public void clear(FileSystem fileSystem) {
        Map map = this.getOrCreateFilesystemCache(fileSystem);
        map.clear();
    }

    protected Map getOrCreateFilesystemCache(FileSystem fileSystem) {
        TreeMap treeMap = (TreeMap)this.filesystemCache.get(fileSystem);
        if (treeMap == null) {
            treeMap = new TreeMap();
            this.filesystemCache.put(fileSystem, treeMap);
        }
        return treeMap;
    }

    public void close() {
        super.close();
        this.filesystemCache.clear();
    }

    public void removeFile(FileSystem fileSystem, FileName fileName) {
        Map map = this.getOrCreateFilesystemCache(fileSystem);
        map.remove(fileName);
    }

    public void touchFile(FileObject fileObject) {
    }
}

