/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xpath;

import com.japisoft.xpath.XPathResolver;
import com.japisoft.xpath.node.AbstractNode;
import com.japisoft.xpath.node.Expr;
import com.japisoft.xpath.node.Function;
import com.japisoft.xpath.node.Literal;
import com.japisoft.xpath.node.Node;
import com.japisoft.xpath.node.Number;
import com.japisoft.xpath.node.Operator;
import com.japisoft.xpath.node.Predicate;
import com.japisoft.xpath.node.Variable;
import java.util.Stack;

public final class TreeXPathResolver
implements XPathResolver {
    private String lastAxisName;
    private AbstractNode currentNode;
    private Stack nodeStack = new Stack();
    private AbstractNode root = null;
    boolean attributeMode = false;

    public void nextFunction() {
    }

    public void nextParam() {
        AbstractNode abstractNode = (AbstractNode)this.nodeStack.pop();
        AbstractNode abstractNode2 = null;
        for (int i = this.nodeStack.size() - 1; i >= 0; --i) {
            if (!(this.nodeStack.elementAt(i) instanceof Function)) continue;
            abstractNode2 = (Function)this.nodeStack.elementAt(i);
            break;
        }
        if (abstractNode2 == null) {
            return;
        }
        abstractNode2.addNode(abstractNode);
    }

    public void functionName(String string) {
        Function function = new Function();
        function.setName(string);
        this.currentNode = function;
        this.nodeStack.push(this.currentNode);
    }

    public void number(String string) {
        Number number = new Number();
        number.setNumber(string);
        this.nodeStack.push(number);
    }

    public void literal(String string) {
        Literal literal = new Literal();
        literal.setValue(string);
        this.nodeStack.push(literal);
    }

    public void variable(String string) {
        Variable variable = new Variable();
        variable.setName(string);
        this.nodeStack.push(variable);
    }

    public void unaryOperator(int n) {
        Expr expr = (Expr)this.nodeStack.pop();
        if (n == 10 && expr instanceof Number) {
            Number number = (Number)expr;
            number.setNumber("-" + number.getNumber());
            this.nodeStack.push(expr);
            return;
        }
        Operator operator = new Operator();
        operator.setPredefinedOperator(n);
        operator.addNode(expr);
        this.nodeStack.push(operator);
        this.currentNode = expr;
    }

    public void binaryOperator(String string) {
        Expr expr = (Expr)this.nodeStack.pop();
        Expr expr2 = (Expr)this.nodeStack.pop();
        Operator operator = new Operator();
        operator.setOperator(string);
        operator.addNode(expr2);
        operator.addNode(expr);
        this.nodeStack.push(operator);
        this.currentNode = operator;
    }

    public void binaryOperator(int n) {
        Expr expr = null;
        Expr expr2 = null;
        expr = (Expr)this.nodeStack.pop();
        expr2 = (Expr)this.nodeStack.pop();
        Operator operator = new Operator();
        operator.setPredefinedOperator(n);
        operator.addNode(expr2);
        operator.addNode(expr);
        this.nodeStack.push(operator);
        this.currentNode = operator;
    }

    public void nodeType(String string) {
        this.nameTest(null, null);
        ((Node)this.currentNode).setType(string);
    }

    public void processingInstruction(String string, String string2) {
        this.currentNode = new Node();
        this.nodeType("processing-instruction");
        ((Node)this.currentNode).setName("", null);
    }

    public void nameTest(String string, String string2) {
        this.currentNode = new Node();
        ((Node)this.currentNode).setName(string, string2);
        if (this.lastAxisName != null) {
            ((Node)this.currentNode).setAxis(this.lastAxisName);
            ((Node)this.currentNode).setAttributeMode(this.attributeMode);
        }
        this.lastAxisName = null;
        this.attributeMode = false;
        this.nodeStack.push(this.currentNode);
        if (this.root == null && !(this.nodeStack.elementAt(0) instanceof Function)) {
            this.root = (Node)this.currentNode;
        }
    }

    public void abbreviatedAxis(String string) {
        if ("." == string) {
            this.lastAxisName = "self";
        } else if (".." == string) {
            this.lastAxisName = "parent";
        } else if ("//" == string) {
            this.lastAxisName = "descendant-or-self";
            Node node = null;
            if (this.currentNode instanceof Node) {
                node = (Node)this.currentNode;
                if (node == null) {
                    node = (Node)this.nodeStack.peek();
                }
                node.setAxis(this.lastAxisName);
            }
        } else if ("@" == string) {
            this.lastAxisName = "attribute";
            this.attributeMode = true;
        }
    }

    public void axis(String string) {
        this.lastAxisName = string;
    }

    public void nextPredicate() {
        AbstractNode abstractNode = (AbstractNode)this.nodeStack.pop();
        Predicate predicate = new Predicate();
        predicate.addNode(abstractNode);
        if (this.nodeStack.size() > 0) {
            this.currentNode = (Node)this.nodeStack.peek();
            this.currentNode.addNode(predicate);
        } else {
            this.nodeStack.push(this.currentNode);
        }
    }

    public void nextExpression() {
        Expr expr = new Expr();
        if (this.nodeStack.size() > 0) {
            this.currentNode = (AbstractNode)this.nodeStack.pop();
        }
        expr.addNode(this.currentNode);
        this.nodeStack.push(expr);
    }

    public void nextLocationPath() {
        if (this.nodeStack.size() == 1 || this.nodeStack.size() >= 2 && !(this.nodeStack.elementAt(this.nodeStack.size() - 2) instanceof Node)) {
            this.currentNode = (AbstractNode)this.nodeStack.peek();
        } else {
            if (this.nodeStack.isEmpty()) {
                return;
            }
            Node node = (Node)this.nodeStack.pop();
            this.currentNode = (Node)this.nodeStack.pop();
            this.currentNode.addNode(node);
            if (this.nodeStack.size() >= 1 && this.nodeStack.elementAt(0) instanceof Function) {
                this.nodeStack.push(this.currentNode);
                this.currentNode = node;
            } else {
                AbstractNode abstractNode = this.currentNode;
                this.currentNode = node;
                this.nodeStack.push(abstractNode);
            }
        }
    }

    public void root() {
        if (this.currentNode == null) {
            this.root = new Node();
            this.nodeStack.push(this.root);
            ((Node)this.root).setFromRoot(true);
        } else {
            AbstractNode abstractNode = (Node)this.currentNode;
            while (abstractNode.getParentNode() != null) {
                abstractNode = abstractNode.getParentNode();
            }
            if (abstractNode instanceof Node) {
                ((Node)abstractNode).setFromRoot(true);
            }
        }
    }

    public AbstractNode getRootParsedNode() {
        if (!(this.root == null || this.nodeStack.size() > 0 && this.nodeStack.elementAt(0) instanceof Expr)) {
            Node node;
            if (this.root instanceof Node && !(node = (Node)this.root).hasAxis()) {
                node.setAxis(this.lastAxisName);
            }
            return this.root;
        }
        if (this.currentNode.getRootNode() != null) {
            return this.currentNode.getRootNode();
        }
        return this.currentNode;
    }
}

