/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xmlpad.helper.model;

import com.japisoft.fastparser.node.SimpleNode;
import com.japisoft.xmlpad.ComponentFactory;
import com.japisoft.xmlpad.SharedProperties;
import com.japisoft.xmlpad.editor.XMLDocument;
import com.japisoft.xmlpad.editor.XMLEditor;
import com.japisoft.xmlpad.helper.model.CommonDescriptorRenderer;
import com.japisoft.xmlpad.helper.model.Descriptor;
import com.japisoft.xmlpad.helper.model.Helper;
import com.japisoft.xmlpad.helper.model.TagDescriptor;
import com.japisoft.xmlpad.helper.ui.HelperUIContext;
import com.japisoft.xmlpad.helper.ui.TitledPanelHelper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.text.BadLocationException;

public class AbstractHelper
implements Helper {
    protected String namespace;
    protected XMLEditor editor;
    private String charToInsert = null;
    public static JPanel WIN = null;
    private static TitledPanelHelper titleLabel = null;
    private static JList list;
    private Timer t = null;
    private AsynchronousShowHelper asynchronousHelper = null;

    public String getTitle() {
        return null;
    }

    public void setLocation(SimpleNode simpleNode, int n) {
    }

    public void setNamespace(String string) {
        this.namespace = string;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setEditor(XMLEditor xMLEditor) {
        this.editor = xMLEditor;
    }

    public boolean show(int n, String string) {
        return this.show(n, string, true);
    }

    public boolean show(int n, String string, boolean bl) {
        try {
            if (!this.hasElements()) {
                return false;
            }
            this.charToInsert = string;
            Rectangle rectangle = this.editor.modelToView(n);
            this.showUI(n + 1, rectangle.x, rectangle.y + rectangle.height, bl);
            return true;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    protected boolean hasElements() {
        return false;
    }

    private void showUI(int n, int n2, int n3, boolean bl) {
        if (bl) {
            this.asynchronousHelper = new AsynchronousShowHelper(n, n2, n3);
            this.t = new Timer(SharedProperties.HELPER_DELAY, this.asynchronousHelper);
            this.t.setRepeats(false);
            this.t.start();
        } else {
            this.asynchronousHelper = new AsynchronousShowHelper(n, n2, n3);
            this.asynchronousHelper.actionPerformed(new ActionEvent(this, 0, null));
        }
    }

    private void removePopup() {
        if (this.t != null) {
            this.t.stop();
            this.t.removeActionListener(this.asynchronousHelper);
            this.t = null;
        }
        WIN.setVisible(false);
        this.editor.remove(WIN);
        this.editor.invalidate();
        this.editor.validate();
    }

    private void releasePopup() {
        this.removePopup();
        this.editor.getXMLDocument().resetCompletionMode(false);
        this.editor.requestFocus();
        this.editor = null;
        this.asynchronousHelper.dispose();
        this.asynchronousHelper = null;
    }

    public void dispose() {
        try {
            ((NoSelectionAction)list.getActionMap().get("noSelection")).dispose();
            ((SelectionAction)list.getActionMap().get("itemSelection")).dispose();
            list.getActionMap().remove("noSelection");
            list.getActionMap().remove("itemSelection");
            this.editor = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected ListCellRenderer getListCellRenderer() {
        return null;
    }

    protected void fillList(SimpleNode simpleNode, DefaultListModel defaultListModel) {
    }

    protected void prepareDocumentBeforeInserting(XMLDocument xMLDocument, int n) {
    }

    protected void insertResult(XMLDocument xMLDocument, int n, String string, Descriptor descriptor, String string2) {
        xMLDocument.insertStringWithoutHelper(n, string, null);
    }

    class NewHelperContext
    extends HelperUIContext {
        NewHelperContext() {
        }

        public void close() {
            ((NoSelectionAction)list.getActionMap().get("noSelection")).actionPerformed(null);
        }
    }

    class AsynchronousShowHelper
    implements ActionListener,
    KeyListener,
    MouseListener,
    MouseMotionListener {
        private int ioffset;
        private int offset;
        private int x;
        private int y;
        StringBuffer completionBuffer = null;
        boolean resizeMode = false;
        int xr = 0;
        int yr = 0;
        int ir = 0;
        int jr = 0;

        public AsynchronousShowHelper(int n, int n2, int n3) {
            this.offset = n;
            this.ioffset = n;
            this.x = n2;
            this.y = n3;
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.resizeMode) {
                int n = mouseEvent.getX() - this.xr;
                int n2 = mouseEvent.getY() - this.yr;
                if (n != 0 || n2 != 0) {
                    WIN.setSize(WIN.getWidth() + n, WIN.getHeight() + n2);
                    this.xr = mouseEvent.getX();
                    this.yr = mouseEvent.getY();
                    AbstractHelper.this.editor.getXMLContainer().setProperty("dxHelper", new Integer(this.xr - this.ir));
                    AbstractHelper.this.editor.getXMLContainer().setProperty("dyHelper", new Integer(this.yr - this.jr));
                }
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            list.getActionMap().get("itemSelection").actionPerformed(null);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (n > list.getWidth() - 10 && n2 > list.getHeight() - 10) {
                this.resizeMode = true;
                this.xr = n;
                this.yr = n2;
                this.ir = n;
                this.jr = n2;
            } else {
                this.resizeMode = false;
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.resizeMode) {
                WIN.invalidate();
                WIN.validate();
                WIN.repaint();
            }
            this.resizeMode = false;
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 127 || keyEvent.getKeyCode() == 65483 || keyEvent.getKeyCode() == 12 || keyEvent.getKeyCode() == 8) {
                if (this.completionBuffer.length() > 0) {
                    this.completionBuffer.deleteCharAt(this.completionBuffer.length() - 1);
                    if (AbstractHelper.this.charToInsert == null) {
                        XMLDocument xMLDocument = AbstractHelper.this.editor.getXMLDocument();
                        xMLDocument.removeWithoutStructureDamaged(this.offset - 1, 1);
                    }
                    if (this.offset > 0) {
                        --this.offset;
                    }
                }
            } else if (keyEvent.getKeyChar() >= 'a' && keyEvent.getKeyChar() <= 'z' || keyEvent.getKeyChar() >= 'A' && keyEvent.getKeyChar() <= 'Z' || keyEvent.getKeyChar() >= '0' && keyEvent.getKeyChar() <= '9' || keyEvent.getKeyChar() == ':' || keyEvent.getKeyChar() == '_') {
                if (AbstractHelper.this.charToInsert == null) {
                    XMLDocument xMLDocument = AbstractHelper.this.editor.getXMLDocument();
                    xMLDocument.insertStringWithoutStructureDamaged(this.offset, "" + keyEvent.getKeyChar(), null);
                    ++this.offset;
                }
                this.completionBuffer.append(keyEvent.getKeyChar());
            } else {
                return;
            }
            this.synchronizeCompletionList();
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        private void synchronizeCompletionList() {
            DefaultListModel defaultListModel = (DefaultListModel)list.getModel();
            defaultListModel.removeAllElements();
            AbstractHelper.this.fillList(AbstractHelper.this.editor.getCurrentNodeLocation(), defaultListModel);
            if (this.completionBuffer != null && this.completionBuffer.length() > 0) {
                int n;
                String string = this.completionBuffer.toString();
                ArrayList<Descriptor> arrayList = null;
                for (n = 0; n < defaultListModel.getSize(); ++n) {
                    Descriptor descriptor = (Descriptor)defaultListModel.get(n);
                    if (descriptor.getNameForHelper().startsWith(string)) continue;
                    if (arrayList == null) {
                        arrayList = new ArrayList<Descriptor>();
                    }
                    arrayList.add(descriptor);
                }
                if (arrayList != null) {
                    for (n = 0; n < arrayList.size(); ++n) {
                        defaultListModel.removeElement(arrayList.get(n));
                    }
                }
            }
            if (defaultListModel.getSize() == 0) {
                titleLabel.setTitle("No completion");
            } else {
                titleLabel.setTitle(AbstractHelper.this.getTitle());
            }
            list.setSelectedIndex(0);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            int n2;
            Serializable serializable;
            Object object;
            Object object2;
            Point point;
            this.completionBuffer = ((XMLDocument)AbstractHelper.this.editor.getDocument()).getCompletionBuffer();
            if (this.completionBuffer != null) {
                this.offset += this.completionBuffer.length();
            }
            if (WIN == null) {
                point = null;
                WIN = new JPanel();
                list = new JList(){

                    public void setSelectedIndex(int n) {
                        super.setSelectedIndex(n);
                        this.ensureIndexIsVisible(n);
                    }
                };
                list.addFocusListener(new HidePopupOnFocusLost());
                list.setModel(new DefaultListModel());
                WIN.setLayout(new BorderLayout());
                WIN.add(new JScrollPane(list));
                WIN.add((Component)(titleLabel = ComponentFactory.getFactory().getNewTitledPanelHelper()).getView(), "North");
                if (titleLabel.getContext() != null) {
                    titleLabel.getContext().setDelegate(new NewHelperContext());
                }
                ListCellRenderer listCellRenderer = AbstractHelper.this.getListCellRenderer();
                object2 = "xmlpad.helper.";
                object = UIManager.getColor((String)object2 + "backgroundColor");
                if (object != null) {
                    list.setBackground((Color)object);
                }
                if ((object = UIManager.getColor((String)object2 + "foregroundColor")) != null) {
                    list.setForeground((Color)object);
                }
                if ((object = UIManager.getColor((String)object2 + "selectionBackgroundColor")) != null) {
                    list.setSelectionBackground((Color)object);
                }
                if ((object = UIManager.getColor((String)object2 + "selectionForegroundColor")) != null) {
                    list.setSelectionForeground((Color)object);
                }
                if ((serializable = UIManager.getFont((String)object2 + "font")) != null) {
                    list.setFont((Font)serializable);
                } else {
                    serializable = list.getFont();
                }
                titleLabel.getView().setFont(new Font(((Font)serializable).getName(), 2, ((Font)serializable).getSize()));
                titleLabel.getView().setOpaque(true);
                titleLabel.getView().setBackground(list.getSelectionBackground());
                titleLabel.getView().setForeground(list.getSelectionForeground());
                titleLabel.getView().setBorder(new EtchedBorder(list.getSelectionForeground(), list.getSelectionBackground()));
                list.setCellRenderer(CommonDescriptorRenderer.getRenderer());
            }
            point = AbstractHelper.this.editor.getLocationOnScreen();
            this.synchronizeCompletionList();
            if (list.getModel().getSize() > 0) {
                for (n2 = 0; n2 < list.getModel().getSize(); ++n2) {
                    object2 = (Descriptor)list.getModel().getElementAt(n2);
                    if (!(object2 instanceof TagDescriptor)) continue;
                    object = (TagDescriptor)object2;
                    for (int i = 0; i < ((TagDescriptor)object).getSynonymousTagDescriptorCount(); ++i) {
                        ((DefaultListModel)list.getModel()).add(n2 + 1, ((TagDescriptor)object).getSynonymousTagDescriptor(i));
                    }
                }
                n2 = 0;
                for (n = 0; n < list.getModel().getSize(); ++n) {
                    object = (Descriptor)list.getModel().getElementAt(n);
                    if (!object.isEnabled()) continue;
                    n2 = n;
                    break;
                }
            } else {
                AbstractHelper.this.releasePopup();
                this.dispose();
                return;
            }
            list.setSelectedIndex(n2);
            AbstractHelper.this.editor.add(WIN);
            n2 = (Integer)AbstractHelper.this.editor.getXMLContainer().getProperty("dxHelper", new Integer(0));
            n = (Integer)AbstractHelper.this.editor.getXMLContainer().getProperty("dyHelper", new Integer(0));
            WIN.setSize(list.getPreferredSize().width + 30 + n2, 100 + n);
            if (WIN.getWidth() < 20 && WIN.getHeight() < 20) {
                WIN.setSize(list.getPreferredSize().width + 30, 100);
            }
            WIN.doLayout();
            int n3 = this.y;
            this.x += AbstractHelper.this.editor.getFontMetrics(AbstractHelper.this.editor.getFont()).charWidth(' ');
            serializable = AbstractHelper.this.editor.getVisibleRect();
            if (WIN.getHeight() + n3 > ((Rectangle)serializable).y + ((Rectangle)serializable).height) {
                n3 = ((Rectangle)serializable).y + ((Rectangle)serializable).height - WIN.getHeight();
            }
            if (WIN.getWidth() + this.x > ((Rectangle)serializable).x + ((Rectangle)serializable).width) {
                this.x = ((Rectangle)serializable).x + ((Rectangle)serializable).width - WIN.getWidth();
            }
            WIN.setLocation(this.x, n3);
            list.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "itemSelection");
            list.getActionMap().put("itemSelection", new SelectionAction());
            list.getInputMap().put(KeyStroke.getKeyStroke(27, 0), "noSelection");
            list.getInputMap().put(KeyStroke.getKeyStroke(32, 0), "noSelection");
            list.getActionMap().put("noSelection", new NoSelectionAction(this.offset));
            AbstractHelper.this.editor.invalidate();
            AbstractHelper.this.editor.validate();
            titleLabel.setTitle(AbstractHelper.this.getTitle());
            list.addKeyListener(this);
            list.addMouseListener(this);
            list.addMouseMotionListener(this);
            WIN.setVisible(true);
            list.requestFocus();
        }

        private void dispose() {
            this.completionBuffer = null;
            list.removeKeyListener(this);
            list.removeMouseListener(this);
            list.removeMouseMotionListener(this);
            if (AbstractHelper.this.t != null) {
                AbstractHelper.this.t.stop();
                AbstractHelper.this.t.removeActionListener(AbstractHelper.this.asynchronousHelper);
            }
        }
    }

    class NoSelectionAction
    extends AbstractAction {
        int offset;

        public NoSelectionAction(int n) {
            this.offset = n;
        }

        public void dispose() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AbstractHelper.this.releasePopup();
        }
    }

    class SelectionAction
    extends AbstractAction {
        SelectionAction() {
        }

        public void dispose() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            XMLDocument xMLDocument = AbstractHelper.this.editor.getXMLDocument();
            String string = "";
            if (((AbstractHelper)AbstractHelper.this).asynchronousHelper.completionBuffer != null) {
                string = ((AbstractHelper)AbstractHelper.this).asynchronousHelper.completionBuffer.toString();
            }
            String string2 = null;
            if (list.getModel().getSize() > 0) {
                Descriptor descriptor = (Descriptor)list.getSelectedValue();
                string2 = descriptor.toExternalForm();
                string2 = string.length() >= string2.length() ? "" : string2.substring(string.length());
                if (AbstractHelper.this.charToInsert != null) {
                    string2 = AbstractHelper.this.charToInsert + string + string2;
                    AbstractHelper.this.asynchronousHelper.offset--;
                }
                AbstractHelper.this.prepareDocumentBeforeInserting(xMLDocument, AbstractHelper.this.asynchronousHelper.offset);
                AbstractHelper.this.insertResult(xMLDocument, AbstractHelper.this.asynchronousHelper.offset, string2, descriptor, string);
                if (!descriptor.isRaw()) {
                    int n = string2.indexOf("\"");
                    if (n > -1) {
                        xMLDocument.getCurrentEditor().setCaretPosition(AbstractHelper.this.asynchronousHelper.offset + n + 1);
                    } else {
                        n = string2.indexOf("><");
                        if (n > -1) {
                            xMLDocument.getCurrentEditor().setCaretPosition(AbstractHelper.this.asynchronousHelper.offset + n + 1);
                        }
                    }
                } else {
                    int n = string2.indexOf(" ");
                    if (n > -1) {
                        xMLDocument.getCurrentEditor().setCaretPosition(AbstractHelper.this.asynchronousHelper.offset + n + 1);
                    }
                }
            }
            AbstractHelper.this.releasePopup();
        }
    }

    class HidePopupOnFocusLost
    extends FocusAdapter {
        HidePopupOnFocusLost() {
        }

        public void focusLost(FocusEvent focusEvent) {
            if (AbstractHelper.this.editor != null) {
                try {
                    AbstractHelper.this.releasePopup();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }
}

