/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xmlpad.helper.handler.relaxng;

import com.japisoft.fastparser.node.SimpleNode;
import com.japisoft.fastparser.walker.AndCriteria;
import com.japisoft.fastparser.walker.AttributeCriteria;
import com.japisoft.fastparser.walker.NodeNameCriteria;
import com.japisoft.fastparser.walker.OrCriteria;
import com.japisoft.fastparser.walker.TreeWalker;
import com.japisoft.xmlpad.helper.model.AttDescriptor;
import com.japisoft.xmlpad.helper.model.SchemaNode;
import com.japisoft.xmlpad.helper.model.SchemaNodeProducer;
import com.japisoft.xmlpad.helper.model.TagDescriptor;
import java.util.ArrayList;
import java.util.Enumeration;

public class RelaxNGToSchemaNode
implements SchemaNodeProducer {
    public SchemaNode getSchemaNode(Object object) {
        SimpleNode simpleNode = (SimpleNode)object;
        SchemaNode schemaNode = new SchemaNode(2);
        if (simpleNode.childCount() > 0) {
            this.processRNG(schemaNode, simpleNode);
        }
        return schemaNode;
    }

    private void processRNG(SchemaNode schemaNode, SimpleNode simpleNode) {
        TreeWalker treeWalker = new TreeWalker(simpleNode);
        Enumeration enumeration = treeWalker.getNodeByCriteria(new OrCriteria(new NodeNameCriteria("element"), new NodeNameCriteria("ref")), true);
        SchemaNode schemaNode2 = new SchemaNode(3);
        while (enumeration.hasMoreElements()) {
            ArrayList<SimpleNode> arrayList = new ArrayList<SimpleNode>();
            SimpleNode simpleNode2 = (SimpleNode)enumeration.nextElement();
            if (simpleNode2.matchContent("ref")) {
                this.processRef(new ArrayList(), simpleNode2, arrayList);
            } else {
                arrayList.add(simpleNode2);
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                SimpleNode simpleNode3 = (SimpleNode)arrayList.get(i);
                String string = RelaxNGToSchemaNode.getName(simpleNode3);
                if (string == null) continue;
                TagDescriptor tagDescriptor = new TagDescriptor(string, false);
                SchemaNode schemaNode3 = new SchemaNode(tagDescriptor);
                this.processContentAndAttributes(tagDescriptor, simpleNode3);
                schemaNode2.addNext(schemaNode3);
            }
        }
        if (schemaNode2.getSchemaNodeCount() > 0) {
            schemaNode2.addNext(schemaNode2);
            schemaNode.addNext(schemaNode2);
        }
    }

    void processContentAndAttributes(TagDescriptor tagDescriptor, SimpleNode simpleNode) {
        for (int i = 0; i < simpleNode.childCount(); ++i) {
            Object object;
            SimpleNode simpleNode2 = simpleNode.childAt(i);
            if (simpleNode2.matchContent("empty")) {
                tagDescriptor.setEmpty(true);
                continue;
            }
            if (simpleNode2.matchContent("optional")) {
                if (simpleNode2.childCount() > 0 && simpleNode2.childAt(0).matchContent("attribute")) {
                    simpleNode2 = simpleNode2.childAt(0);
                }
            } else if (simpleNode2.matchContent("ref")) {
                object = this.getDefineNodeFromRefNode(simpleNode2);
                this.processContentAndAttributes(tagDescriptor, (SimpleNode)object);
            }
            if (!simpleNode2.matchContent("attribute") || (object = RelaxNGToSchemaNode.getName(simpleNode2)) == null) continue;
            AttDescriptor attDescriptor = new AttDescriptor((String)object, simpleNode2.getAttribute("defaultValue"), !simpleNode2.getSimpleParent().matchContent("optional"));
            tagDescriptor.addAttDescriptor(attDescriptor);
            if (simpleNode2.childCount() <= 0 || !simpleNode2.childAt(0).matchContent("choice")) continue;
            SimpleNode simpleNode3 = simpleNode2.childAt(0);
            for (int j = 0; j < simpleNode3.childCount(); ++j) {
                SimpleNode simpleNode4 = simpleNode3.childAt(j);
                if (!simpleNode4.matchContent("value") || simpleNode4.childCount() <= 0) continue;
                String string = simpleNode4.childAt(0).getContent();
                attDescriptor.addEnumValue(string);
                if (!"".equals(attDescriptor.getDefaultValue())) continue;
                attDescriptor.setDefaultValue(string);
            }
        }
    }

    static String getName(SimpleNode simpleNode) {
        SimpleNode simpleNode2;
        String string = simpleNode.getAttribute("name");
        if (string != null) {
            return string;
        }
        if (simpleNode.childCount() > 0 && (simpleNode2 = simpleNode.childAt(0)).matchContent("name") && simpleNode2.childCount() > 0) {
            return simpleNode2.childAt(0).getContent();
        }
        return null;
    }

    private SimpleNode getDefineNodeFromRefNode(SimpleNode simpleNode) {
        TreeWalker treeWalker = new TreeWalker((SimpleNode)simpleNode.getDocument().getRoot());
        String string = RelaxNGToSchemaNode.getName(simpleNode);
        if (string == null) {
            return null;
        }
        SimpleNode simpleNode2 = treeWalker.getOneNodeByCriteria(new AndCriteria(new NodeNameCriteria("define"), new AttributeCriteria("name", string)), false);
        return simpleNode2;
    }

    private void processRef(ArrayList arrayList, SimpleNode simpleNode, ArrayList arrayList2) {
        SimpleNode simpleNode2 = this.getDefineNodeFromRefNode(simpleNode);
        if (simpleNode2 == null) {
            return;
        }
        if (!arrayList.contains(simpleNode2)) {
            arrayList.add(simpleNode2);
            TreeWalker treeWalker = new TreeWalker(simpleNode2);
            Enumeration enumeration = treeWalker.getNodeByCriteria(new OrCriteria(new NodeNameCriteria("element"), new NodeNameCriteria("ref")), true);
            while (enumeration.hasMoreElements()) {
                SimpleNode simpleNode3 = (SimpleNode)enumeration.nextElement();
                boolean bl = true;
                for (SimpleNode simpleNode4 = simpleNode3.getSimpleParent(); simpleNode4 != null; simpleNode4 = simpleNode4.getSimpleParent()) {
                    if (simpleNode4.matchContent("element")) {
                        bl = false;
                        break;
                    }
                    if (simpleNode4.matchContent("define")) break;
                }
                if (!bl) continue;
                if (simpleNode3.matchContent("element")) {
                    arrayList2.add(simpleNode3);
                    continue;
                }
                this.processRef(arrayList, simpleNode3, arrayList2);
            }
        }
    }
}

