/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xmlpad.action.edit;

import com.japisoft.fastparser.node.SimpleNode;
import com.japisoft.xmlpad.XMLContainer;
import com.japisoft.xmlpad.action.XMLAction;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import javax.swing.JOptionPane;

public class CopyNodeAction
extends XMLAction {
    public static final String ID = CopyNodeAction.class.getName();

    protected boolean autoRequestFocus() {
        return false;
    }

    public static Point getNodeOffset(SimpleNode simpleNode) {
        if (simpleNode == null) {
            return null;
        }
        int n = simpleNode.getStartingOffset();
        int n2 = simpleNode.getStoppingOffset();
        if (simpleNode.isTag()) {
            ++n2;
        } else if (simpleNode.isText()) {
            --n2;
        }
        return new Point(n, n2);
    }

    public static boolean copyAction(XMLContainer xMLContainer, SimpleNode simpleNode) {
        Point point = CopyNodeAction.getNodeOffset(simpleNode);
        if (point == null) {
            JOptionPane.showMessageDialog(xMLContainer.getView(), "No Node Found", "Error", 0);
        }
        xMLContainer.getEditor().requestFocus();
        try {
            String string = xMLContainer.getDocument().getText(point.x, point.y - point.x + 1);
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringSelection stringSelection = new StringSelection(string);
            clipboard.setContents(stringSelection, null);
        }
        catch (Exception exception) {
            return INVALID_ACTION;
        }
        return VALID_ACTION;
    }

    public boolean notifyAction() {
        if (this.container.getTreeListeners() == null) {
            return INVALID_ACTION;
        }
        if (this.container.getTree() == null) {
            return INVALID_ACTION;
        }
        return CopyNodeAction.copyAction(this.container, this.container.getCurrentNode());
    }
}

