/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xmlpad.action;

import com.japisoft.xmlpad.SharedProperties;
import com.japisoft.xmlpad.XMLContainer;
import com.japisoft.xmlpad.action.Features;
import com.japisoft.xmlpad.action.Properties;
import com.japisoft.xmlpad.editor.XMLEditor;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import javax.swing.UIManager;

public abstract class XMLAction
extends AbstractAction
implements Features,
Properties {
    public static int IMAGE_SIZE = 16;
    public static String IMAGE_EXT = "gif";
    public static boolean RESOURCE_BUNDLE = SharedProperties.LOCALIZED_MESSAGE;
    public static boolean AUTO_UI = true;
    public static boolean VALID_ACTION = true;
    public static boolean INVALID_ACTION = false;
    protected String groupName;
    protected XMLEditor editor;
    private String actionReference;
    private boolean popable = true;
    private boolean toolbarable = true;
    private ResourceBundle resource = null;
    protected XMLContainer container;
    private Action delegate;
    protected Object param = null;
    private Hashtable htFeature;
    static EmptyIcon EMPTY_ICON = null;

    public XMLAction() {
        this.installUIContent();
    }

    public void dispose() {
        this.editor = null;
        this.container = null;
    }

    public XMLAction(String string) {
        this.setActionReferenceIcon(string);
    }

    public void setActionReferenceIcon(String string) {
        this.actionReference = string;
        this.installUIContent();
    }

    public void setActionReferenceGroup(String string) {
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(string);
            this.groupName = resourceBundle.getString("GROUP");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setPopable(boolean bl) {
        this.popable = bl;
    }

    public boolean isPopable() {
        return this.popable;
    }

    public void setToolbarable(boolean bl) {
        this.toolbarable = bl;
    }

    public boolean isToolbarable() {
        return this.toolbarable;
    }

    protected void installUIContent() {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        Icon icon;
        block30: {
            if (!AUTO_UI) {
                return;
            }
            icon = this.getDefaultIcon();
            string5 = this.getDefaultLabel();
            string4 = this.getDefaultTooltip();
            KeyStroke keyStroke = this.getDefaultAccelerator();
            string3 = null;
            if (keyStroke != null) {
                this.putValue("AcceleratorKey", keyStroke);
            }
            char c = this.getDefaultMnemonic();
            string2 = null;
            if (c > '\u0000') {
                string2 = "" + c;
            }
            try {
                if (!RESOURCE_BUNDLE) break block30;
                this.resource = ResourceBundle.getBundle(this.getName());
                if (this.resource == null) break block30;
                try {
                    string5 = this.resource.getString("LABEL");
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
                try {
                    string4 = this.resource.getString("TOOLTIP");
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
                try {
                    string2 = this.resource.getString("MNEMONIC");
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
                try {
                    string3 = this.resource.getString("ACCELERATOR");
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
                try {
                    this.groupName = this.resource.getString("GROUP");
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
                try {
                    icon = new ImageIcon(ClassLoader.getSystemClassLoader().getResource(this.resource.getString("ICON")));
                }
                catch (Throwable throwable) {}
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (UIManager.getString((string = "xmlpad.action." + this.getClass().getName() + ".") + "mnemonic") != null) {
            string2 = UIManager.getString(string + "mnemonic");
        }
        if (UIManager.getString(string + "accelerator") != null) {
            string3 = UIManager.getString(string + "accelerator");
        }
        if (UIManager.getString(string + "label") != null) {
            string5 = UIManager.getString(string + "label");
        }
        if (UIManager.getString(string + "tooltip") != null) {
            string4 = UIManager.getString(string + "tooltip");
        }
        if (UIManager.getIcon(string + "icon") != null) {
            icon = UIManager.getIcon(string + "icon");
        }
        if (string2 != null) {
            this.putValue("MnemonicKey", new Integer(string2.charAt(0)));
        }
        if (string3 != null) {
            if (string3.length() > 1 && string3.startsWith("*")) {
                char c = string3.charAt(string3.length() - 1);
                boolean bl = string3.indexOf("shift ") > 0;
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke((int)c, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | (bl ? 1 : 0)));
            }
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(string3));
        }
        if (string5 != null) {
            this.putValue("Name", string5);
        }
        if (string4 != null) {
            this.putValue("ShortDescription", string4);
        }
        if (icon != null) {
            this.putValue("SmallIcon", icon);
        } else {
            if (EMPTY_ICON == null) {
                EMPTY_ICON = new EmptyIcon();
            }
            this.putValue("SmallIcon", EMPTY_ICON);
        }
    }

    protected Icon getDefaultIcon() {
        String string = this.getClass().getName();
        if (this.actionReference != null) {
            string = this.actionReference;
        }
        string = string.replace('.', '/');
        string = string + IMAGE_SIZE + "." + IMAGE_EXT;
        try {
            return new ImageIcon(this.getClass().getClassLoader().getResource(string));
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    protected String getDefaultLabel() {
        String string = this.getName();
        int n = string.lastIndexOf(46);
        if (n > -1) {
            string = string.substring(n + 1);
        }
        if (string.endsWith("Action")) {
            string = string.substring(0, string.length() - 6);
        }
        return string;
    }

    protected String getDefaultTooltip() {
        return null;
    }

    protected char getDefaultMnemonic() {
        return '\u0000';
    }

    protected KeyStroke getDefaultAccelerator() {
        return null;
    }

    public String getPopupGroup() {
        return this.groupName;
    }

    public void setXMLEditor(XMLEditor xMLEditor) {
        this.editor = xMLEditor;
        if (xMLEditor != null) {
            this.notifyXMLEditor();
        }
    }

    public XMLEditor getXMLEditor() {
        return this.editor;
    }

    protected void notifyXMLEditor() {
    }

    public void setXMLContainer(XMLContainer xMLContainer) {
        this.container = xMLContainer;
        if (xMLContainer != null) {
            this.notifyXMLContainer();
        }
    }

    public XMLContainer getXMLContainer() {
        return this.container;
    }

    protected void notifyXMLContainer() {
    }

    protected boolean autoRequestFocus() {
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.editor != null) {
            if (this.delegate != null) {
                this.delegate.putValue("XMLCONTAINER", this.container);
                this.delegate.actionPerformed(actionEvent);
                this.delegate.putValue("XMLCONTAINER", null);
            } else {
                this.notifyAction();
                if (this.autoRequestFocus()) {
                    this.container.requestFocus();
                }
            }
        }
    }

    public void setActionDelegate(Action action) {
        this.delegate = action;
    }

    public abstract boolean notifyAction();

    public String getName() {
        return this.getClass().getName();
    }

    public void setParam(Object object) {
        this.param = object;
    }

    public Object getParam() {
        return this.param;
    }

    public void setFeature(String string, boolean bl) {
        if (this.htFeature == null) {
            this.htFeature = new Hashtable();
        }
        this.htFeature.put(string, new Boolean(bl));
    }

    public boolean hasFeature(String string) {
        if (this.htFeature == null) {
            return false;
        }
        if (this.htFeature.containsKey(string)) {
            return (Boolean)this.htFeature.get(string);
        }
        return false;
    }

    public Object getProperty(String string, Object object) {
        return object;
    }

    public void setProperty(String string, Object object) {
    }

    public static class EmptyIcon
    implements Icon {
        private final int height;
        private final int width;

        public EmptyIcon() {
            this.height = IMAGE_SIZE;
            this.width = IMAGE_SIZE;
        }

        public EmptyIcon(Dimension dimension) {
            this.height = dimension.height;
            this.width = dimension.width;
        }

        public EmptyIcon(int n, int n2) {
            this.height = n;
            this.width = n2;
        }

        public int getIconHeight() {
            return this.height;
        }

        public int getIconWidth() {
            return this.width;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        }
    }
}

