/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xmlpad.action;

import com.japisoft.xmlpad.XMLContainer;
import com.japisoft.xmlpad.XMLPadProperties;
import com.japisoft.xmlpad.action.ActionGroup;
import com.japisoft.xmlpad.action.ActionSet;
import com.japisoft.xmlpad.action.ActivateOnSelection;
import com.japisoft.xmlpad.action.XMLAction;
import com.japisoft.xmlpad.editor.XMLEditor;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;

public class ActionModel
implements ActionSet {
    private static Vector model;
    public static String FILE_GROUP;
    public static String EDIT_GROUP;
    public static String SEARCH_GROUP;
    public static String XML_GROUP;
    public static String OTHER_GROUP;
    public static String TREE_GROUP;
    public static String TOOLKIT_GROUP;
    static boolean enabledAutoResetActionState;

    public static void buildToolBar(JToolBar jToolBar) {
        Enumeration enumeration = ActionModel.getGroups();
        while (enumeration.hasMoreElements()) {
            ActionGroup actionGroup = (ActionGroup)enumeration.nextElement();
            boolean bl = false;
            for (int i = 0; i < actionGroup.size(); ++i) {
                Action action = (Action)actionGroup.get(i);
                if (action instanceof XMLAction && !((XMLAction)action).isToolbarable()) continue;
                jToolBar.add(action);
                bl = true;
            }
            if (!enumeration.hasMoreElements() || !bl) continue;
            jToolBar.addSeparator();
        }
    }

    public static void buildPopupMenu(JPopupMenu jPopupMenu) {
        Enumeration enumeration = ActionModel.getGroups();
        while (enumeration.hasMoreElements()) {
            ActionGroup actionGroup = (ActionGroup)enumeration.nextElement();
            boolean bl = false;
            for (int i = 0; i < actionGroup.size(); ++i) {
                Action action = (Action)actionGroup.get(i);
                if (action instanceof XMLAction && !((XMLAction)action).isPopable()) continue;
                jPopupMenu.add(action);
                bl = true;
            }
            if (!enumeration.hasMoreElements() || !bl) continue;
            jPopupMenu.addSeparator();
        }
    }

    public static void setEnabledAutoResetActionState(boolean bl) {
        enabledAutoResetActionState = bl;
    }

    public static void setIconForAction(String string, Icon icon) {
        Action action = ActionModel.getActionByName(string);
        if (action != null) {
            action.putValue("SmallIcon", icon);
        }
    }

    public static void resetActionState(XMLEditor xMLEditor, XMLContainer xMLContainer) {
        if (!enabledAutoResetActionState) {
            return;
        }
        for (int i = 0; i < model.size(); ++i) {
            ((ActionGroup)model.get(i)).resetActionState(xMLEditor, xMLContainer);
        }
    }

    public static void resetActionState(XMLContainer xMLContainer) {
        if (!enabledAutoResetActionState) {
            return;
        }
        for (int i = 0; i < model.size(); ++i) {
            if (xMLContainer != null) {
                ((ActionGroup)model.get(i)).resetActionState(xMLContainer.getEditor(), xMLContainer);
                continue;
            }
            ((ActionGroup)model.get(i)).resetActionState(null, null);
        }
    }

    public static void addGroup(ActionGroup actionGroup) {
        model.add(actionGroup);
    }

    public static boolean hasGroup(String string) {
        for (int i = 0; i < model.size(); ++i) {
            ActionGroup actionGroup;
            if (!(model.get(i) instanceof ActionGroup) || !string.equals((actionGroup = (ActionGroup)model.get(i)).getName())) continue;
            return true;
        }
        return false;
    }

    public static void removeGroup(ActionGroup actionGroup) {
        model.remove(actionGroup);
    }

    public static ActionGroup getGroupByName(String string) {
        for (int i = 0; i < model.size(); ++i) {
            ActionGroup actionGroup = (ActionGroup)model.get(i);
            if (!actionGroup.getName().equals(string)) continue;
            return actionGroup;
        }
        return null;
    }

    public static void addActionForGroup(String string, XMLAction xMLAction) {
        for (int i = 0; i < model.size(); ++i) {
            ActionGroup actionGroup = (ActionGroup)model.get(i);
            if (!string.equals(actionGroup.getName())) continue;
            actionGroup.addAction(xMLAction);
            return;
        }
        ActionModel.addGroup(new ActionGroup(string));
        ActionModel.addActionForGroup(string, xMLAction);
    }

    public static void addActionForGroup(String string, String string2) throws ClassNotFoundException {
        try {
            ActionModel.addActionForGroup(string, (XMLAction)Class.forName(string2).newInstance());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new ClassNotFoundException("Can't load " + string2);
        }
    }

    public static void removeActionForGroup(String string, XMLAction xMLAction) {
        for (int i = 0; i < model.size(); ++i) {
            ActionGroup actionGroup = (ActionGroup)model.get(i);
            if (!string.equals(actionGroup.getName())) continue;
            actionGroup.removeAction(xMLAction);
            return;
        }
    }

    public static void removeActionByName(String string) {
        for (int i = 0; i < model.size(); ++i) {
            if (!(model.get(i) instanceof ActionGroup)) continue;
            ActionGroup actionGroup = (ActionGroup)model.get(i);
            actionGroup.removeAction(string);
        }
    }

    public static Action getActionByName(String string) {
        for (int i = 0; i < model.size(); ++i) {
            ActionGroup actionGroup = (ActionGroup)model.get(i);
            Action action = actionGroup.getActionByName(string);
            if (action == null) continue;
            return action;
        }
        return null;
    }

    public static void replaceActionByName(String string, Action action) {
        for (int i = 0; i < model.size(); ++i) {
            ActionGroup actionGroup = (ActionGroup)model.get(i);
            Action action2 = actionGroup.getActionByName(string);
            if (action2 == null) continue;
            int n = actionGroup.indexOf(action2);
            actionGroup.set(n, action);
            break;
        }
    }

    public static void setEnabledAction(String string, boolean bl) {
        Action action = ActionModel.getActionByName(string);
        if (action != null) {
            action.setEnabled(bl);
        }
    }

    public static boolean isEnabledAction(String string) {
        Action action = ActionModel.getActionByName(string);
        if (action == null) {
            return false;
        }
        return action.isEnabled();
    }

    public static boolean activeActionByName(String string) {
        Action action = ActionModel.getActionByName(string);
        if (action != null) {
            if (action instanceof XMLAction) {
                return ((XMLAction)action).notifyAction();
            }
            action.actionPerformed(null);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean activeActionByName(String string, XMLContainer xMLContainer, XMLEditor xMLEditor) {
        Action action = ActionModel.getActionByName(string);
        if (action instanceof XMLAction) {
            boolean bl = false;
            XMLAction xMLAction = (XMLAction)action;
            XMLContainer xMLContainer2 = xMLAction.getXMLContainer();
            XMLEditor xMLEditor2 = xMLAction.getXMLEditor();
            try {
                xMLAction.setXMLContainer(xMLContainer);
                xMLAction.setXMLEditor(xMLEditor);
                bl = xMLAction.notifyAction();
            }
            finally {
                xMLAction.setXMLContainer(xMLContainer2);
                xMLAction.setXMLEditor(xMLEditor2);
            }
            return bl;
        }
        if (action != null) {
            action.actionPerformed(null);
            return true;
        }
        return false;
    }

    public static void activeActionForSelection(boolean bl) {
        for (int i = 0; i < model.size(); ++i) {
            ActionGroup actionGroup = (ActionGroup)model.get(i);
            for (int j = 0; j < actionGroup.size(); ++j) {
                Action action = (Action)actionGroup.get(j);
                if (!(action instanceof ActivateOnSelection)) continue;
                action.setEnabled(bl);
            }
        }
    }

    public static Enumeration getGroups() {
        return model.elements();
    }

    public static void setFeature(String string, String string2, boolean bl) {
        Action action = ActionModel.getActionByName(string);
        if (action instanceof XMLAction) {
            ((XMLAction)action).setFeature(string2, bl);
        }
    }

    public static boolean hasFeature(String string, String string2) {
        Action action = ActionModel.getActionByName(string);
        if (action == null) {
            return false;
        }
        if (action instanceof XMLAction) {
            return ((XMLAction)action).hasFeature(string2);
        }
        return false;
    }

    public static void setParam(String string, Object object) {
        Action action = ActionModel.getActionByName(string);
        if (action instanceof XMLAction) {
            ((XMLAction)action).setParam(object);
        }
    }

    public static Object getParam(String string) {
        Action action = ActionModel.getActionByName(string);
        if (action instanceof XMLAction) {
            return ((XMLAction)action).getParam();
        }
        return null;
    }

    public static void setProperty(String string, String string2, Object object) {
        Action action = ActionModel.getActionByName(string);
        if (action instanceof XMLAction) {
            ((XMLAction)action).setProperty(string2, object);
        }
    }

    public static Object getProperty(String string, String string2, Object object) {
        Action action = ActionModel.getActionByName(string);
        if (action instanceof XMLAction) {
            return ((XMLAction)action).getProperty(string2, object);
        }
        return object;
    }

    public static void setIcon(String string, Icon icon) {
        Action action = ActionModel.getActionByName(string);
        if (action != null) {
            action.putValue("SmallIcon", icon);
        }
    }

    static {
        Object object;
        String string;
        String string2;
        model = new Vector();
        FILE_GROUP = "file";
        EDIT_GROUP = "edit";
        SEARCH_GROUP = "search";
        XML_GROUP = "xml";
        OTHER_GROUP = "other";
        TREE_GROUP = "tree";
        TOOLKIT_GROUP = "toolkit";
        Enumeration enumeration = XMLPadProperties.getProperties();
        Hashtable<String, ActionGroup> hashtable = new Hashtable<String, ActionGroup>();
        while (enumeration.hasMoreElements()) {
            int n;
            string2 = (String)enumeration.nextElement();
            if (!string2.startsWith("action.") || (n = string2.indexOf(".", 7)) <= -1) continue;
            string = string2.substring(7, n);
            object = string2.substring(n + 1);
            try {
                int n2 = Integer.parseInt((String)object) - 1;
                ActionGroup actionGroup = (ActionGroup)hashtable.get(string);
                if (actionGroup == null) {
                    actionGroup = new ActionGroup(string);
                    hashtable.put(string, actionGroup);
                }
                String string3 = XMLPadProperties.getProperty(string2, "");
                try {
                    Class<?> clazz = Class.forName(string3);
                    int n3 = n2;
                    while (actionGroup.size() - 1 < n3) {
                        actionGroup.add(null);
                    }
                    actionGroup.setElementAt(clazz.newInstance(), n2);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        string2 = XMLPadProperties.getProperty("groupOrder", "file,edit,search,xml");
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        while (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
            object = (ActionGroup)hashtable.get(string);
            if (object == null) continue;
            ActionModel.addGroup((ActionGroup)object);
        }
        if (model.size() == 0) {
            try {
                ActionModel.addActionForGroup(FILE_GROUP, NEW_ACTION);
                ActionModel.addActionForGroup(FILE_GROUP, LOAD_ACTION);
                ActionModel.addActionForGroup(FILE_GROUP, SAVE_ACTION);
                ActionModel.addActionForGroup(FILE_GROUP, SAVEAS_ACTION);
                ActionModel.addActionForGroup(FILE_GROUP, INSERT_ACTION);
                ActionModel.addActionForGroup(EDIT_GROUP, UNDO_ACTION);
                ActionModel.addActionForGroup(EDIT_GROUP, REDO_ACTION);
                ActionModel.addActionForGroup(EDIT_GROUP, CUT_ACTION);
                ActionModel.addActionForGroup(EDIT_GROUP, COPY_ACTION);
                ActionModel.addActionForGroup(EDIT_GROUP, PASTE_ACTION);
                ActionModel.addActionForGroup(SEARCH_GROUP, SEARCH_ACTION);
                ActionModel.addActionForGroup(XML_GROUP, PARSE_ACTION);
                ActionModel.addActionForGroup(XML_GROUP, FORMAT_ACTION);
                ActionModel.addActionForGroup(XML_GROUP, COMMENT_ACTION);
                ActionModel.addActionForGroup(OTHER_GROUP, SPLIT_ACTION);
                ActionModel.addActionForGroup(OTHER_GROUP, SPLIT_ACTION_HOR);
                ActionModel.addActionForGroup(TREE_GROUP, TREE_SELECTNODE_ACTION);
                ActionModel.addActionForGroup(TREE_GROUP, TREE_COMMENTNODE_ACTION);
                ActionModel.addActionForGroup(TREE_GROUP, TREE_CUTNODE_ACTION);
                ActionModel.addActionForGroup(TREE_GROUP, TREE_COPYNODE_ACTION);
                ActionModel.addActionForGroup(TREE_GROUP, TREE_PREVIOUS_ACTION);
                ActionModel.addActionForGroup(TREE_GROUP, TREE_NEXT_ACTION);
                ActionModel.addActionForGroup(TREE_GROUP, TREE_ADDHISTORY_ACTION);
                ActionModel.addActionForGroup(TREE_GROUP, TREE_CLEANHISTORY_ACTION);
                ActionModel.addActionForGroup(TREE_GROUP, TREE_EDITNODE_ACTION);
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
        }
        enabledAutoResetActionState = true;
    }
}

