/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xmlpad;

import com.japisoft.fastparser.node.SimpleNode;
import com.japisoft.xmlpad.SharedProperties;
import com.japisoft.xmlpad.XMLContainer;
import com.japisoft.xmlpad.bookmark.BookmarkModel;
import com.japisoft.xmlpad.bookmark.BookmarkPosition;
import com.japisoft.xmlpad.error.ErrorListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;

class ViewRowComponent
extends JComponent
implements MouseListener,
MouseMotionListener,
ErrorListener {
    XMLContainer container;
    private SimpleNode currentNode;
    int y1 = -1;
    int y2 = -1;
    Rectangle clickableZone = null;
    private ArrayList listOfErrors = null;
    private int errorLine = 0;
    private String errorMessage = null;
    private int extraWidth = 0;
    private int dynamicWidth = 0;

    public ViewRowComponent(XMLContainer xMLContainer) {
        this.container = xMLContainer;
    }

    void dispose() {
        this.container = null;
    }

    public Dimension getPreferredSize() {
        try {
            return new Dimension(this.extraWidth + 10 + (this.container.getBookmarkContext() != null ? this.container.getBookmarkContext().getIcon().getIconWidth() : 0), this.container.getEditor().getPreferredSize().height);
        }
        catch (NullPointerException nullPointerException) {
            return new Dimension(10 + this.extraWidth, this.container.getEditor().getPreferredSize().height);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n;
        int n2;
        Element element;
        Element element2;
        boolean bl = true;
        if (this.clickableZone != null && this.clickableZone.contains(mouseEvent.getX(), mouseEvent.getY())) {
            bl = false;
            if (this.errorMessage == null) {
                int n3 = 0;
                if (this.container.getCurrentElementNode() == null) {
                    return;
                }
                if (this.container.getCurrentElementNode().isTag()) {
                    ++n3;
                }
                this.container.getEditor().select(this.container.getCurrentElementNode().getStartingOffset(), this.container.getCurrentElementNode().getStoppingOffset() + n3);
            } else {
                this.container.getTreeListeners().notifiedErrorNonTemporary();
                this.container.getEditor().highlightLine(this.errorLine);
            }
        }
        if (bl && this.container.getBookmarkContext() != null && (element2 = (element = this.container.getDocument().getDefaultRootElement()).getElement(n2 = element.getElementIndex(n = this.container.getEditor().viewToModel(new Point(1, mouseEvent.getY()))))) != null) {
            try {
                BookmarkPosition bookmarkPosition = null;
                for (int i = 0; i < this.container.getBookmarkContext().getModel().getBookmarkCount(); ++i) {
                    BookmarkPosition bookmarkPosition2 = this.container.getBookmarkContext().getModel().getBookmarkPositionAt(i);
                    int n4 = element.getElementIndex(bookmarkPosition2.getOffset());
                    if (n4 != n2) continue;
                    bookmarkPosition = bookmarkPosition2;
                    break;
                }
                if (bookmarkPosition == null) {
                    Object object = this.container.getEditor().getHighlighter().addHighlight(element2.getStartOffset(), element2.getStartOffset(), this.container.getBookmarkContext().getHighlightPainter());
                    this.container.getBookmarkContext().getModel().addBookmarkPosition(new BookmarkPosition(this.container.getDocument().createPosition(element2.getStartOffset()), object));
                } else {
                    this.container.getEditor().getHighlighter().removeHighlight(bookmarkPosition.getHighlightFlag());
                    this.container.getBookmarkContext().getModel().removeBookmarkPosition(bookmarkPosition);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            this.repaint();
            this.container.getEditor().repaint();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.listOfErrors != null) {
            for (int i = 0; i < this.listOfErrors.size(); i += 2) {
                Rectangle rectangle = (Rectangle)this.listOfErrors.get(i);
                if (!rectangle.contains(mouseEvent.getX(), mouseEvent.getY())) continue;
                this.setToolTipText((String)this.listOfErrors.get(i + 1));
            }
        }
    }

    public void addNotify() {
        super.addNotify();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void removeNotify() {
        super.removeNotify();
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
    }

    public void setCurrentNode(SimpleNode simpleNode) {
        this.currentNode = simpleNode;
        this.clickableZone = null;
        if (simpleNode == null) {
            this.y1 = -1;
            this.y2 = -1;
        } else {
            this.y1 = 0;
            this.y2 = 0;
        }
    }

    public void initErrorProcessing() {
    }

    public void stopErrorProcessing() {
    }

    public void notifyError(Object object, boolean bl, String string, int n, int n2, int n3, String string2, boolean bl2) {
        if (bl) {
            if (n > 0) {
                if (this.listOfErrors == null) {
                    this.listOfErrors = new ArrayList();
                }
                FontMetrics fontMetrics = this.container.getEditor().getFontMetrics(this.container.getEditor().getFont());
                int n4 = n * fontMetrics.getHeight() + SharedProperties.getBugLittleIcon().getIconHeight() / 2;
                this.listOfErrors.add(new Rectangle(0, n4, 10, 10));
                this.listOfErrors.add(string2);
            }
            if (bl2) {
                this.showOneError(string2, n);
            }
        }
    }

    public void notifyNoError(boolean bl) {
        this.listOfErrors = null;
        this.unsetError();
    }

    private void unsetError() {
        this.showOneError(null, -1);
    }

    private void showOneError(String string, int n) {
        this.errorMessage = string;
        FontMetrics fontMetrics = this.container.getEditor().getFontMetrics(this.container.getEditor().getFont());
        this.errorLine = n * fontMetrics.getHeight();
        this.setToolTipText(this.errorMessage);
        this.repaint();
    }

    public void paintComponent(Graphics graphics) {
        int n;
        Rectangle rectangle;
        Object object;
        int n2;
        super.paintComponent(graphics);
        if (this.y1 == 0 && this.y2 == 0 && this.currentNode != null) {
            int n3 = this.currentNode.getStartingOffset();
            n2 = this.currentNode.getStoppingOffset();
            try {
                object = this.container.getEditor().modelToView(n3);
                rectangle = this.container.getEditor().modelToView(n2);
                JViewport jViewport = (JViewport)this.container.getEditor().getParent();
                this.y1 = ((Rectangle)object).y;
                this.y2 = rectangle.y + rectangle.height;
                n = (this.y2 - this.y1) / 2 + this.y1;
                Point point = jViewport.getViewPosition();
                if (n < point.y) {
                    n = point.y + 10;
                }
                if (n > point.y + jViewport.getHeight()) {
                    n = point.y + jViewport.getHeight() - 10;
                }
                this.clickableZone = new Rectangle(this.getWidth() - 7, n - 3, this.getWidth() - 6, 6);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            this.currentNode = null;
        }
        if (this.container.getBookmarkContext() != null) {
            BookmarkModel bookmarkModel = this.container.getBookmarkContext().getModel();
            for (n2 = 0; n2 < bookmarkModel.getBookmarkCount(); ++n2) {
                object = bookmarkModel.getBookmarkPositionAt(n2);
                try {
                    if (this.container.getBookmarkContext().getIcon() == null) continue;
                    rectangle = this.container.getEditor().modelToView(((BookmarkPosition)object).getOffset());
                    this.container.getBookmarkContext().getIcon().paintIcon(this, graphics, this.getWidth() - 20, rectangle.y);
                    continue;
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
        if (this.container.getEditor().getColorForTagBorderLine() != null) {
            graphics.setColor(this.container.getEditor().getColorForTagBorderLine());
        }
        graphics.drawLine(this.getWidth() - 4, this.y1, this.getWidth() - 4, this.y2);
        graphics.drawLine(this.getWidth() - 4, this.y1, this.getWidth() - 2, this.y1);
        graphics.drawLine(this.getWidth() - 4, this.y2, this.getWidth() - 2, this.y2);
        if (this.clickableZone != null) {
            if (this.errorMessage != null) {
                graphics.setColor(Color.red);
            } else {
                graphics.setColor(Color.LIGHT_GRAY);
            }
            graphics.fillRect(this.clickableZone.x, this.clickableZone.y, this.clickableZone.width, this.clickableZone.height);
        }
        if (this.listOfErrors != null) {
            for (int i = 0; i < this.listOfErrors.size(); i += 2) {
                Rectangle rectangle2 = (Rectangle)this.listOfErrors.get(i);
                SharedProperties.getBugLittleIcon().paintIcon(this, graphics, this.getWidth() - 6, rectangle2.y);
            }
        }
        if (SharedProperties.EDITOR_LINE_NUMBER && this.container.getEditor().getParent() instanceof JViewport) {
            graphics.setColor(Color.LIGHT_GRAY);
            JViewport jViewport = (JViewport)this.container.getEditor().getParent();
            Rectangle rectangle3 = this.container.getEditor().getVisibleRect();
            object = this.container.getEditor().getFontMetrics(this.container.getEditor().getFont());
            int n4 = ((FontMetrics)object).getHeight();
            int n5 = (int)Math.floor(rectangle3.y / n4) - 1;
            n = (rectangle3.y + rectangle3.height) / n4 + 1;
            int n6 = n5 * n4 - 2;
            int n7 = (int)Math.log10(n);
            if (n7 != this.dynamicWidth) {
                this.extraWidth = ((FontMetrics)object).stringWidth("" + n);
                this.revalidate();
                this.dynamicWidth = n7;
            }
            for (int i = n5; i <= n; ++i) {
                if (n6 >= this.y1 && n6 <= this.y2) {
                    graphics.setColor(Color.DARK_GRAY);
                } else {
                    graphics.setColor(Color.LIGHT_GRAY);
                }
                graphics.drawString("" + i, 1, n6);
                n6 += n4;
            }
        }
    }
}

