/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xmlpad;

import com.japisoft.xmlpad.DocumentStateListener;
import com.japisoft.xmlpad.IView;
import com.japisoft.xmlpad.IXMLPanel;
import com.japisoft.xmlpad.XMLContainer;
import com.japisoft.xmlpad.XMLDocumentInfo;
import com.japisoft.xmlpad.bookmark.BookmarkContext;
import java.awt.Color;
import java.awt.Graphics;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

class DefaultView
extends JPanel
implements IView,
IXMLPanel {
    private XMLContainer container;
    private boolean init = false;
    private boolean focusView = false;

    public DefaultView(XMLContainer xMLContainer) {
        this.container = xMLContainer;
    }

    public XMLContainer getMainContainer() {
        return this.container;
    }

    public XMLContainer getSelectedContainer() {
        return null;
    }

    public BookmarkContext getBookmarkContext() {
        return null;
    }

    public void setDocumentInfo(XMLDocumentInfo xMLDocumentInfo) {
        this.container.setDocumentInfo(xMLDocumentInfo);
    }

    public XMLContainer getSubContainer(String string) {
        return this.container.getSubContainer(string);
    }

    public JComponent getView() {
        return this.container.getView();
    }

    public void setProperty(String string, Object object) {
        this.container.setProperty(string, object);
    }

    public Object getProperty(String string) {
        return this.container.getProperty(string);
    }

    public Object getProperty(String string, Object object) {
        return this.container.getProperty(string, object);
    }

    public Iterator getProperties() {
        return this.container.getProperties();
    }

    public void addNotify() {
        super.addNotify();
        this.container.initOnce(this);
        this.container.addNotifyDone = true;
        this.container.setUIReady(true);
    }

    public void removeNotify() {
        super.removeNotify();
        if (this.container != null) {
            if (this.container.disposeMode) {
                this.container.dispose();
            }
            this.container.setUIReady(false);
        }
    }

    public void setFocusView(boolean bl) {
        this.focusView = bl;
        this.repaint();
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.focusView) {
            graphics.setColor(Color.blue);
            graphics.drawRect(1, 1, this.getWidth() - 2, this.getHeight() - 2);
        }
    }

    public void requestFocus() {
        if (this.container.getEditor() != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DefaultView.this.container.getEditor().requestFocusInWindow();
                }
            });
        } else {
            super.requestFocus();
        }
    }

    public Object[] getDocumentStateListeners() {
        Object[] objectArray = this.listenerList.getListeners(DocumentStateListener.class);
        return objectArray;
    }

    public void addDocumentStateListener(DocumentStateListener documentStateListener) {
        this.listenerList.add(DocumentStateListener.class, documentStateListener);
    }

    public void removeDocumentStateListener(DocumentStateListener documentStateListener) {
        this.listenerList.remove(DocumentStateListener.class, documentStateListener);
    }

    public void dispose() {
        if (this.container != null) {
            this.container.dispose();
        }
        this.container = null;
    }

    public XMLContainer getContainer() {
        return this.container;
    }

    public JComponent getFinalView() {
        return this;
    }

    public void setAutoDisposeMode(boolean bl) {
        this.container.setAutoDisposeMode(bl);
    }

    public void prepareToSave() {
    }

    public void postLoad() {
    }

    public boolean reload() {
        return this.container.reload();
    }

    public Action getAction(String string) {
        return this.container.getAction(string);
    }
}

