/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xmlform.designer.data;

import com.japisoft.framework.app.toolkit.Toolkit;
import com.japisoft.framework.ui.FastLabel;
import com.japisoft.framework.xml.grammar.GrammarNode;
import com.japisoft.xmlform.designer.data.GrammarNodeTreeNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.TreeCellRenderer;

public class DataTreeRenderer
implements TreeCellRenderer {
    private BoundImageIcon elementOpened = new BoundImageIcon(Toolkit.getImageIcon("images/folder.png"));
    private BoundImageIcon elementClosed = new BoundImageIcon(Toolkit.getImageIcon("images/folder_closed.png"));
    private BoundImageIcon text = new BoundImageIcon(Toolkit.getImageIcon("images/text.png"));
    private FastLabel label = new FastLabel();

    public DataTreeRenderer() {
        this.label.setOpaque(true);
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        if (object instanceof GrammarNodeTreeNode) {
            GrammarNodeTreeNode grammarNodeTreeNode = (GrammarNodeTreeNode)object;
            GrammarNode grammarNode = grammarNodeTreeNode.getSource();
            this.elementOpened.setBounded(grammarNodeTreeNode.getUserObject() != null);
            this.elementClosed.setBounded(grammarNodeTreeNode.getUserObject() != null);
            this.text.setBounded(grammarNodeTreeNode.getUserObject() != null);
            if ("complex".equals(grammarNode.getType().getType())) {
                if (bl2) {
                    this.label.setIcon(this.elementOpened);
                } else {
                    this.label.setIcon(this.elementClosed);
                }
            } else {
                this.label.setIcon(this.text);
            }
            this.label.setText(grammarNodeTreeNode.toString());
            if (!bl) {
                this.label.setBackground(jTree.getBackground());
                this.label.setForeground(jTree.getForeground());
            } else {
                this.label.setBackground(UIManager.getColor("Tree.selectionBackground"));
                this.label.setForeground(UIManager.getColor("Tree.selectionForeground"));
            }
        } else {
            this.label.setText(null);
        }
        return this.label;
    }

    class BoundImageIcon
    implements Icon {
        private Icon ref = null;
        boolean bounded = false;

        BoundImageIcon(Icon icon) {
            this.ref = icon;
        }

        public int getIconHeight() {
            return this.ref.getIconHeight();
        }

        public int getIconWidth() {
            return this.ref.getIconWidth();
        }

        public void setBounded(boolean bl) {
            this.bounded = bl;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            this.ref.paintIcon(component, graphics, n, n2);
            if (this.bounded) {
                graphics.setColor(Color.DARK_GRAY);
                graphics.fill3DRect(2, 2, 4, 4, true);
            }
        }
    }
}

