/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xmlform.component.container;

import com.japisoft.framework.preferences.Preferences;
import com.japisoft.framework.xml.XPathToolkit;
import com.japisoft.xmlform.component.AbstractXMLFormComponent;
import com.japisoft.xmlform.component.ComponentContext;
import com.japisoft.xmlform.component.XMLFormComponent;
import com.japisoft.xmlform.component.container.XMLFormContainer;
import com.japisoft.xmlform.designer.data.GrammarNodeTreeNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.TransferHandler;

public class GridComponent
extends JPanel
implements MouseListener,
MouseMotionListener,
XMLFormComponent {
    private int gridSize = 0;
    private boolean designMode = false;
    private ComponentContext context = null;
    String dragXPath = null;

    GridComponent(boolean bl, ComponentContext componentContext) {
        this.designMode = bl;
        this.context = componentContext;
        this.setLayout(null);
        if (bl) {
            this.gridSize = GridComponent.getGridSize();
            this.setTransferHandler(new DragDrop());
        }
    }

    public static int getGridSize() {
        return Math.max(5, Preferences.getPreference("designer", "grid-size", 10));
    }

    public String getXPath() {
        AbstractXMLFormComponent abstractXMLFormComponent;
        GrammarNodeTreeNode grammarNodeTreeNode;
        if (this.getParent() instanceof AbstractXMLFormComponent && (grammarNodeTreeNode = (abstractXMLFormComponent = (AbstractXMLFormComponent)this.getParent()).getGrammarNode()) != null) {
            return grammarNodeTreeNode.toXPath();
        }
        return null;
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.designMode) {
            graphics.setColor(Color.GRAY);
            for (int i = 0; i < this.getWidth(); i += this.gridSize) {
                for (int j = 0; j < this.getHeight(); j += this.gridSize) {
                    graphics.drawRect(i, j, 1, 1);
                }
            }
        }
    }

    public void addNotify() {
        super.addNotify();
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
    }

    public void removeNotify() {
        super.removeNotify();
        this.removeMouseMotionListener(this);
        this.removeMouseListener(this);
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.designMode) {
            for (int i = 0; i < this.getComponentCount(); ++i) {
                Component component = this.getComponent(i);
                if (!(component instanceof XMLFormContainer)) continue;
                ((XMLFormContainer)component).setBackground(color);
            }
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.dragXPath != null) {
            try {
                Object object;
                AbstractXMLFormComponent abstractXMLFormComponent = null;
                if (this.dragXPath.startsWith("new")) {
                    abstractXMLFormComponent = this.context.getComponentFactory().newComponentFromDescriptor(this.dragXPath.substring(4));
                } else {
                    object = this.context.getCurrentTreeNode().toXPath();
                    String string = this.getXPath();
                    if (string != null && !XPathToolkit.isXPathChild(string, (String)object)) {
                        this.context.action(2, "You can't drop it here. It must be a parent node");
                        return;
                    }
                    abstractXMLFormComponent = this.context.getComponentFactory().newComponentFromTreeNode(this.context.getCurrentTreeNode());
                }
                if (abstractXMLFormComponent != null && this.context.getCurrentTreeNode() != null) {
                    abstractXMLFormComponent.setGrammarNode(this.context.getCurrentTreeNode());
                    object = abstractXMLFormComponent.getPreferredSize();
                    abstractXMLFormComponent.setBounds(mouseEvent.getX(), mouseEvent.getY(), (int)((Dimension)object).getWidth(), (int)((Dimension)object).getHeight());
                    this.add(abstractXMLFormComponent);
                    this.invalidate();
                    this.validate();
                    this.repaint();
                }
            }
            finally {
                this.dragXPath = null;
            }
        }
    }

    public Component add(Component component) {
        if (this.designMode) {
            this.resizeToGrid(component);
            this.context.action(0, (AbstractXMLFormComponent)component);
        }
        return super.add(component);
    }

    public void resizeToGrid(Component component) {
        Rectangle rectangle = component.getBounds();
        rectangle.x = rectangle.x / this.gridSize * this.gridSize;
        rectangle.y = rectangle.y / this.gridSize * this.gridSize;
        rectangle.width = rectangle.width / this.gridSize * this.gridSize;
        if (rectangle.height <= this.gridSize) {
            rectangle.height = this.gridSize;
        }
        if (rectangle.width <= this.gridSize) {
            rectangle.width = this.gridSize;
        }
        component.setBounds(rectangle);
        component.invalidate();
        component.validate();
    }

    class DragDrop
    extends TransferHandler {
        DragDrop() {
        }

        public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
            return true;
        }

        public boolean importData(JComponent jComponent, Transferable transferable) {
            try {
                GridComponent.this.dragXPath = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                return GridComponent.this.dragXPath.startsWith("xpath:") || GridComponent.this.dragXPath.startsWith("new:");
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        }

        public int getSourceActions(JComponent jComponent) {
            return 2;
        }
    }
}

