/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.treefilebrowser;

import com.japisoft.framework.ui.AutoScroll;
import com.japisoft.treefilebrowser.FileFilter;
import com.japisoft.treefilebrowser.FileSelectionListener;
import com.japisoft.treefilebrowser.FileTreeModel;
import com.japisoft.treefilebrowser.FileTreeNode;
import com.japisoft.treefilebrowser.FileTreeTransferHandler;
import com.japisoft.treefilebrowser.FileView;
import com.japisoft.treefilebrowser.TreeCellEditor;
import com.japisoft.treefilebrowser.TreeCellRenderer;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.StringTokenizer;
import java.util.TooManyListenersException;
import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

class FileTree
extends JTree
implements DropTargetListener,
TreeSelectionListener,
MouseListener,
MouseMotionListener {
    private FileTreeTransferHandler handler = null;
    private Action a;
    private File delayedSelection = null;
    private boolean fileMoving = true;
    private boolean init = false;
    AutoScroll as = null;
    TreePath parentDragPath = null;
    FileTreeNode nodeDragged = null;

    public FileTree(Action action) {
        this.a = action;
        this.setRootVisible(false);
        this.setCellRenderer(new TreeCellRenderer());
        this.setCellEditor(new TreeCellEditor());
        this.setDragEnabled(false);
        this.setEditable(true);
        this.handler = new FileTreeTransferHandler();
        this.setTransferHandler(this.handler);
        this.setModel(new FileTreeModel());
    }

    void setFileView(FileView fileView) {
        ((TreeCellRenderer)this.getCellRenderer()).setFileView(fileView);
    }

    void setFileFilter(FileFilter fileFilter) {
        ((TreeCellRenderer)this.getCellRenderer()).setFileFilter(fileFilter);
        this.repaint();
    }

    void renameSelection(String string) {
        TreePath treePath = this.getSelectionPath();
        if (treePath == null) {
            return;
        }
        FileTreeNode fileTreeNode = (FileTreeNode)treePath.getLastPathComponent();
        File file = fileTreeNode.getFile();
        File file2 = null;
        file2 = new File(file.getParentFile(), string);
        if (file.renameTo(file2)) {
            fileTreeNode.content = file2;
            this.repaint();
        }
    }

    public void setEnabledFileMoving(boolean bl) {
        this.fileMoving = bl;
    }

    public boolean isEnabledFileMoving() {
        return this.fileMoving;
    }

    public void setEnabledFileRenaming(boolean bl) {
        this.setEditable(bl);
    }

    public boolean isEnabledFileRenaming() {
        return this.isEditable();
    }

    boolean dndPaste(ArrayList arrayList) {
        File file = this.getSelectedFile();
        if (file == null) {
            return false;
        }
        int n = 0;
        if (n < arrayList.size()) {
            File file2 = (File)arrayList.get(n);
            if (this.isRoot(file2)) {
                return false;
            }
            if (file2.getParentFile() != null && file2.getParentFile().equals(file)) {
                return false;
            }
            if (file.isFile()) {
                file = file.getParentFile();
                if (file2.getParentFile() != null && file2.getParentFile().equals(file)) {
                    return false;
                }
            }
            Object var5_5 = null;
            this.move(file2, new File(file, file2.getName()));
            return true;
        }
        return true;
    }

    boolean isRoot(File file) {
        int n;
        File[] fileArray = File.listRoots();
        if (fileArray != null && (n = 0) < fileArray.length) {
            return fileArray[n].equals(file);
        }
        return false;
    }

    void setSelectedFile(File file) {
        if (!this.init) {
            this.delayedSelection = file;
        } else {
            FileTreeNode fileTreeNode;
            String string = System.getProperty("file.separator");
            String string2 = file.getPath();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "/" + string);
            FileTreeNode fileTreeNode2 = (FileTreeNode)this.getModel().getRoot();
            TreePath treePath = new TreePath(this.getModel().getRoot());
            if (string2.startsWith("/")) {
                for (int i = 0; i < fileTreeNode2.getChildCount(); ++i) {
                    FileTreeNode fileTreeNode3 = (FileTreeNode)fileTreeNode2.getChildAt(i);
                    if (!fileTreeNode3.toString().equals("/")) continue;
                    fileTreeNode2 = fileTreeNode3;
                    treePath = treePath.pathByAddingChild(fileTreeNode3);
                    break;
                }
            }
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (!fileTreeNode2.resolved) {
                    ((FileTreeModel)this.getModel()).update(fileTreeNode2);
                }
                boolean bl = true;
                for (int i = 0; i < fileTreeNode2.getChildCount(); ++i) {
                    FileTreeNode fileTreeNode4 = (FileTreeNode)fileTreeNode2.getChildAt(i);
                    String string4 = fileTreeNode4.getFile().getName();
                    if ("".equals(string4)) {
                        string4 = fileTreeNode4.getFile().getPath();
                    }
                    if (!string4.equals(string3) && !string4.equals(string3 + "/") && !string4.equals(string3 + "\\")) continue;
                    fileTreeNode2 = fileTreeNode4;
                    treePath = treePath.pathByAddingChild(fileTreeNode4);
                    bl = true;
                    break;
                }
                if (bl) continue;
                break;
            }
            if (treePath.getLastPathComponent() == this.getModel().getRoot() && (fileTreeNode = (FileTreeNode)this.getModel().getRoot()).getChildCount() > 0) {
                treePath = new TreePath(new Object[]{fileTreeNode, fileTreeNode.getChildAt(0)});
            }
            this.expandPath(treePath);
            this.setSelectionPath(treePath);
            this.scrollPathToVisible(treePath);
        }
    }

    File[] getSelectedFiles() {
        TreePath[] treePathArray = this.getSelectionPaths();
        if (treePathArray == null) {
            return null;
        }
        File[] fileArray = new File[treePathArray.length];
        for (int i = 0; i < treePathArray.length; ++i) {
            fileArray[i] = ((FileTreeNode)treePathArray[i].getLastPathComponent()).getFile();
        }
        return fileArray;
    }

    File getSelectedFile() {
        TreePath treePath = this.getSelectionPath();
        if (treePath == null) {
            return null;
        }
        File file = ((FileTreeNode)treePath.getLastPathComponent()).getFile();
        return file;
    }

    public void addNotify() {
        super.addNotify();
        try {
            this.getDropTarget().addDropTargetListener(this);
        }
        catch (TooManyListenersException tooManyListenersException) {
            // empty catch block
        }
        this.addTreeSelectionListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.init();
    }

    public void removeNotify() {
        super.removeNotify();
        this.getDropTarget().removeDropTargetListener(this);
        this.removeTreeSelectionListener(this);
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
    }

    private void init() {
        if (this.init) {
            return;
        }
        this.init = true;
        ((FileTreeModel)this.getModel()).updateFirst();
        if (this.delayedSelection != null) {
            this.setSelectedFile(this.delayedSelection);
        }
        this.expandRow(0);
    }

    void addFileSelectionListener(FileSelectionListener fileSelectionListener) {
        this.listenerList.add(FileSelectionListener.class, fileSelectionListener);
    }

    void removeFileSelectionListener(FileSelectionListener fileSelectionListener) {
        this.listenerList.remove(FileSelectionListener.class, fileSelectionListener);
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (treeSelectionEvent.getPath() == null) {
            return;
        }
        File[] fileArray = this.getSelectedFiles();
        if (fileArray == null) {
            return;
        }
        EventListener[] eventListenerArray = this.listenerList.getListeners(FileSelectionListener.class);
        if (eventListenerArray != null) {
            for (int i = 0; i < eventListenerArray.length; ++i) {
                ((FileSelectionListener)eventListenerArray[i]).fileSelected(fileArray);
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        File file;
        if (mouseEvent.getClickCount() > 1 && this.a != null && (file = this.getSelectedFile()) != null && file.isFile()) {
            this.a.actionPerformed(new ActionEvent(this, 0, ""));
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        this.as = new AutoScroll(this, new Insets(10, 10, 10, 10));
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
        this.as = null;
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        Point point = dropTargetDragEvent.getLocation();
        this.as.autoscroll(point);
        TreePath treePath = this.getPathForLocation(point.x, point.y);
        if (treePath != null) {
            this.nodeDragged = (FileTreeNode)treePath.getLastPathComponent();
            File file = this.nodeDragged.getFile();
            if (file.isFile()) {
                file = file.getParentFile();
            }
            if (!file.canWrite()) {
                dropTargetDragEvent.acceptDrag(0);
            } else {
                File[] fileArray = this.handler.files;
                for (int i = 0; i < fileArray.length; ++i) {
                    if (fileArray[i].getParentFile() != null) {
                        if (!fileArray[i].getParentFile().equals(file)) continue;
                        dropTargetDragEvent.acceptDrag(0);
                        return;
                    }
                    return;
                }
                dropTargetDragEvent.acceptDrag(2);
            }
        }
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    FileTreeNode getNodeDragged() {
        return this.nodeDragged;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.fileMoving) {
            return;
        }
        TreePath treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath != null) {
            this.nodeDragged = (FileTreeNode)treePath.getLastPathComponent();
            this.parentDragPath = treePath.getParentPath();
            FileTreeNode fileTreeNode = (FileTreeNode)treePath.getLastPathComponent();
            if (fileTreeNode.getFile() != null && fileTreeNode.getFile().isFile()) {
                this.handler.exportAsDrag(this, mouseEvent, 2);
            }
        }
    }

    private void move(File file, File file2) {
        MoveDialog moveDialog = new MoveDialog(file, file2);
        moveDialog.setVisible(true);
        moveDialog.start();
    }

    class MoveDialog
    extends JDialog
    implements Runnable {
        private File source;
        private File destination;
        private JLabel lbl;

        public MoveDialog(File file, File file2) {
            super((Frame)null, "Move");
            this.source = file;
            this.destination = file2;
            this.lbl = new JLabel("Move " + file + " to " + file2);
            this.getContentPane().add(this.lbl);
            this.pack();
            this.setSize(this.getWidth() + 50, this.getHeight());
        }

        public void start() {
            new Thread(this).start();
        }

        public void run() {
            try {
                TreePath treePath = FileTree.this.getSelectionPath();
                Thread.sleep(500L);
                this.move(this.source, this.destination);
                Thread.sleep(500L);
                FileTreeModel fileTreeModel = (FileTreeModel)FileTree.this.getModel();
                fileTreeModel.reload(FileTree.this.parentDragPath);
                if (treePath != null) {
                    if (((FileTreeNode)treePath.getLastPathComponent()).getFile().isDirectory()) {
                        fileTreeModel.reload(treePath);
                    } else {
                        fileTreeModel.reload(treePath.getParentPath());
                    }
                }
                this.repaint();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                JOptionPane.showMessageDialog(this, "Can't move : " + exception.getMessage());
            }
            this.setVisible(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void move(File file, File file2) throws Exception {
            byte[] byArray = new byte[1024];
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                try {
                    int n = 0;
                    while ((n = fileInputStream.read(byArray)) != -1) {
                        fileOutputStream.write(byArray, 0, n);
                    }
                }
                finally {
                    fileOutputStream.close();
                }
            }
            finally {
                fileInputStream.close();
            }
            file.delete();
        }
    }
}

