/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.framework.xml.xsd.instance;

import com.japisoft.fastparser.node.SimpleNode;

public class XSDBuildInstance {
    public void buildElement(StringBuffer stringBuffer, String string, SimpleNode simpleNode, String string2, boolean bl) {
        SimpleNode simpleNode2 = this.searchGlobalDefinition("element", string, simpleNode);
        if (simpleNode2 != null) {
            this.buildElement(stringBuffer, simpleNode2, simpleNode, string2, bl);
        }
    }

    private void buildElement(StringBuffer stringBuffer, SimpleNode simpleNode, SimpleNode simpleNode2, String string, boolean bl) {
        int n = 1;
        if (simpleNode.hasAttribute("ref")) {
            if (simpleNode.hasAttribute("minOccurs")) {
                n = Integer.parseInt(simpleNode.getAttribute("minOccurs"));
            }
            if ((simpleNode = this.searchGlobalDefinition("element", simpleNode.getAttribute("ref"), simpleNode2)) == null) {
                return;
            }
        } else {
            n = Integer.parseInt(simpleNode.getAttribute("minOccurs", "1"));
        }
        if (n == 0 && !bl) {
            return;
        }
        if (n > 1 && !bl) {
            for (int i = 0; i < n; ++i) {
                this.buildWithoutOccurence(stringBuffer, simpleNode, simpleNode2, string, bl);
            }
        } else {
            this.buildWithoutOccurence(stringBuffer, simpleNode, simpleNode2, string, bl);
        }
    }

    private void buildWithoutOccurence(StringBuffer stringBuffer, SimpleNode simpleNode, SimpleNode simpleNode2, String string, boolean bl) {
        String string2 = this.resolveNamespace(simpleNode);
        stringBuffer.append("<").append(simpleNode.getAttribute("name", "error"));
        if (string2 != null) {
            stringBuffer.append(" xmlns=\"").append(string2).append("\"");
        }
        if (bl) {
            stringBuffer.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
            if (string2 != null) {
                stringBuffer.append(" xsi:schemaLocation=\"").append(string2).append(" ").append(string).append("\"");
            } else {
                stringBuffer.append(" xsi:noNamespaceSchemaLocation=\"").append(string).append("\"");
            }
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        this.resolveElementType(stringBuffer2, simpleNode, simpleNode2);
        if (stringBuffer2.length() != 0) {
            stringBuffer.append(stringBuffer2);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void resolveElementType(StringBuffer stringBuffer, SimpleNode simpleNode, SimpleNode simpleNode2) {
        SimpleNode simpleNode3;
        int n;
        SimpleNode simpleNode4 = this.getElementType(simpleNode, simpleNode2);
        if (simpleNode4 == null) {
            if (simpleNode.hasAttribute("type")) {
                stringBuffer.append(">VALUE");
                stringBuffer.append("</").append(simpleNode.getAttribute("name")).append(">");
                return;
            }
            stringBuffer.append("/>");
            return;
        }
        if (simpleNode4.matchContent("simpleType")) {
            stringBuffer.append(">VALUE");
            stringBuffer.append("</").append(simpleNode.getAttribute("name")).append(">");
            return;
        }
        if (!simpleNode4.matchContent("complexType")) return;
        this.resolveAttributes(stringBuffer, simpleNode4, simpleNode2);
        stringBuffer.append(">");
        SimpleNode simpleNode5 = simpleNode4.getFirstChildByName("complexContent");
        if (simpleNode5 != null) {
            String string;
            if ((simpleNode5 = simpleNode5.getFirstChildByName("extension")) != null && (simpleNode4 = this.searchGlobalDefinition("complexType", string = simpleNode5.getAttribute("base"), simpleNode2)) == null) {
                return;
            }
        } else if (simpleNode4.getFirstChildByName("simpleContent") != null) {
            stringBuffer.append("VALUE");
        }
        for (n = 0; n < simpleNode4.childCount(); ++n) {
            simpleNode3 = simpleNode4.childAt(n);
            if (simpleNode3.matchContent("sequence")) {
                this.resolveSequence(stringBuffer, simpleNode3, simpleNode2);
                continue;
            }
            if (simpleNode3.matchContent("choice")) {
                this.resolveChoice(stringBuffer, simpleNode3, simpleNode2);
                continue;
            }
            if (simpleNode3.matchContent("all")) {
                this.resolveAll(stringBuffer, simpleNode3, simpleNode2);
                continue;
            }
            if (!simpleNode3.matchContent("group")) continue;
            this.resolveGroup(stringBuffer, simpleNode3, simpleNode2);
        }
        if (simpleNode5 != null) {
            for (n = 0; n < simpleNode5.childCount(); ++n) {
                simpleNode3 = simpleNode5.childAt(n);
                if (simpleNode3.matchContent("element")) {
                    this.buildElement(stringBuffer, simpleNode3, simpleNode2, null, false);
                    continue;
                }
                if (simpleNode3.matchContent("sequence")) {
                    this.resolveSequence(stringBuffer, simpleNode3, simpleNode2);
                    continue;
                }
                if (simpleNode3.matchContent("choice")) {
                    this.resolveChoice(stringBuffer, simpleNode3, simpleNode2);
                    continue;
                }
                if (simpleNode3.matchContent("all")) {
                    this.resolveAll(stringBuffer, simpleNode3, simpleNode2);
                    continue;
                }
                if (!simpleNode3.matchContent("group")) continue;
                this.resolveGroup(stringBuffer, simpleNode3, simpleNode2);
            }
        }
        stringBuffer.append("</").append(simpleNode.getAttribute("name")).append(">");
    }

    private void resolveSequence(StringBuffer stringBuffer, SimpleNode simpleNode, SimpleNode simpleNode2) {
        try {
            int n = Integer.parseInt(simpleNode.getAttribute("minOccurs", "1"));
            if (n == 0) {
                return;
            }
            for (int i = 0; i < simpleNode.childCount(); ++i) {
                if ("0".equals(simpleNode.childAt(i).getAttribute("minOccurs", "1"))) continue;
                if (simpleNode.childAt(i).matchContent("element")) {
                    this.buildElement(stringBuffer, simpleNode.childAt(i), simpleNode2, null, false);
                    continue;
                }
                if (!simpleNode.childAt(i).matchContent("group")) continue;
                this.resolveGroup(stringBuffer, simpleNode.childAt(i), simpleNode2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void resolveChoice(StringBuffer stringBuffer, SimpleNode simpleNode, SimpleNode simpleNode2) {
        try {
            int n = Integer.parseInt(simpleNode.getAttribute("minOccurs", "1"));
            if (n == 0) {
                return;
            }
            for (int i = 0; i < simpleNode.childCount(); ++i) {
                if ("0".equals(simpleNode.childAt(i).getAttribute("minOccurs", "1"))) continue;
                if (simpleNode.childAt(i).matchContent("element")) {
                    this.buildElement(stringBuffer, simpleNode.childAt(i), simpleNode2, null, false);
                } else if (simpleNode.childAt(i).matchContent("group")) {
                    this.resolveGroup(stringBuffer, simpleNode.childAt(i), simpleNode2);
                }
                break;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void resolveAll(StringBuffer stringBuffer, SimpleNode simpleNode, SimpleNode simpleNode2) {
        this.resolveSequence(stringBuffer, simpleNode, simpleNode2);
    }

    private void resolveGroup(StringBuffer stringBuffer, SimpleNode simpleNode, SimpleNode simpleNode2) {
        if (simpleNode.hasAttribute("ref") && (simpleNode = this.searchGlobalDefinition("group", simpleNode.getAttribute("ref"), simpleNode2)) == null) {
            return;
        }
        for (int i = 0; i < simpleNode.childCount(); ++i) {
            if (simpleNode.childAt(i).matchContent("sequence")) {
                this.resolveSequence(stringBuffer, simpleNode.childAt(i), simpleNode2);
                continue;
            }
            if (simpleNode.childAt(i).matchContent("choice")) {
                this.resolveChoice(stringBuffer, simpleNode.childAt(i), simpleNode2);
                continue;
            }
            if (!simpleNode.childAt(i).matchContent("all")) continue;
            this.resolveAll(stringBuffer, simpleNode.childAt(i), simpleNode2);
        }
    }

    private void resolveAttributes(StringBuffer stringBuffer, SimpleNode simpleNode, SimpleNode simpleNode2) {
        int n;
        for (n = 0; n < simpleNode.childCount(); ++n) {
            if (simpleNode.childAt(n).matchContent("attribute")) {
                this.buildAttribute(stringBuffer, simpleNode.childAt(n), simpleNode2);
                continue;
            }
            if (!simpleNode.childAt(n).matchContent("attributeGroup")) continue;
            this.buildAttributeGroup(stringBuffer, simpleNode.childAt(n), simpleNode2);
        }
        for (n = 0; n < simpleNode.childCount(); ++n) {
            SimpleNode simpleNode3 = simpleNode.childAt(n);
            if (!simpleNode3.matchContent("complexContent") && !simpleNode3.matchContent("simpleContent")) continue;
            SimpleNode simpleNode4 = simpleNode3.getFirstChildByName("restriction");
            if (simpleNode4 == null) {
                simpleNode4 = simpleNode3.getFirstChildByName("extension");
            }
            if (simpleNode4 == null) continue;
            SimpleNode simpleNode5 = this.searchGlobalDefinition("complexType", simpleNode4.getAttribute("base"), simpleNode2);
            if (simpleNode5 != null) {
                this.resolveAttributes(stringBuffer, simpleNode5, simpleNode2);
                continue;
            }
            this.resolveAttributes(stringBuffer, simpleNode4, simpleNode2);
        }
    }

    private void buildAttribute(StringBuffer stringBuffer, SimpleNode simpleNode, SimpleNode simpleNode2) {
        if (simpleNode.hasAttribute("ref") && (simpleNode = this.searchGlobalDefinition("attribute", simpleNode.getAttribute("ref"), simpleNode2)) == null) {
            return;
        }
        if ("required".equals(simpleNode.getAttribute("use"))) {
            stringBuffer.append(" ");
            stringBuffer.append(simpleNode.getAttribute("name", "error"));
            stringBuffer.append("=\"VALUE\"");
        }
    }

    private void buildAttributeGroup(StringBuffer stringBuffer, SimpleNode simpleNode, SimpleNode simpleNode2) {
        if (simpleNode.hasAttribute("ref") && (simpleNode = this.searchGlobalDefinition("attributeGroup", simpleNode.getAttribute("ref"), simpleNode2)) == null) {
            return;
        }
        for (int i = 0; i < simpleNode.childCount(); ++i) {
            if (!simpleNode.childAt(i).matchContent("attribute")) continue;
            this.buildAttribute(stringBuffer, simpleNode.childAt(i), simpleNode2);
        }
    }

    private SimpleNode getElementType(SimpleNode simpleNode, SimpleNode simpleNode2) {
        SimpleNode simpleNode3 = simpleNode.getFirstChildByName("simpleType");
        if (simpleNode3 != null) {
            return simpleNode3;
        }
        simpleNode3 = simpleNode.getFirstChildByName("complexType");
        if (simpleNode3 != null) {
            return simpleNode3;
        }
        String string = simpleNode.getAttribute("type");
        if (string != null) {
            simpleNode3 = this.searchGlobalDefinition("simpleType", string, simpleNode2);
            if (simpleNode3 != null) {
                return simpleNode3;
            }
            simpleNode3 = this.searchGlobalDefinition("complexType", string, simpleNode2);
            if (simpleNode3 != null) {
                return simpleNode3;
            }
        }
        return null;
    }

    private String resolveNamespace(SimpleNode simpleNode) {
        if (simpleNode == null) {
            return null;
        }
        if (simpleNode.getApplicationObject() != null && !"override".equals(simpleNode.getApplicationObject())) {
            return (String)simpleNode.getApplicationObject();
        }
        if (simpleNode.hasAttribute("targetNamespace")) {
            return simpleNode.getAttribute("targetNamespace");
        }
        return this.resolveNamespace(simpleNode.getSimpleParent());
    }

    private SimpleNode searchGlobalDefinition(String string, String string2, SimpleNode simpleNode) {
        if (string2 != null) {
            int n;
            String string3 = null;
            if (string2.contains("{")) {
                n = string2.lastIndexOf("}");
                string3 = string2.substring(1, n);
                string2 = string2.substring(n + 1);
            }
            for (n = 0; n < simpleNode.childCount(); ++n) {
                String string4;
                SimpleNode simpleNode2 = simpleNode.childAt(n);
                if (!simpleNode2.matchContent(string) || !string2.equals(string4 = simpleNode2.getAttribute("name"))) continue;
                if (string3 == null) {
                    return simpleNode2;
                }
                if (string3 == null || !string3.equals(simpleNode2.getApplicationObject())) continue;
                return simpleNode2;
            }
        }
        return null;
    }
}

