/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.framework.xml.validator;

import com.japisoft.framework.xml.validator.ErrorValidationNode;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSDValidator
implements ErrorHandler {
    private Validator validator = null;
    private boolean error = false;
    private String errorMessage = null;
    private ArrayList<ErrorValidationNode> listOfErrorNodes = null;

    public XSDValidator(String string) throws Exception {
        System.setProperty("javax.xml.validation.SchemaFactory:http://www.w3.org/2001/XMLSchema", "org.apache.xerces.jaxp.validation.XMLSchemaFactory");
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = null;
        schema = string.indexOf("://") > -1 ? schemaFactory.newSchema(new URL(string)) : schemaFactory.newSchema(new File(string));
        this.validator = schema.newValidator();
        this.validator.setErrorHandler(this);
    }

    public boolean validate(Document document) {
        this.error = false;
        this.errorMessage = null;
        try {
            this.listOfErrorNodes = null;
            this.validator.validate(new DOMSource(document));
        }
        catch (SAXException sAXException) {
            this.errorMessage = sAXException.getMessage();
            this.error = true;
        }
        catch (IOException iOException) {
            this.errorMessage = iOException.getMessage();
            this.error = true;
        }
        return !this.error;
    }

    public String getLastErrorMessage() {
        if (this.errorMessage == null) {
            return "";
        }
        return this.errorMessage;
    }

    public List<ErrorValidationNode> getErrors() {
        return this.listOfErrorNodes;
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXException {
        this.processException(sAXParseException);
    }

    private void processException(SAXParseException sAXParseException) throws SAXException {
        if (this.listOfErrorNodes == null) {
            this.listOfErrorNodes = new ArrayList();
        }
        this.listOfErrorNodes.add(new ErrorValidationNode(sAXParseException.getMessage(), (Node)this.validator.getProperty("http://apache.org/xml/properties/dom/current-element-node")));
        this.error = true;
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.processException(sAXParseException);
        this.error = true;
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXException {
    }

    public static void main(String[] stringArray) throws Exception {
        XSDValidator xSDValidator = new XSDValidator("c:/editix/livre.xsd");
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new File("C:/Documents and Settings/alex/toto.xml"));
        xSDValidator.validate(document);
    }
}

