/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.framework.xml.refactor;

import com.japisoft.framework.xml.refactor.elements.AttributeRefactor;
import com.japisoft.framework.xml.refactor.elements.CommentRefactor;
import com.japisoft.framework.xml.refactor.elements.ElementRefactor;
import com.japisoft.framework.xml.refactor.elements.EntityRefactor;
import com.japisoft.framework.xml.refactor.elements.NamespaceRefactor;
import com.japisoft.framework.xml.refactor.elements.PIRefactor;
import com.japisoft.framework.xml.refactor.elements.PrefixRefactor;
import com.japisoft.framework.xml.refactor.elements.RefactorAction;
import com.japisoft.framework.xml.refactor.elements.RefactorObj;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public final class RefactorManager {
    private static ArrayList refactors = new ArrayList();
    private static HashMap mapNameRefactorClass = new HashMap();

    public static void addRefactor(RefactorObj refactorObj) {
        mapNameRefactorClass.put(refactorObj.getName(), refactorObj.getClass());
        refactors.add(refactorObj);
    }

    public static void addRefactorAt(RefactorObj refactorObj, int n) {
        mapNameRefactorClass.put(refactorObj.getName(), refactorObj.getClass());
        refactors.add(n, refactorObj);
    }

    public static void removeNonDefaultRefactors() {
        Iterator iterator = refactors.iterator();
        while (iterator.hasNext()) {
            RefactorObj refactorObj = (RefactorObj)iterator.next();
            if (refactorObj.isDefault()) continue;
            iterator.remove();
        }
    }

    public static void removeRefactor(RefactorObj refactorObj) {
        refactors.remove(refactorObj);
    }

    public static void removeRefactorByName(String string) {
        for (int i = 0; i < RefactorManager.getRefactorCount(); ++i) {
            if (!RefactorManager.getRefactor(i).getName().equals(string)) continue;
            refactors.remove(RefactorManager.getRefactor(i));
            break;
        }
    }

    public static int getRefactorCount() {
        return refactors.size();
    }

    public static RefactorObj getRefactor(int n) {
        return (RefactorObj)refactors.get(n);
    }

    public static String getRefactorName(int n) {
        return RefactorManager.getRefactor(n).getName();
    }

    public static RefactorObj getRefactor(String string) {
        for (int i = 0; i < RefactorManager.getRefactorCount(); ++i) {
            if (!string.equals(RefactorManager.getRefactorName(i))) continue;
            return RefactorManager.getRefactor(i);
        }
        return null;
    }

    public static RefactorObj[] getRefactors() {
        RefactorObj[] refactorObjArray = new RefactorObj[refactors.size()];
        for (int i = 0; i < refactorObjArray.length; ++i) {
            refactorObjArray[i] = (RefactorObj)refactors.get(i);
        }
        return refactorObjArray;
    }

    public static String[] getRefactorActions(String string) {
        for (int i = 0; i < RefactorManager.getRefactorCount(); ++i) {
            RefactorObj refactorObj = RefactorManager.getRefactor(i);
            if (!refactorObj.getName().equals(string)) continue;
            return refactorObj.getActions();
        }
        return null;
    }

    public static RefactorObj buildRefactorObj(String string, RefactorAction refactorAction) throws Exception {
        Class clazz = (Class)mapNameRefactorClass.get(string);
        if (clazz == null) {
            throw new RuntimeException("Invalid class for name " + string);
        }
        RefactorObj refactorObj = (RefactorObj)clazz.newInstance();
        refactorObj.setRefactorAction(refactorAction);
        return refactorObj;
    }

    static {
        RefactorManager.addRefactor(new ElementRefactor());
        RefactorManager.addRefactor(new PrefixRefactor());
        RefactorManager.addRefactor(new NamespaceRefactor());
        RefactorManager.addRefactor(new AttributeRefactor());
        RefactorManager.addRefactor(new EntityRefactor());
        RefactorManager.addRefactor(new CommentRefactor());
        RefactorManager.addRefactor(new PIRefactor());
    }
}

