/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.framework.xml.grammar.xsd;

import com.japisoft.framework.xml.grammar.Grammar;
import com.japisoft.framework.xml.grammar.GrammarElement;
import com.japisoft.framework.xml.grammar.xsd.XSDGrammarElement;
import com.japisoft.framework.xml.grammar.xsd.XSDGrammarNode;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSDGrammar
implements Grammar {
    private Document doc = null;
    private String location = null;
    private List<GrammarElement> cache = null;
    private String name = null;

    public XSDGrammar(String string) throws Exception {
        this.location = string;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setIgnoringComments(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        this.doc = documentBuilder.parse(string);
        this.resolveIncludeRedefineImport();
    }

    private void resolveIncludeRedefineImport() {
    }

    @Override
    public List<GrammarElement> getGlobalElements() {
        if (this.cache == null) {
            this.cache = XSDGrammar.getGlobalComponent(this.doc, "element");
        }
        return this.cache;
    }

    public static List<GrammarElement> getGlobalComponent(Document document, String string) {
        ArrayList<GrammarElement> arrayList = new ArrayList<GrammarElement>();
        Element element = document.getDocumentElement();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            String string2 = node.getNodeName();
            int n = string2.indexOf(":");
            if (n > -1) {
                string2 = string2.substring(n + 1);
            }
            if (!string.equals(string2)) continue;
            arrayList.add(new XSDGrammarElement((Element)node));
        }
        return arrayList;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            if (this.location == null) {
                this.name = "Schema";
            } else {
                int n = this.location.lastIndexOf("/");
                if (n == -1) {
                    n = this.location.lastIndexOf("\\");
                }
                this.name = n > -1 ? this.location.substring(n + 1) : this.location;
            }
        }
        return this.name;
    }

    public static void main(String[] stringArray) throws Exception {
        String string = "C:/travail/soft/xmlform/distrib/insta-content/samples/purchaseOrder.xsd";
        XSDGrammar xSDGrammar = new XSDGrammar(string);
        List<GrammarElement> list = xSDGrammar.getGlobalElements();
        for (GrammarElement grammarElement : list) {
            ((XSDGrammarNode)((Object)grammarElement)).dump();
        }
    }
}

