/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.framework.xml.format;

import com.japisoft.framework.xml.XMLToolkit;
import com.japisoft.framework.xml.format.FormatterConfig;
import com.japisoft.framework.xml.refactor2.AbstractRefactor;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public class Formatter
implements ContentHandler,
LexicalHandler {
    private StringBuffer r = new StringBuffer();
    private ArrayList prefixList = null;
    private Stack openedStack = new Stack();
    private boolean delayedStartElement = false;
    private boolean firstElementFound = false;
    private boolean foundText = false;
    private StringBuffer reusableBuffer = null;
    private boolean foundProcessingInstruction = false;
    private boolean foundCDATA = false;
    private boolean inCDATA = false;
    private boolean foundComment = false;
    private FormatterConfig config = null;

    public String getResult(String string) {
        if (string != null) {
            this.r.insert(0, string);
        }
        return this.r.toString();
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        if (this.prefixList == null) {
            this.prefixList = new ArrayList();
        }
        if (!this.prefixList.contains(string)) {
            this.prefixList.add(string);
            this.prefixList.add(string2);
        }
    }

    public void endPrefixMapping(String string) throws SAXException {
        int n;
        if (this.prefixList != null && (n = this.prefixList.indexOf(string)) > -1) {
            this.prefixList.remove(n);
            this.prefixList.remove(n);
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        int n;
        this.firstElementFound = true;
        this.checkForDelayedStartElement();
        if (!this.foundText) {
            this.indent();
        }
        this.foundText = false;
        this.r.append("<").append(string3);
        if (attributes != null && attributes.getLength() > 0) {
            for (n = 0; n < attributes.getLength(); ++n) {
                String string4 = attributes.getQName(n);
                if (string4 == null) continue;
                this.r.append(" ").append(string4).append("=\"").append(this.processAttributeText(attributes.getValue(n))).append("\"");
            }
        }
        if (this.prefixList != null) {
            for (n = 0; n < this.prefixList.size(); n += 2) {
                this.r.append(" xmlns");
                if (!"".equals(this.prefixList.get(n))) {
                    this.r.append(":").append(this.prefixList.get(n));
                }
                this.r.append("=\"");
                this.r.append(this.processAttributeText((String)this.prefixList.get(n + 1))).append("\"");
            }
            this.prefixList = null;
        }
        if (!this.config.isAutoCloseElement()) {
            this.r.append(">");
        } else {
            this.delayedStartElement = true;
        }
        this.openedStack.push(string3);
    }

    private void indent() {
        if (this.config.isIndent()) {
            this.r.append("\n");
            for (int i = 0; i < this.openedStack.size() * this.config.getFormatSpaceQty(); ++i) {
                this.r.append(this.config.getFormatSpaceChr());
            }
        }
    }

    private void checkForDelayedStartElement() {
        if (this.delayedStartElement) {
            this.r.append(">");
            this.delayedStartElement = false;
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        boolean bl = false;
        if (this.delayedStartElement) {
            this.r.append("/>");
            this.delayedStartElement = false;
            bl = true;
        }
        this.foundCDATA = false;
        this.foundComment = false;
        this.foundProcessingInstruction = false;
        this.openedStack.pop();
        if (!bl) {
            if (!this.foundText) {
                this.indent();
            }
            this.foundText = false;
            this.r.append("</").append(string3).append(">");
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        boolean bl;
        boolean bl2 = bl = !this.foundText;
        if (!this.foundText) {
            for (int i = n; i < n + n2; ++i) {
                if (Character.isWhitespace(cArray[i])) continue;
                bl = false;
                break;
            }
        }
        if (!bl) {
            this.foundText = true;
            this.checkForDelayedStartElement();
            this.r.append(this.processElementText(cArray, n, n2));
        }
    }

    private String processElementText(char[] cArray, int n, int n2) {
        int n3;
        String string = null;
        if (!this.inCDATA) {
            if (this.reusableBuffer == null) {
                this.reusableBuffer = new StringBuffer();
            } else {
                this.reusableBuffer.delete(0, this.reusableBuffer.length());
            }
            for (n3 = n; n3 < n + n2; ++n3) {
                if (cArray[n3] == '<' || cArray[n3] == '>' || cArray[n3] == '&') continue;
                this.reusableBuffer.append(cArray[n3]);
            }
            string = this.reusableBuffer.toString();
        } else {
            string = new String(cArray, n, n2);
        }
        if (this.config.isTrimedText()) {
            int n4;
            if (string.startsWith("Antenna")) {
                System.out.println("ok");
            }
            n3 = 0;
            for (n4 = 0; n4 < string.length(); ++n4) {
                if (Character.isWhitespace(string.charAt(n4))) continue;
                n3 = n4;
                break;
            }
            for (int i = n4 = string.length() - 1; i >= 0; --i) {
                if (Character.isWhitespace(string.charAt(i))) continue;
                n4 = i;
                break;
            }
            return string.substring(n3, n4 + 1);
        }
        return string;
    }

    private String processAttributeText(String string) {
        if (this.reusableBuffer == null) {
            this.reusableBuffer = new StringBuffer();
        } else {
            this.reusableBuffer.delete(0, this.reusableBuffer.length());
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '&') {
                this.reusableBuffer.append("&amp;");
                continue;
            }
            if (c == '\"') {
                this.reusableBuffer.append("&quot;");
                continue;
            }
            if (c == '<') {
                this.reusableBuffer.append("&lt;");
                continue;
            }
            if (c == '>') {
                this.reusableBuffer.append("&gt;");
                continue;
            }
            this.reusableBuffer.append(c);
        }
        return this.reusableBuffer.toString();
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        if (!this.firstElementFound) {
            return;
        }
        this.checkForDelayedStartElement();
        this.foundProcessingInstruction = true;
        if (this.config.isIndentProcessingInstruction()) {
            this.indent();
        }
        this.r.append("<?").append(string).append(" ").append(string2).append("?>");
    }

    public void skippedEntity(String string) throws SAXException {
        if (!this.firstElementFound) {
            return;
        }
        this.checkForDelayedStartElement();
        this.r.append("&").append(string).append(";");
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
    }

    public void endDTD() throws SAXException {
    }

    public void startEntity(String string) throws SAXException {
        if (!this.firstElementFound) {
            return;
        }
        this.checkForDelayedStartElement();
        this.r.append("&").append(string).append(";");
    }

    public void endEntity(String string) throws SAXException {
    }

    public void startCDATA() throws SAXException {
        this.checkForDelayedStartElement();
        this.foundCDATA = true;
        this.inCDATA = true;
        this.r.append("<![CDATA[");
    }

    public void endCDATA() throws SAXException {
        this.r.append("]]>");
        this.inCDATA = false;
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        if (!this.firstElementFound) {
            return;
        }
        this.checkForDelayedStartElement();
        this.foundComment = true;
        this.r.append("<!--").append(new String(cArray, n, n2)).append("-->");
    }

    public void setFormatterConfig(FormatterConfig formatterConfig) {
        if (formatterConfig == null) {
            throw new RuntimeException("The formatterConfig can't be null !");
        }
        this.config = formatterConfig;
    }

    public static String format(String string, Formatter formatter, FormatterConfig formatterConfig, AbstractRefactor abstractRefactor) throws Exception {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(false);
        sAXParserFactory.setNamespaceAware(true);
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        if (formatter == null) {
            formatter = new Formatter();
        }
        formatter.setFormatterConfig(formatterConfig);
        XMLReader xMLReader = sAXParser.getXMLReader();
        xMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", formatter);
        if (abstractRefactor != null) {
            abstractRefactor.setContentHandler(formatter);
            xMLReader.setContentHandler(abstractRefactor);
        } else {
            xMLReader.setContentHandler(formatter);
        }
        xMLReader.setEntityResolver(new EntityResolver(){

            public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
                return new InputSource(new StringReader(""));
            }
        });
        xMLReader.parse(new InputSource(new StringReader(string)));
        String string2 = XMLToolkit.getFullProlog(string);
        return formatter.getResult(string2);
    }
}

