/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.framework.xml;

import com.japisoft.framework.ApplicationModel;
import com.japisoft.framework.xml.XMLToolkit;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class XMLConfigPanel
extends JPanel
implements ActionListener,
ListSelectionListener {
    JList listJars = new JList();
    JPanel pnlJars = new JPanel();
    TitledBorder titledBorder1;
    JButton btnAdd = new JButton();
    JButton btnRemove = new JButton();
    JButton btnSearch = new JButton("Search a JAXP class");
    JPanel pnlClass = new JPanel();
    TitledBorder titledBorder2;
    JTextField tfClassname = new JTextField();
    JButton btnCheck = new JButton();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    GridBagLayout gridBagLayout3 = new GridBagLayout();
    BoxLayout boxLayout21 = new BoxLayout(this.pnlJars, 0);
    Class interf = null;
    String dataFileName = null;
    JFileChooser chooser = null;

    public XMLConfigPanel(Class clazz, String string) {
        this.interf = clazz;
        this.dataFileName = string;
        this.listJars.setModel(new DefaultListModel());
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.init();
        this.updateBtnStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        File file = new File(ApplicationModel.getAppUserPath(), this.dataFileName);
        if (file.exists()) {
            try {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                try {
                    this.tfClassname.setText(bufferedReader.readLine());
                    String string = bufferedReader.readLine();
                    while (string != null) {
                        ((DefaultListModel)this.listJars.getModel()).addElement(string);
                        string = bufferedReader.readLine();
                    }
                }
                finally {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                System.err.println(iOException.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean save() {
        File file = new File(ApplicationModel.getAppUserPath(), this.dataFileName);
        if (this.listJars.getModel().getSize() > 0 && !"".equals(this.tfClassname.getText())) {
            try {
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
                try {
                    bufferedWriter.write(this.tfClassname.getText());
                    bufferedWriter.newLine();
                    ListModel listModel = this.listJars.getModel();
                    for (int i = 0; i < listModel.getSize(); ++i) {
                        bufferedWriter.write((String)listModel.getElementAt(i));
                        bufferedWriter.newLine();
                    }
                }
                finally {
                    bufferedWriter.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        file.delete();
        return false;
    }

    void jbInit() throws Exception {
        this.titledBorder1 = new TitledBorder(BorderFactory.createLineBorder(new Color(153, 153, 153), 2), "Java Jars");
        this.titledBorder2 = new TitledBorder(BorderFactory.createLineBorder(new Color(153, 153, 153), 2), "Java Class");
        this.setLayout(this.gridBagLayout3);
        this.pnlJars.setBorder(this.titledBorder1);
        this.pnlJars.setLayout(this.boxLayout21);
        this.btnAdd.setText("Add");
        this.btnRemove.setText("Remove");
        this.pnlClass.setBorder(this.titledBorder2);
        this.pnlClass.setLayout(this.gridBagLayout2);
        this.btnCheck.setText("Check");
        this.tfClassname.setText("");
        this.add((Component)new JScrollPane(this.listJars), new GridBagConstraints(0, 0, 1, 5, 1.0, 10.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.pnlJars, new GridBagConstraints(0, 6, 1, 1, 1.0, 1.0, 15, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.pnlClass, new GridBagConstraints(0, 7, 1, 1, 1.0, 1.0, 15, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.pnlClass.add((Component)this.tfClassname, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.pnlClass.add((Component)this.btnCheck, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.pnlJars.add((Component)this.btnAdd, null);
        this.pnlJars.add((Component)this.btnRemove, null);
        this.pnlJars.add((Component)this.btnSearch, null);
    }

    public void addNotify() {
        super.addNotify();
        this.btnAdd.addActionListener(this);
        this.btnRemove.addActionListener(this);
        this.btnCheck.addActionListener(this);
        this.btnSearch.addActionListener(this);
        this.listJars.addListSelectionListener(this);
    }

    public void removeNotify() {
        super.removeNotify();
        this.btnAdd.removeActionListener(this);
        this.btnRemove.removeActionListener(this);
        this.btnCheck.removeActionListener(this);
        this.btnSearch.removeActionListener(this);
        this.listJars.removeListSelectionListener(this);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.updateBtnStatus();
    }

    private void updateBtnStatus() {
        this.btnRemove.setEnabled(this.listJars.getSelectedIndex() != -1);
        this.btnSearch.setEnabled(this.listJars.getModel().getSize() > 0);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block21: {
            if (actionEvent.getSource() == this.btnAdd) {
                if (this.chooser == null) {
                    this.chooser = new JFileChooser();
                    this.chooser.setMultiSelectionEnabled(true);
                }
                if (this.chooser.showOpenDialog(this) == 0) {
                    File[] fileArray = this.chooser.getSelectedFiles();
                    try {
                        for (int i = 0; i < fileArray.length; ++i) {
                            ((DefaultListModel)this.listJars.getModel()).addElement(fileArray[i].toURL().toString());
                        }
                        this.updateBtnStatus();
                    }
                    catch (MalformedURLException malformedURLException) {
                        JOptionPane.showMessageDialog(this, "Can't add this file : " + malformedURLException.getMessage());
                    }
                }
            } else if (actionEvent.getSource() == this.btnRemove) {
                ((DefaultListModel)this.listJars.getModel()).removeElementAt(this.listJars.getSelectedIndex());
                this.updateBtnStatus();
            } else if (actionEvent.getSource() == this.btnCheck) {
                ListModel listModel = this.listJars.getModel();
                URL[] uRLArray = new URL[listModel.getSize()];
                try {
                    int n;
                    for (n = 0; n < listModel.getSize(); ++n) {
                        uRLArray[n] = new URL((String)listModel.getElementAt(n));
                    }
                    n = XMLToolkit.check(uRLArray, this.tfClassname.getText()) ? 1 : 0;
                    if (n != 0) {
                        JOptionPane.showMessageDialog(this, this.tfClassname.getText() + " checked");
                        break block21;
                    }
                    JOptionPane.showMessageDialog(this, "Can't use " + this.tfClassname.getText());
                }
                catch (MalformedURLException malformedURLException) {
                    JOptionPane.showMessageDialog(this, "Can't checked : " + malformedURLException.getMessage());
                }
            } else if (actionEvent.getSource() == this.btnSearch) {
                try {
                    ListModel listModel = this.listJars.getModel();
                    URL[] uRLArray = new URL[listModel.getSize()];
                    for (int i = 0; i < listModel.getSize(); ++i) {
                        uRLArray[i] = new URL((String)listModel.getElementAt(i));
                    }
                    URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray);
                    boolean bl = false;
                    for (int i = 0; i < listModel.getSize(); ++i) {
                        String string = this.check(uRLClassLoader, uRLArray[i]);
                        if (string == null) continue;
                        this.tfClassname.setText(string);
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        JOptionPane.showMessageDialog(this, "Can't find a class compatible with " + this.interf);
                    }
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(this, "Can't find a class compatible with " + this.interf);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String check(URLClassLoader uRLClassLoader, URL uRL) throws Exception {
        JarInputStream jarInputStream = new JarInputStream(uRL.openStream());
        try {
            JarEntry jarEntry = jarInputStream.getNextJarEntry();
            while (jarEntry != null) {
                String string = jarEntry.getName();
                if (string.endsWith(".class")) {
                    string = string.replace('/', '.');
                    string = string.replace('\\', '.');
                    string = string.substring(0, string.length() - 6);
                    try {
                        Class<?> clazz = uRLClassLoader.loadClass(string);
                        if (this.interf.isAssignableFrom(clazz) && clazz != this.interf) {
                            String string2 = string;
                            return string2;
                        }
                    }
                    catch (Throwable throwable) {
                        System.err.println("Can't load " + string);
                    }
                }
                jarEntry = jarInputStream.getNextJarEntry();
            }
        }
        finally {
            jarInputStream.close();
        }
        return null;
    }
}

