/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.framework.dialog.help;

import com.japisoft.framework.ApplicationModel;
import com.japisoft.framework.dialog.BasicOKDialogComponent;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.IOException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class ManualDialog
extends BasicOKDialogComponent
implements HyperlinkListener {
    public static String DEF_MANUAL_PATH = "doc/manual.html";
    private JEditorPane pane = null;

    static String getTITLE() {
        return "Manual of " + ApplicationModel.SHORT_APPNAME;
    }

    static String getCOMMENT() {
        if (DEF_MANUAL_PATH.startsWith("http://")) {
            return "This manual is located at " + DEF_MANUAL_PATH;
        }
        return null;
    }

    public ManualDialog(Frame frame) {
        this(frame, null);
    }

    public ManualDialog(Frame frame, String string) {
        super(frame, "Manual", ManualDialog.getTITLE(), ManualDialog.getCOMMENT(), null);
        this.setModal(false);
        try {
            String string2 = string;
            if (string2 == null) {
                string2 = DEF_MANUAL_PATH;
            }
            URL uRL = null;
            uRL = string2.startsWith("http:") ? new URL(string2) : ClassLoader.getSystemResource(string2);
            this.pane = new JEditorPane();
            this.pane.setEditable(false);
            this.pane.setText("Reading " + DEF_MANUAL_PATH + " ...");
            JScrollPane jScrollPane = new JScrollPane(this.pane);
            jScrollPane.setPreferredSize(new Dimension(650, 500));
            this.setUI(jScrollPane);
            this.load(uRL);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void load(URL uRL) {
        final URL uRL2 = uRL;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    ManualDialog.this.pane.setPage(uRL2);
                }
                catch (Exception exception) {
                    ManualDialog.this.pane.setText("Can't read " + uRL2);
                }
            }
        });
    }

    public void addNotify() {
        super.addNotify();
        this.pane.addHyperlinkListener(this);
    }

    public void removeNotify() {
        super.removeNotify();
        this.pane.removeHyperlinkListener(this);
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.pane.scrollToReference(hyperlinkEvent.getDescription().substring(1));
        }
    }
}

