/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.fastparser.walker;

import com.japisoft.fastparser.FastVector;
import com.japisoft.fastparser.node.SimpleNode;
import com.japisoft.fastparser.walker.NodeNameCriteria;
import com.japisoft.fastparser.walker.TextCriteria;
import com.japisoft.fastparser.walker.ValidCriteria;
import java.util.Enumeration;

public class TreeWalker {
    private SimpleNode node;

    public TreeWalker(SimpleNode simpleNode) {
        this.node = simpleNode;
        if (simpleNode == null) {
            throw new RuntimeException("Illegal null node");
        }
    }

    public Enumeration getTagNodeByName(String string, boolean bl) {
        return this.getCriteriaResult(new NodeNameCriteria(string), bl, false);
    }

    public SimpleNode getFirstTagNodeByName(String string, boolean bl) {
        Enumeration enumeration = this.getTagNodeByName(string, bl);
        if (enumeration.hasMoreElements()) {
            return (SimpleNode)enumeration.nextElement();
        }
        return null;
    }

    public Enumeration getTextNode(String string, boolean bl) {
        return this.getCriteriaResult(new TextCriteria(string), bl, false);
    }

    public Enumeration getNodeByCriteria(ValidCriteria validCriteria, boolean bl) {
        return this.getCriteriaResult(validCriteria, bl, false);
    }

    public SimpleNode getOneNodeByCriteria(ValidCriteria validCriteria, boolean bl) {
        Enumeration enumeration = this.getNodeByCriteria(validCriteria, bl);
        if (enumeration.hasMoreElements()) {
            return (SimpleNode)enumeration.nextElement();
        }
        return null;
    }

    public Enumeration getNodeByCriteria(ValidCriteria validCriteria, boolean bl, boolean bl2) {
        return this.getCriteriaResult(validCriteria, bl, bl2);
    }

    private Enumeration getCriteriaResult(ValidCriteria validCriteria, boolean bl, boolean bl2) {
        FastVector fastVector = new FastVector();
        this.matchTag(validCriteria, fastVector, this.node, bl, false);
        return fastVector.elements();
    }

    private void matchTag(ValidCriteria validCriteria, FastVector fastVector, SimpleNode simpleNode, boolean bl, boolean bl2) {
        for (int i = 0; i < simpleNode.childCount(); ++i) {
            SimpleNode simpleNode2 = simpleNode.childAt(i);
            if (validCriteria.isValid(simpleNode2)) {
                fastVector.add(simpleNode2);
                if (bl2) {
                    return;
                }
            }
            if (!bl || simpleNode2.isLeaf()) continue;
            this.matchTag(validCriteria, fastVector, simpleNode2, bl, bl2);
        }
    }
}

