/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.fastparser.dom;

import com.japisoft.fastparser.dom.AttrImpl;
import com.japisoft.fastparser.dom.DOMExceptionImpl;
import com.japisoft.fastparser.node.SimpleNode;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class NamedNodeMapImpl
implements NamedNodeMap {
    private SimpleNode n;

    public NamedNodeMapImpl(SimpleNode simpleNode) {
        this.n = simpleNode;
    }

    public Node getNamedItem(String string) {
        if (this.n.getAttribute(string) == null) {
            return null;
        }
        return new AttrImpl(string, this.n);
    }

    public Node setNamedItem(Node node) throws DOMException {
        if (node instanceof Attr) {
            Attr attr = (Attr)node;
            String string = attr.getName();
            if (string == null) {
                return null;
            }
            if (this.n.getAttribute(string) != null) {
                this.n.setAttribute(string, attr.getValue());
            }
            return node;
        }
        throw new DOMExceptionImpl(7, "Invalid argument : need an Attr node type ");
    }

    public Node removeNamedItem(String string) throws DOMException {
        this.n.setAttribute(string, null);
        return null;
    }

    public Node item(int n) {
        return new AttrImpl(this.n.getViewAttributeAt(n), this.n);
    }

    public int getLength() {
        return this.n.getViewAttributeCount();
    }

    public Node getNamedItemNS(String string, String string2) {
        throw new RuntimeException("Not supported");
    }

    public Node setNamedItemNS(Node node) throws DOMException {
        throw new RuntimeException("Not supported");
    }

    public Node removeNamedItemNS(String string, String string2) throws DOMException {
        throw new RuntimeException("Not supported");
    }
}

