/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.ui.xslt;

import com.japisoft.editix.ui.xslt.XSLTFiles;
import com.japisoft.fastparser.node.SimpleNode;
import com.japisoft.framework.ApplicationModel;
import com.japisoft.xmlpad.XMLContainer;
import com.japisoft.xmlpad.editor.XMLDocument;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.text.BadLocationException;

public class XSLTTemplates
extends JPanel
implements ActionListener,
MouseListener,
MouseMotionListener {
    private JTable table;
    private XSLTFiles files;
    private int lastPopupRow = -1;

    XSLTTemplates(XSLTFiles xSLTFiles) {
        this.files = xSLTFiles;
        this.setLayout(new BorderLayout());
        this.table = new JTable();
        this.add(new JScrollPane(this.table));
        this.table.setTransferHandler(new TemplateDrag());
    }

    public void addNotify() {
        super.addNotify();
        this.table.addMouseListener(this);
        this.table.addMouseMotionListener(this);
    }

    public void removeNotify() {
        super.removeNotify();
        this.table.removeMouseListener(this);
        this.table.removeMouseMotionListener(this);
    }

    public void updateContent() {
        this.dispose();
        this.table.setModel(new CustomTableModel());
        this.table.getColumnModel().getColumn(0).setCellRenderer(new EditRenderer());
        CustomRenderer customRenderer = new CustomRenderer();
        this.table.getColumnModel().getColumn(1).setCellRenderer(customRenderer);
        this.table.getColumnModel().getColumn(2).setCellRenderer(customRenderer);
        this.table.getColumnModel().getColumn(3).setCellRenderer(customRenderer);
        this.table.getColumnModel().getColumn(4).setCellRenderer(customRenderer);
        this.table.getColumnModel().getColumn(5).setCellRenderer(customRenderer);
        this.table.getSelectionModel().setSelectionMode(0);
        this.table.getColumnModel().getColumn(0).setMaxWidth(16);
    }

    public void dispose() {
        if (this.table.getModel() instanceof CustomTableModel) {
            ((CustomTableModel)this.table.getModel()).dispose();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n;
        int n2 = this.table.columnAtPoint(mouseEvent.getPoint());
        if (n2 == 0 && (n = this.table.rowAtPoint(mouseEvent.getPoint())) > -1 && this.table.getModel() instanceof CustomTableModel) {
            CustomTableModel customTableModel = (CustomTableModel)this.table.getModel();
            Templates templates = customTableModel.getTemplates(n);
            SimpleNode simpleNode = customTableModel.getNode(n);
            this.files.selectNode(templates.source, simpleNode);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.maybeShowPopup(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.maybeShowPopup(mouseEvent);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.lastPopupRow == -1) {
            return;
        }
        if ("insert-template-after".equals(actionEvent.getActionCommand()) || "insert-template-before".equals(actionEvent.getActionCommand())) {
            CustomTableModel customTableModel = (CustomTableModel)this.table.getModel();
            Templates templates = customTableModel.getTemplates(this.lastPopupRow);
            XMLContainer xMLContainer = templates.source;
            SimpleNode simpleNode = customTableModel.getNode(this.lastPopupRow);
            SimpleNode simpleNode2 = new SimpleNode(1, "template");
            simpleNode2.setNameSpace(simpleNode.getNameSpacePrefix(), null);
            simpleNode2.setAttribute("match", "node()");
            simpleNode2.setClosedLeaf(false);
            int n = 0;
            n = actionEvent.getActionCommand().endsWith("before") ? simpleNode.getStartingOffset() - 1 : simpleNode.getStoppingOffset() + 1;
            try {
                xMLContainer.getDocument().insertString(n, simpleNode2.getRawXML(), null);
                xMLContainer.setLastNodeParsed(null);
                ((CustomTableModel)this.table.getModel()).refresh();
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    private void maybeShowPopup(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.lastPopupRow = this.table.rowAtPoint(mouseEvent.getPoint());
            JPopupMenu jPopupMenu = new JPopupMenu();
            JMenuItem jMenuItem = new JMenuItem("Insert a template before");
            jMenuItem.setToolTipText("Insert a new template before the current one");
            jMenuItem.setActionCommand("insert-template-before");
            jMenuItem.addActionListener(this);
            jPopupMenu.add(jMenuItem);
            jMenuItem = new JMenuItem("Insert a template after");
            jMenuItem.setToolTipText("Insert a new template after the current one");
            jMenuItem.setActionCommand("insert-template-after");
            jMenuItem.addActionListener(this);
            jPopupMenu.add(jMenuItem);
            jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.table.getTransferHandler().exportAsDrag(this.table, mouseEvent, 2);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        int n = this.table.rowAtPoint(mouseEvent.getPoint());
        int n2 = this.table.columnAtPoint(mouseEvent.getPoint());
        if (n > -1 && n2 > -1) {
            Templates templates = ((CustomTableModel)this.table.getModel()).getTemplates(n);
            this.table.setToolTipText(templates.source.getCurrentDocumentLocation());
        }
    }

    class CustomRenderer
    extends JLabel
    implements TableCellRenderer {
        public CustomRenderer() {
            this.setOpaque(true);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (jTable.getModel() instanceof CustomTableModel) {
                CustomTableModel customTableModel = (CustomTableModel)jTable.getModel();
                Templates templates = customTableModel.getTemplates(n);
                if (!bl) {
                    this.setBackground(templates.color);
                } else {
                    this.setBackground(jTable.getSelectionBackground());
                }
            }
            if (!bl) {
                this.setForeground(Color.BLACK);
            } else {
                this.setForeground(jTable.getSelectionForeground());
            }
            if (object != null) {
                this.setText(object.toString());
            } else {
                this.setText("");
            }
            return this;
        }
    }

    class EditRenderer
    extends JLabel
    implements TableCellRenderer {
        public EditRenderer() {
            this.setIcon(new ImageIcon(XSLTTemplates.class.getResource("document_edit.png")));
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            return this;
        }
    }

    class TemplateDrag
    extends TransferHandler {
        TemplateDrag() {
        }

        public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
            boolean bl = false;
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                DataFlavor dataFlavor = dataFlavorArray[i];
                if (!dataFlavor.equals(DataFlavor.stringFlavor)) continue;
                bl = true;
                break;
            }
            return bl;
        }

        protected Transferable createTransferable(JComponent jComponent) {
            return new StringSelection("row:" + XSLTTemplates.this.table.getSelectedRow());
        }

        public int getSourceActions(JComponent jComponent) {
            return 2;
        }

        public boolean importData(JComponent jComponent, Transferable transferable) {
            block7: {
                try {
                    int n;
                    String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                    if (string == null || !string.startsWith("row:")) break block7;
                    int n2 = string.lastIndexOf(":");
                    int n3 = Integer.parseInt(string.substring(n2 + 1));
                    if (n3 != (n = XSLTTemplates.this.table.getSelectedRow()) && n3 >= 0 && n >= 0) {
                        CustomTableModel customTableModel = (CustomTableModel)XSLTTemplates.this.table.getModel();
                        Templates templates = customTableModel.getTemplates(n3);
                        SimpleNode simpleNode = customTableModel.getNode(n3);
                        Templates templates2 = customTableModel.getTemplates(n);
                        SimpleNode simpleNode2 = customTableModel.getNode(n);
                        try {
                            int n4 = simpleNode.getStartingOffset();
                            int n5 = simpleNode.getStoppingOffset() - simpleNode.getStartingOffset() + 1;
                            String string2 = templates.source.getEditor().getText(n4, n5);
                            string2 = "\n" + string2 + "\n";
                            int n6 = string2.length();
                            templates2.source.getEditor().getDocument().insertString(simpleNode2.getStoppingOffset() + 1, string2, null);
                            if (templates.source == templates2.source && simpleNode2.getStoppingOffset() + 1 < n4) {
                                n4 += n6;
                            }
                            templates.source.getEditor().getDocument().remove(n4, n5);
                            templates2.source.setLastNodeParsed(null);
                            templates.source.setLastNodeParsed(null);
                        }
                        catch (BadLocationException badLocationException) {
                            ApplicationModel.debug(badLocationException);
                        }
                        customTableModel.refresh();
                    }
                    return true;
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return false;
        }
    }

    class Templates {
        XMLContainer source;
        List templates;
        Color color;

        Templates(int n, XMLContainer xMLContainer, SimpleNode simpleNode) {
            this.source = xMLContainer;
            this.color = n % 2 == 0 ? Color.WHITE : new Color(240, 240, 240);
            if (simpleNode != null) {
                for (int i = 0; i < simpleNode.childCount(); ++i) {
                    SimpleNode simpleNode2 = simpleNode.childAt(i);
                    if (!simpleNode2.matchContent("template")) continue;
                    if (this.templates == null) {
                        this.templates = new ArrayList();
                    }
                    this.templates.add(simpleNode2);
                }
            }
        }

        int getTemplatesCount() {
            if (this.templates == null) {
                return 0;
            }
            return this.templates.size();
        }

        SimpleNode getTemplateNode(int n) {
            if (this.templates == null) {
                return null;
            }
            return (SimpleNode)this.templates.get(n);
        }

        void dispose() {
            this.source = null;
            this.templates = null;
        }
    }

    class CustomTableModel
    implements TableModel {
        private List templates = null;
        private TableModelListener l;

        private CustomTableModel() {
            this.updateContent();
        }

        private void updateContent() {
            this.templates = null;
            for (int i = 0; i < XSLTTemplates.this.files.getXMLContainerCount(); ++i) {
                if (this.templates == null) {
                    this.templates = new ArrayList();
                }
                this.templates.add(new Templates(i, XSLTTemplates.this.files.getXMLContainer(i), XSLTTemplates.this.files.getXMLContainerRootNode(i)));
            }
        }

        void refresh() {
            this.updateContent();
            if (this.l != null) {
                this.l.tableChanged(new TableModelEvent(this));
            }
        }

        public void dispose() {
            if (this.templates != null) {
                for (int i = 0; i < this.templates.size(); ++i) {
                    ((Templates)this.templates.get(i)).dispose();
                }
                this.templates = null;
            }
        }

        public void addTableModelListener(TableModelListener tableModelListener) {
            this.l = tableModelListener;
        }

        public void removeTableModelListener(TableModelListener tableModelListener) {
            this.l = null;
        }

        public Class getColumnClass(int n) {
            return String.class;
        }

        public int getColumnCount() {
            return 6;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return ">";
                }
                case 1: {
                    return "file";
                }
                case 2: {
                    return "match";
                }
                case 3: {
                    return "mode";
                }
                case 4: {
                    return "name";
                }
                case 5: {
                    return "priority";
                }
            }
            return null;
        }

        public int getRowCount() {
            if (this.templates == null) {
                return 0;
            }
            int n = 0;
            for (int i = 0; i < this.templates.size(); ++i) {
                n += ((Templates)this.templates.get(i)).getTemplatesCount();
            }
            return n;
        }

        private SimpleNode getNode(int n) {
            int n2 = n;
            for (int i = 0; i < this.templates.size(); ++i) {
                Templates templates = (Templates)this.templates.get(i);
                if (n2 >= templates.getTemplatesCount()) {
                    n2 -= templates.getTemplatesCount();
                    continue;
                }
                return templates.getTemplateNode(n2);
            }
            return null;
        }

        private Templates getTemplates(int n) {
            int n2 = n;
            for (int i = 0; i < this.templates.size(); ++i) {
                Templates templates = (Templates)this.templates.get(i);
                if (n2 >= templates.getTemplatesCount()) {
                    n2 -= templates.getTemplatesCount();
                    continue;
                }
                return templates;
            }
            return null;
        }

        public Object getValueAt(int n, int n2) {
            SimpleNode simpleNode = this.getNode(n);
            switch (n2) {
                case 0: {
                    return null;
                }
                case 1: {
                    Templates templates = this.getTemplates(n);
                    String string = templates.source.getCurrentDocumentLocation();
                    if (string == null) {
                        return null;
                    }
                    int n3 = string.lastIndexOf("/");
                    if (n3 == -1) {
                        n3 = string.lastIndexOf("\\");
                    }
                    if (n3 == -1) {
                        return string;
                    }
                    return string.substring(n3 + 1);
                }
                case 2: {
                    return simpleNode.getAttribute("match");
                }
                case 3: {
                    return simpleNode.getAttribute("mode");
                }
                case 4: {
                    return simpleNode.getAttribute("name");
                }
                case 5: {
                    return simpleNode.getAttribute("priority");
                }
            }
            return null;
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 != 0 && n2 != 1;
        }

        public void setValueAt(Object object, int n, int n2) {
            SimpleNode simpleNode = this.getNode(n);
            if (simpleNode != null) {
                Templates templates;
                String string = null;
                switch (n2) {
                    case 2: {
                        string = "match";
                        break;
                    }
                    case 3: {
                        string = "mode";
                        break;
                    }
                    case 4: {
                        string = "name";
                        break;
                    }
                    case 5: {
                        string = "priority";
                    }
                }
                if (string != null && (templates = this.getTemplates(n)) != null) {
                    XMLContainer xMLContainer = templates.source;
                    XMLDocument xMLDocument = xMLContainer.getDocument();
                    if (!"".equals(object)) {
                        simpleNode.setAttribute(string, (String)object);
                    } else {
                        simpleNode.setAttribute(string, null);
                    }
                    xMLDocument.updateNodeOpeningClosing(simpleNode);
                }
            }
        }
    }
}

