/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.ui.xslt;

import com.japisoft.editix.ui.xslt.Factory;
import com.japisoft.editix.ui.xslt.LineSelectionListener;
import com.japisoft.editix.ui.xslt.Preference;
import com.japisoft.editix.ui.xslt.ResultPanel;
import com.japisoft.editix.ui.xslt.SingleFactoryImpl;
import com.japisoft.editix.ui.xslt.XMLDataSourcePanel;
import com.japisoft.editix.ui.xslt.XSLTBookmarkContext;
import com.japisoft.editix.ui.xslt.XSLTFiles;
import com.japisoft.editix.ui.xslt.XSLTFilesListener;
import com.japisoft.editix.ui.xslt.debug.DebugContext;
import com.japisoft.fastparser.node.SimpleNode;
import com.japisoft.framework.ApplicationModel;
import com.japisoft.framework.app.toolkit.Toolkit;
import com.japisoft.framework.dockable.InnerWindowProperties;
import com.japisoft.framework.dockable.JDock;
import com.japisoft.framework.dockable.JDockEvent;
import com.japisoft.framework.dockable.JDockListener;
import com.japisoft.framework.dockable.action.ActionModel;
import com.japisoft.framework.dockable.action.BasicActionModel;
import com.japisoft.framework.dockable.action.common.MaxMinAction;
import com.japisoft.framework.preferences.Preferences;
import com.japisoft.framework.xml.XMLToolkit;
import com.japisoft.xmlpad.Debug;
import com.japisoft.xmlpad.IXMLPanel;
import com.japisoft.xmlpad.XMLContainer;
import com.japisoft.xmlpad.XMLDocumentInfo;
import com.japisoft.xmlpad.bookmark.BookmarkContext;
import com.japisoft.xmlpad.editor.XMLEditor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.TransferHandler;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;

public class XSLTEditor
extends JDock
implements IXMLPanel,
ActionListener,
JDockListener,
LineSelectionListener {
    private XSLTFiles containers = null;
    private XMLDataSourcePanel xmlData = null;
    private ResultPanel resPanel = null;
    private Factory factory;
    public static String DEF_XSLTFile = null;
    public static String DEF_DATAFile = null;
    public static String DEF_RESULTFile = null;
    public static String DEBUG_PROPERTY = "xslt.debug";
    public static String DEBUG_CURRENT_LINE = "xslt.debug.line";
    public static String PROFILER_PROPERTY = "xslt.profiler";
    public static String ENCODING = "encoding";
    public static String LOADRES_CMD = "reload.res";
    public static String MAXIMIZED_CMD = "maximized.editor";
    private boolean debugMode;
    private Preference preference;
    private String fileEncoding = null;
    private String mustLoadDataFile = null;
    private boolean mustRefresh = false;
    private List listOfXPathResult = null;
    private int xpathCursor = -1;

    public XSLTEditor(XSLTFilesListener xSLTFilesListener, Factory factory, boolean bl) {
        this.factory = factory;
        this.debugMode = bl;
        this.initUI(xSLTFilesListener);
    }

    public Action getAction(String string) {
        return null;
    }

    public void setDocumentInfo(XMLDocumentInfo xMLDocumentInfo) {
        this.containers.getMainContainer().setDocumentInfo(xMLDocumentInfo);
        if ("XSLT2".equals(xMLDocumentInfo.getType())) {
            this.setInnerWindowTitleForId("xslt", "Document Type : [XSLT version 2.0]");
        } else {
            this.setInnerWindowTitleForId("xslt", "Document Type : [XSLT version 1.0]");
        }
    }

    protected void setUIReady(boolean bl) {
        if (bl) {
            for (int i = 0; i < this.containers.getXMLContainerCount(); ++i) {
                this.containers.getXMLContainer(i).getEditor().setTransferHandler(new DropSimpleNodeTransferHandler(this.containers.getXMLContainer(i).getEditor().getTransferHandler()));
            }
        }
        if (bl) {
            this.addJDockListener(this);
        } else {
            this.removeJDockListener(this);
        }
        try {
            if (Preferences.getPreference("xslt", "editing-maximized", false)) {
                this.maximizeInnerWindow("xslt");
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void showSourceLine(int n) {
        this.xmlData.showSourceLine(n);
    }

    public void showXSLTLine(String string, int n) {
        this.containers.showXSLTLine(string, n);
    }

    public BookmarkContext getBookmarkContext() {
        XSLTBookmarkContext xSLTBookmarkContext = new XSLTBookmarkContext();
        for (int i = 0; i < this.containers.getXMLContainerCount(); ++i) {
            xSLTBookmarkContext.merge(this.containers.getXMLContainer(i).getBookmarkContext(), this.containers.getXMLContainer(i));
        }
        return xSLTBookmarkContext;
    }

    protected JDock.InnerPanel createInnerView() {
        return new CustomInnerPanel();
    }

    public void setPreference(Preference preference) {
        this.preference = preference;
        this.xmlData.file.setCurrentDirectory(preference.getPreference("defaultXSLTPath"));
    }

    public XMLContainer getMainContainer() {
        return this.containers.getMainContainer();
    }

    public XMLContainer getSelectedContainer() {
        return this.containers.getSelectedContainer();
    }

    public XMLContainer getSubContainer(String string) {
        return this.xmlData.xmlContainer;
    }

    public String getXSLTFile() {
        return this.containers.getMainContainer().getDocumentInfo().getCurrentDocumentLocation();
    }

    public String getDataFile() {
        return this.xmlData.file.getText();
    }

    public void prepareToSave() {
    }

    public void postLoad() {
    }

    public boolean reload() {
        return this.containers.getMainContainer().reload();
    }

    public void setProperty(String string, Object object) {
        if ("system-end".equals(string) && this.mustLoadDataFile != null) {
            this.loadDataFile(this.mustLoadDataFile);
        }
        if (object == null) {
            this.containers.getMainContainer().setProperty(string, null);
            return;
        }
        this.containers.getMainContainer().setProperty(string, object);
        if (DEBUG_PROPERTY.equals(string)) {
            if (this.isMaximizedInnerWindow("xslt")) {
                this.restoreInnerWindow("xslt");
            }
            this.resPanel.debugContainer.updateDebugContext((DebugContext)object);
            this.resPanel.tpResultDebug.setSelectedIndex(1);
        } else if (DEBUG_CURRENT_LINE.equals(string)) {
            this.containers.showCurrentLine((String)((Object[])object)[0], (Integer)((Object[])object)[1]);
        } else if (PROFILER_PROPERTY.equals(string)) {
            this.resPanel.profilerContainer.updateProfilerContext((ArrayList)object);
            this.resPanel.tpResultDebug.setSelectedIndex(2);
        } else if ("xslt.data.file".equals(string)) {
            if (this.mustLoadDataFile != null) {
                this.mustLoadDataFile = object.toString();
            } else {
                this.loadDataFile(object.toString());
            }
        } else if (ENCODING.equals(string)) {
            this.fileEncoding = (String)object;
        } else if (MAXIMIZED_CMD.equals(string) && "true".equals(object)) {
            this.maximizeInnerWindow("xslt");
        }
    }

    public Object getProperty(String string) {
        if (MAXIMIZED_CMD.equals(string)) {
            return "" + this.isMaximizedInnerWindow("xslt");
        }
        return this.containers.getMainContainer().getProperty(string);
    }

    public Object getProperty(String string, Object object) {
        return this.containers.getMainContainer().getProperty(string, object);
    }

    public Iterator getProperties() {
        if (this.xmlData.file.getText().length() > 0) {
            this.containers.getMainContainer().setProperty("xslt.data.file", this.xmlData.file.getText());
        }
        return this.containers.getMainContainer().getProperties();
    }

    public void loadResultFile() {
        String string = (String)this.containers.getMainContainer().getProperty("xslt.result.file");
        this.resPanel.loadResultFile(string, this.fileEncoding);
    }

    public void loadDataFile(String string) {
        if (!this.mustRefresh && string.equals(this.xmlData.xmlContainer.getCurrentDocumentLocation())) {
            return;
        }
        if (this.isMaximized()) {
            this.mustLoadDataFile = string;
            return;
        }
        this.xmlData.file.setText(string);
        try {
            ApplicationModel.debug("Load DataFile " + string);
            String string2 = XMLToolkit.getContentFromURI(string, Toolkit.getCurrentFileEncoding()).getContent();
            this.xmlData.xmlContainer.getDocumentInfo().setCurrentDocumentLocation(string);
            this.xmlData.xmlContainer.setText(string2);
            this.containers.getMainContainer().setProperty("xslt.data.file", string);
            if (this.preference != null) {
                this.preference.setPreference("defaultXSLTPath", new File(string).getParent());
            }
        }
        catch (Throwable throwable) {
            this.xmlData.xmlContainer.setText("Can't load " + string + ":\n" + throwable.getMessage());
            this.xmlData.tp.setSelectedIndex(1);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = this.xmlData.file.getText();
        this.setProperty("xslt.data.file", string);
    }

    public void dispose() {
        super.dispose();
        this.containers.dispose();
        this.xmlData.dispose();
        this.resPanel.dispose();
    }

    public void setAutoDisposeMode(boolean bl) {
        this.containers.getMainContainer().setAutoDisposeMode(bl);
        this.xmlData.setAutoDisposeMode(bl);
    }

    private void initUI(XSLTFilesListener xSLTFilesListener) {
        this.setLayout(new GridBagLayout());
        this.containers = new XSLTFiles(this.factory, xSLTFilesListener);
        this.addInnerWindow(new InnerWindowProperties("xslt", "XSLT Document", this.containers), (Object)new GridBagConstraints(0, 0, 2, 2, 1.0, 2.0, 10, 1, new Insets(1, 1, 0, 2), 0, 0));
        this.xmlData = new XMLDataSourcePanel(this.factory);
        this.xmlData.file.setActionListener(this);
        this.xmlData.setPreferredSize(new Dimension(300, 200));
        BasicActionModel basicActionModel = new BasicActionModel(new Action[]{new RefreshAction(), ActionModel.SEPARATOR, new MaxMinAction()});
        this.addInnerWindow(new InnerWindowProperties("data", "XML Data source", null, basicActionModel, this.xmlData), (Object)new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 1, 1, 0), 0, 0));
        this.resPanel = new ResultPanel(this.factory, this.debugMode, this);
        this.addInnerWindow(new InnerWindowProperties("result", "XSLT Result Preview", this.resPanel), (Object)new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 1, 2), 0, 0));
    }

    public void jdockAction(JDockEvent jDockEvent) {
        if ("xslt".equals(jDockEvent.getId())) {
            if (jDockEvent.getType() == 1) {
                if (this.containers != null) {
                    this.containers.getMainContainer().setProperty(MAXIMIZED_CMD, "true");
                }
            } else if (jDockEvent.getType() == 7) {
                if (this.containers != null) {
                    this.containers.getMainContainer().setProperty(MAXIMIZED_CMD, "false");
                }
                if (this.mustLoadDataFile != null) {
                    this.loadDataFile(this.mustLoadDataFile);
                    this.mustLoadDataFile = null;
                }
            }
        }
    }

    boolean isMaximized() {
        if (this.containers == null) {
            return false;
        }
        return "true".equals(this.containers.getMainContainer().getProperty(MAXIMIZED_CMD));
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.setBounds(10, 10, 500, 500);
        jFrame.getContentPane().add(new XSLTEditor(null, new SingleFactoryImpl(), false).getView());
        jFrame.setVisible(true);
    }

    class RefreshAction
    extends AbstractAction {
        public RefreshAction() {
            ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("refresh.png"));
            this.putValue("SmallIcon", imageIcon);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (XSLTEditor.this.getProperty("xslt.data.file") != null) {
                XSLTEditor.this.mustRefresh = true;
                XSLTEditor.this.setProperty("xslt.data.file", XSLTEditor.this.getProperty("xslt.data.file"));
                XSLTEditor.this.mustRefresh = false;
            }
        }
    }

    static class InsertValueOfAction
    extends AbstractAction {
        private String prefix;
        private String matching;
        private String tab;
        private XMLEditor editorTmp;

        public InsertValueOfAction(XMLEditor xMLEditor, String string, String string2, String string3) {
            this.putValue("Name", "Insert a value-of for '" + string3 + "'");
            this.tab = string;
            this.prefix = string2;
            this.matching = string3;
            this.editorTmp = xMLEditor;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            StringBuffer stringBuffer = new StringBuffer("\n");
            stringBuffer.append(this.tab);
            stringBuffer.append("<");
            stringBuffer.append(this.prefix);
            stringBuffer.append("value-of select=\"").append(this.matching).append("\"/>\n");
            this.editorTmp.insertText(stringBuffer.toString());
            this.editorTmp = null;
        }
    }

    static class InsertForEachAction
    extends AbstractAction {
        private String prefix;
        private String matching;
        private String tab;
        private XMLEditor editorTmp;

        public InsertForEachAction(XMLEditor xMLEditor, String string, String string2, String string3) {
            this.putValue("Name", "Insert a for-each block");
            this.editorTmp = xMLEditor;
            this.tab = string;
            this.prefix = string2;
            this.matching = string3;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            StringBuffer stringBuffer = new StringBuffer("\n");
            stringBuffer.append(this.tab);
            stringBuffer.append("<");
            stringBuffer.append(this.prefix);
            stringBuffer.append("for-each select=\"").append(this.matching).append("\">\n");
            stringBuffer.append(this.tab);
            stringBuffer.append("</").append(this.prefix).append("for-each>\n");
            this.editorTmp.insertText(stringBuffer.toString());
            this.editorTmp = null;
        }
    }

    static class DropSimpleNodeTransferHandler
    extends TransferHandler {
        private TransferHandler source = null;

        public DropSimpleNodeTransferHandler(TransferHandler transferHandler) {
            this.source = transferHandler;
        }

        public void exportAsDrag(JComponent jComponent, InputEvent inputEvent, int n) {
            this.source.exportAsDrag(jComponent, inputEvent, n);
        }

        public void exportToClipboard(JComponent jComponent, Clipboard clipboard, int n) {
            this.source.exportToClipboard(jComponent, clipboard, n);
        }

        public int getSourceActions(JComponent jComponent) {
            return this.source.getSourceActions(jComponent);
        }

        public Icon getVisualRepresentation(Transferable transferable) {
            return this.source.getVisualRepresentation(transferable);
        }

        public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
            if (dataFlavorArray.length > 0 && dataFlavorArray[0].getRepresentationClass() == SimpleNode.class) {
                return true;
            }
            return this.source.canImport(jComponent, dataFlavorArray);
        }

        public boolean importData(JComponent jComponent, Transferable transferable) {
            block18: {
                try {
                    String string;
                    Object object = transferable.getTransferData(transferable.getTransferDataFlavors()[0]);
                    if (!(object instanceof SimpleNode)) break block18;
                    SimpleNode simpleNode = (SimpleNode)object;
                    XMLEditor xMLEditor = (XMLEditor)jComponent;
                    int n = xMLEditor.getCaretPosition();
                    SimpleNode simpleNode2 = xMLEditor.getXMLContainer().getCurrentElementNode();
                    if (simpleNode2 == null) {
                        simpleNode2 = xMLEditor.getXMLContainer().getRootNode();
                    }
                    if (simpleNode2 == null) {
                        return false;
                    }
                    String string2 = simpleNode2.getDocument().getRoot().getNameSpacePrefix();
                    string2 = string2 == null ? "" : string2 + ":";
                    int n2 = simpleNode2.getStartingOffset();
                    int n3 = xMLEditor.getDocument().getDefaultRootElement().getElementIndex(n2);
                    Element element = xMLEditor.getDocument().getDefaultRootElement().getElement(n3);
                    int n4 = element.getStartOffset();
                    try {
                        string = xMLEditor.getDocument().getText(n4, n2 - n4);
                    }
                    catch (BadLocationException badLocationException) {
                        string = "";
                    }
                    string = string + "\t";
                    StringBuffer stringBuffer = new StringBuffer("\n").append(string);
                    String string3 = null;
                    string3 = simpleNode.isText() ? "text()" : simpleNode.getNodeContent();
                    if (simpleNode2.matchContent("stylesheet")) {
                        stringBuffer.append("<");
                        stringBuffer.append(string2);
                        stringBuffer.append("template match=\"").append(string3).append("\">\n");
                        if (!simpleNode.isLeaf()) {
                            stringBuffer.append(string);
                            stringBuffer.append(string);
                            stringBuffer.append("<").append(string2).append("apply-templates/>\n");
                        }
                        stringBuffer.append(string);
                        stringBuffer.append("</").append(string2).append("template").append(">\n");
                        xMLEditor.insertText(stringBuffer.toString());
                        return true;
                    }
                    XMLEditor xMLEditor2 = (XMLEditor)jComponent;
                    try {
                        String string4 = null;
                        for (SimpleNode simpleNode3 = simpleNode2; simpleNode3 != null; simpleNode3 = simpleNode3.getSimpleParent()) {
                            if (simpleNode3.hasAttribute("match")) {
                                string4 = simpleNode3.getAttribute("match");
                                break;
                            }
                            if (!simpleNode3.hasAttribute("select")) continue;
                            string4 = simpleNode3.getAttribute("select");
                            break;
                        }
                        if (string4 != null) {
                            int n5;
                            int n6 = string4.lastIndexOf("/");
                            if (n6 > -1) {
                                string4 = string4.substring(n6 + 1);
                            }
                            if ((n5 = string4.indexOf("[")) > -1) {
                                string4 = string4.substring(0, n5);
                            }
                            String string5 = simpleNode.getXPathLocation();
                            int n7 = (string5 = string5.replaceAll("\\[\\d+\\]", "")).indexOf("/" + string4 + "/");
                            string3 = n7 > -1 ? string5.substring(n7 + 2 + string4.length()) : string5;
                        }
                        Rectangle rectangle = xMLEditor.modelToView(n);
                        JPopupMenu jPopupMenu = new JPopupMenu();
                        jPopupMenu.add(new InsertForEachAction(xMLEditor2, string, string2, string3));
                        jPopupMenu.add(new InsertValueOfAction(xMLEditor2, string, string2, string3));
                        for (int i = 0; i < simpleNode.getViewAttributeCount(); ++i) {
                            jPopupMenu.add(new InsertValueOfAction(xMLEditor2, string, string2, "@" + simpleNode.getViewAttributeAt(i)));
                        }
                        jPopupMenu.show(jComponent, rectangle.x, rectangle.y);
                        return true;
                    }
                    catch (BadLocationException badLocationException) {
                    }
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                }
                catch (IOException iOException) {
                }
                catch (RuntimeException runtimeException) {
                    Debug.debug(runtimeException);
                }
            }
            return this.source.importData(jComponent, transferable);
        }
    }

    class CustomInnerPanel
    extends JDock.InnerPanel
    implements IXMLPanel {
        CustomInnerPanel() {
            super(XSLTEditor.this);
        }

        public void dispose() {
        }

        public void setAutoDisposeMode(boolean bl) {
            XSLTEditor.this.setAutoDisposeMode(bl);
        }

        public XMLContainer getMainContainer() {
            return XSLTEditor.this.containers.getMainContainer();
        }

        public BookmarkContext getBookmarkContext() {
            return XSLTEditor.this.getBookmarkContext();
        }

        public XMLContainer getSelectedContainer() {
            return XSLTEditor.this.containers.getSelectedContainer();
        }

        public void setDocumentInfo(XMLDocumentInfo xMLDocumentInfo) {
            XSLTEditor.this.containers.getMainContainer().setDocumentInfo(xMLDocumentInfo);
        }

        public Action getAction(String string) {
            return null;
        }

        public Iterator getProperties() {
            return XSLTEditor.this.getProperties();
        }

        public Object getProperty(String string, Object object) {
            return XSLTEditor.this.getProperty(string, object);
        }

        public Object getProperty(String string) {
            return XSLTEditor.this.getProperty(string);
        }

        public XMLContainer getSubContainer(String string) {
            return XSLTEditor.this.getSubContainer(string);
        }

        public void prepareToSave() {
            if (XSLTEditor.this.containers.getSelectedContainer() == null || !XSLTEditor.this.containers.getSelectedContainer().isModified()) {
                for (int i = 0; i < XSLTEditor.this.containers.getXMLContainerCount(); ++i) {
                    XMLContainer xMLContainer = XSLTEditor.this.containers.getXMLContainer(i);
                    if (!xMLContainer.isModified()) continue;
                    XSLTEditor.this.containers.setSelectedComponent(xMLContainer.getView());
                    break;
                }
            }
            XSLTEditor.this.containers.resetVisualState(XSLTEditor.this.containers.getSelectedContainer());
        }

        public void postLoad() {
        }

        public boolean reload() {
            return XSLTEditor.this.reload();
        }

        public JComponent getView() {
            return this;
        }

        public void setProperty(String string, Object object) {
            if (LOADRES_CMD.equals(string)) {
                XSLTEditor.this.loadResultFile();
            } else {
                XSLTEditor.this.setProperty(string, object);
            }
            if (MAXIMIZED_CMD.equals(string)) {
                if ("true".equals(object)) {
                    XSLTEditor.this.maximizeInnerWindow("xslt");
                } else {
                    XSLTEditor.this.restoreInnerWindow("xslt");
                }
            }
        }
    }
}

