/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.ui.xsd;

import com.japisoft.editix.ui.xsd.CustomActionListener;
import com.japisoft.editix.ui.xsd.Factory;
import com.japisoft.editix.ui.xsd.SingleFactoryImpl;
import com.japisoft.editix.ui.xsd.VisualXSDEditor;
import com.japisoft.editix.ui.xsd.XSDEditorObserver;
import com.japisoft.editix.ui.xsd.toolkit.SchemaHelper;
import com.japisoft.fastparser.node.SimpleNode;
import com.japisoft.framework.ApplicationModel;
import com.japisoft.framework.job.Job;
import com.japisoft.framework.job.JobManager;
import com.japisoft.framework.preferences.Preferences;
import com.japisoft.xmlpad.IXMLPanel;
import com.japisoft.xmlpad.XMLContainer;
import com.japisoft.xmlpad.XMLDocumentInfo;
import com.japisoft.xmlpad.action.ActionModel;
import com.japisoft.xmlpad.action.xml.FormatAction;
import com.japisoft.xmlpad.bookmark.BookmarkContext;
import com.japisoft.xmlpad.xml.validator.DefaultValidator;
import java.util.Date;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XSDEditor
extends JTabbedPane
implements IXMLPanel,
ChangeListener {
    private XMLContainer container = null;
    private Factory factory = null;
    private VisualXSDEditor editor = null;
    private XSDEditorObserver observer = null;
    private Document schemaRoot = null;

    public XSDEditor(Factory factory) {
        super(3);
        this.factory = factory;
        this.container = factory.buildNewContainer();
        this.addTab("Source Editor", new ImageIcon(this.getClass().getResource("document_edit.png")), this.container.getView());
        this.editor = new VisualXSDEditor(factory);
        this.addTab("Visual Editor", new ImageIcon(this.getClass().getResource("flash.png")), this.editor.getView());
    }

    public void setDocumentInfo(XMLDocumentInfo xMLDocumentInfo) {
        this.container.setDocumentInfo(xMLDocumentInfo);
    }

    public void setCustomActionListener(CustomActionListener customActionListener) {
        this.editor.setCustomActions(customActionListener);
    }

    public void setObserver(XSDEditorObserver xSDEditorObserver) {
        this.observer = xSDEditorObserver;
    }

    public Action getAction(String string) {
        if (this.getSelectedIndex() == 1) {
            if ("copy".equals(string)) {
                return this.editor.getCopyAction();
            }
            if ("paste".equals(string)) {
                return this.editor.getPasteAction();
            }
            if ("cut".equals(string)) {
                return this.editor.getCutAction();
            }
        }
        return null;
    }

    public void addNotify() {
        super.addNotify();
        this.addChangeListener(this);
    }

    public void removeNotify() {
        super.removeNotify();
        this.removeChangeListener(this);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (this.getSelectedIndex() == 1) {
            this.observer.switchToView(this, true);
            DefaultValidator defaultValidator = new DefaultValidator(true);
            if (!defaultValidator.validate(this.container, false)) {
                this.factory.buildAndShowErrorDialog("Error found inside the source\nPlease fix it before using the visual editor");
                this.setSelectedIndex(0);
            } else {
                Document document = defaultValidator.getDocument();
                SchemaHelper.cleanEmptyTextNode(document);
                if (document.getDocumentElement() == null) {
                    Element element = document.createElementNS("http://www.w3.org/2001/XMLSchema", "xs:schema");
                    document.appendChild(element);
                    Element element2 = SchemaHelper.createElement(this.schemaRoot.getDocumentElement(), "myElement");
                    document.getDocumentElement().appendChild(element2);
                } else {
                    Element element = document.getDocumentElement();
                    if (!"http://www.w3.org/2001/XMLSchema".equals(element.getNamespaceURI())) {
                        this.factory.buildAndShowErrorDialog("Wrong namespace for the root element, wait for 'http://www.w3.org/2001/XMLSchema'\nPlease fix it");
                        this.setSelectedIndex(0);
                    } else if (!"schema".equals(element.getLocalName())) {
                        this.factory.buildAndShowErrorDialog("Wrong name for the root element, wait for 'schema'\nPlease fix it");
                        this.setSelectedIndex(0);
                    } else {
                        this.schemaRoot = document;
                        if (!SchemaHelper.hasChildrenExceptAnnotationAndText(document.getDocumentElement())) {
                            Element element3 = SchemaHelper.createElement(this.schemaRoot.getDocumentElement(), "myElement");
                            SchemaHelper.createNewAnnotation(document.getDocumentElement(), "Created with EditiX (http://www.editix.com) at " + new Date());
                            document.getDocumentElement().appendChild(element3);
                        }
                        this.editor.init(document.getDocumentElement());
                        if (this.container.getCurrentElementNode() != null) {
                            this.editor.select(this.container.getCurrentElementNode().getXPathLocation());
                        }
                    }
                }
            }
        } else {
            this.stopEditing(false);
            this.observer.switchToView(this, false);
        }
    }

    private void stopEditing(boolean bl) {
        if (this.schemaRoot != null) {
            Element element = this.editor.getSelectedElement();
            this.editor.stopEditing();
            FormatAction formatAction = (FormatAction)ActionModel.getActionByName(ActionModel.FORMAT_ACTION);
            XMLContainer xMLContainer = formatAction.getXMLContainer();
            formatAction.setXMLContainer(this.container);
            formatAction.formatAction(this.schemaRoot);
            formatAction.setXMLContainer(xMLContainer);
            if (!bl) {
                this.schemaRoot = null;
            }
            if (element != null) {
                String string = SchemaHelper.getXPathExpression(element);
                JobManager.addJob(new SelectedElementJob(string));
            }
        }
    }

    public void dispose() {
        this.container.dispose();
    }

    public void postLoad() {
    }

    public void prepareToSave() {
        this.setSelectedIndex(0);
        this.stopEditing(true);
    }

    public boolean reload() {
        this.setSelectedIndex(0);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                XSDEditor.this.container.reload();
            }
        });
        return true;
    }

    public XMLContainer getMainContainer() {
        return this.container;
    }

    public BookmarkContext getBookmarkContext() {
        return null;
    }

    public XMLContainer getSelectedContainer() {
        return null;
    }

    public Iterator getProperties() {
        return this.container.getProperties();
    }

    public Object getProperty(String string, Object object) {
        return this.container.getProperty(string, object);
    }

    public Object getProperty(String string) {
        return this.container.getProperty(string);
    }

    public XMLContainer getSubContainer(String string) {
        return this.container.getSubContainer(string);
    }

    public JComponent getView() {
        return this;
    }

    public void setAutoDisposeMode(boolean bl) {
        this.container.setAutoDisposeMode(bl);
    }

    public void setProperty(String string, Object object) {
        this.container.setProperty(string, object);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.setSize(400, 400);
        ApplicationModel.SHORT_APPNAME = "editix";
        Preferences.loadPreferences();
        XSDEditor xSDEditor = new XSDEditor(new SingleFactoryImpl());
        jFrame.getContentPane().add(xSDEditor.getView());
        xSDEditor.getMainContainer().setText("<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema'></xs:schema>");
        jFrame.setVisible(true);
    }

    class SelectedElementJob
    implements Job {
        private String xpath;

        SelectedElementJob(String string) {
            this.xpath = string;
        }

        public void dispose() {
        }

        public Object getSource() {
            return this;
        }

        public boolean isAlone() {
            return false;
        }

        public void run() {
            SimpleNode simpleNode;
            SimpleNode simpleNode2 = XSDEditor.this.container.getRootNode();
            if (simpleNode2 != null && (simpleNode = simpleNode2.getNodeForXPathLocation(this.xpath, true)) != null) {
                try {
                    XSDEditor.this.container.getEditor().requestFocus();
                    XSDEditor.this.container.getEditor().setCaretPosition(simpleNode.getStartingOffset() + 1);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        public void stopIt() {
        }
    }
}

